function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Vikram N 
 */

/*eslint-env browser */ /*jshint browser: true */

/**
* API Status: **Private**
* @module nmodule/videoDriver/rc/live/PanTiltStage
*/

define(['baja!', 'jquery', 'underscore', 'baja!videoDriver:VideoPanTiltEnum'], function (baja, $, _, types) {
  'use strict';

  var stageX = 0;
  var stageY = 0;
  var DEFAULT_MOVE_INTERVAL = 1000;
  var STAGE_HEIGHT = 100;
  var STAGE_WIDTH = 100;
  var MOVE_EVENT = 'move';
  var getUpperLeftRegionCoordinates = function getUpperLeftRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageX, stageWidth * 0.25, stageWidth * 0.4, stageX];
    var yCoords = [stageY, stageY, stageHeight * 0.4, stageHeight * 0.25];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var getUpperRegionCoordinates = function getUpperRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageWidth * 0.25, stageWidth * 0.75, stageWidth * 0.6, stageWidth / 2, stageWidth * 0.4];
    var yCoords = [stageY, stageY, stageHeight * 0.4, stageHeight / 2, stageHeight * 0.4];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var getUpperRightRegionCoordinates = function getUpperRightRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageWidth, stageWidth, stageWidth * 0.6, stageWidth * 0.75];
    var yCoords = [stageY, stageHeight * 0.25, stageHeight * 0.4, stageY];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var getLeftRegionCoordinates = function getLeftRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageX, stageWidth * 0.4, stageWidth / 2, stageWidth * 0.4, stageX];
    var yCoords = [stageHeight * 0.25, stageHeight * 0.4, stageHeight / 2, stageHeight * 0.6, stageHeight * 0.75];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var getRightRegionCoordinates = function getRightRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageWidth, stageWidth * 0.6, stageWidth / 2, stageWidth * 0.6, stageWidth];
    var yCoords = [stageHeight * 0.25, stageHeight * 0.4, stageHeight / 2, stageHeight * 0.6, stageHeight * 0.75];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var getLowerLeftRegionCoordinates = function getLowerLeftRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageX, stageWidth * 0.25, stageWidth * 0.4, stageX];
    var yCoords = [stageHeight, stageHeight, stageHeight * 0.6, stageHeight * 0.75];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var getLowerRegionCoordinates = function getLowerRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageWidth * 0.25, stageWidth * 0.75, stageWidth * 0.6, stageWidth / 2, stageWidth * 0.4];
    var yCoords = [stageHeight, stageHeight, stageHeight * 0.6, stageHeight / 2, stageHeight * 0.6];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var getLowerRightRegionCoordinates = function getLowerRightRegionCoordinates(stageHeight, stageWidth) {
    var xCoords = [stageWidth, stageWidth, stageWidth * 0.6, stageWidth * 0.75];
    var yCoords = [stageHeight, stageHeight * 0.75, stageHeight * 0.6, stageHeight];
    return {
      'xCoords': xCoords,
      'yCoords': yCoords
    };
  };
  var makeSlowRegion = function makeSlowRegion(stageWidth, stageHeight) {
    var rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
    var width = stageWidth * 0.65;
    var height = stageHeight * 0.65;
    var x = (stageWidth - width) / 2;
    var y = (stageHeight - height) / 2;
    rect.setAttribute('x', x);
    rect.setAttribute('y', y);
    rect.setAttribute('width', width - x);
    rect.setAttribute('height', height - y);
    rect.setAttribute('class', 'slow');
    return rect;
  };
  var makeMediumRegion = function makeMediumRegion(stageWidth, stageHeight) {
    var rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
    rect.setAttribute('x', stageX);
    rect.setAttribute('y', stageY);
    rect.setAttribute('width', stageWidth);
    rect.setAttribute('height', stageHeight);
    rect.setAttribute('class', 'medium');
    return rect;
  };
  var makeRegions = function makeRegions(stageWidth, stageHeight) {
    var regionsMap = new baja.OrderedMap();
    regionsMap.put('upperLeft', getUpperLeftRegionCoordinates(stageHeight, stageWidth));
    regionsMap.put('upper', getUpperRegionCoordinates(stageHeight, stageWidth));
    regionsMap.put('upperRight', getUpperRightRegionCoordinates(stageHeight, stageWidth));
    regionsMap.put('left', getLeftRegionCoordinates(stageHeight, stageWidth));
    regionsMap.put('right', getRightRegionCoordinates(stageHeight, stageWidth));
    regionsMap.put('lowerLeft', getLowerLeftRegionCoordinates(stageHeight, stageWidth));
    regionsMap.put('lower', getLowerRegionCoordinates(stageHeight, stageWidth));
    regionsMap.put('lowerRight', getLowerRightRegionCoordinates(stageHeight, stageWidth));
    return regionsMap;
  };
  var makePolygon = function makePolygon(regionName, points) {
    var polygon = document.createElementNS('http://www.w3.org/2000/svg', 'polygon');
    polygon.setAttribute('points', points);
    polygon.setAttribute('class', regionName);
    return polygon;
  };
  var getVideoPanTiltAction = function getVideoPanTiltAction(actionTag) {
    return baja.$('videoDriver:VideoPanTiltEnum', actionTag);
  };
  var getActionClass = function getActionClass(str) {
    var pattern = '\\bupperLeft\\b|\\bupper\\b|\\bupperRight\\b|\\bleft\\b|\\bright\\b|\\blowerLeft\\b|\\blower\\b|\\blowerRight\\b';
    var match = str.match(pattern);
    if (match) {
      return match[0];
    }
    return '';
  };

  /**
   * 
   * @param {string} speed the pan tilt speed (slow/medium/fast)
   * @param {string} direction the pan tilt direction
   * @returns {baja.FrozenEnum|string} a 'videoDriver:VideoPanTiltEnum' enum
   */
  var getPanTiltAction = function getPanTiltAction(speed, direction) {
    var panTiltAction = getVideoPanTiltAction('none'); // default 'none' action
    switch (speed) {
      case 'slow':
        {
          switch (direction) {
            case 'lowerLeft':
              {
                panTiltAction = getVideoPanTiltAction('panLeftTiltDownSlow');
                break;
              }
            case 'lower':
              {
                panTiltAction = getVideoPanTiltAction('tiltDownSlow');
                break;
              }
            case 'lowerRight':
              {
                panTiltAction = getVideoPanTiltAction('panRightTiltDownSlow');
                break;
              }
            case 'left':
              {
                panTiltAction = getVideoPanTiltAction('panLeftSlow');
                break;
              }
            case 'right':
              {
                panTiltAction = getVideoPanTiltAction('panRightSlow');
                break;
              }
            case 'upperLeft':
              {
                panTiltAction = getVideoPanTiltAction('panLeftTiltUpSlow');
                break;
              }
            case 'upper':
              {
                panTiltAction = getVideoPanTiltAction('tiltUpSlow');
                break;
              }
            case 'upperRight':
              {
                panTiltAction = getVideoPanTiltAction('panRightTiltUpSlow');
                break;
              }
            default:
              {
                panTiltAction = getVideoPanTiltAction('none');
              }
          }
          break;
        }
      case 'medium':
        {
          switch (direction) {
            case 'lowerLeft':
              {
                panTiltAction = getVideoPanTiltAction('panLeftTiltDownMedium');
                break;
              }
            case 'lower':
              {
                panTiltAction = getVideoPanTiltAction('tiltDownMedium');
                break;
              }
            case 'lowerRight':
              {
                panTiltAction = getVideoPanTiltAction('panRightTiltDownMedium');
                break;
              }
            case 'left':
              {
                panTiltAction = getVideoPanTiltAction('panLeftMedium');
                break;
              }
            case 'right':
              {
                panTiltAction = getVideoPanTiltAction('panRightMedium');
                break;
              }
            case 'upperLeft':
              {
                panTiltAction = getVideoPanTiltAction('panLeftTiltUpMedium');
                break;
              }
            case 'upper':
              {
                panTiltAction = getVideoPanTiltAction('tiltUpMedium');
                break;
              }
            case 'upperRight':
              {
                panTiltAction = getVideoPanTiltAction('panRightTiltUpMedium');
                break;
              }
            default:
              {
                panTiltAction = getVideoPanTiltAction('none');
              }
          }
          break;
        }
      case 'fast':
        {
          switch (direction) {
            case 'lowerLeft':
              {
                panTiltAction = getVideoPanTiltAction('panLeftTiltDownFast');
                break;
              }
            case 'lower':
              {
                panTiltAction = getVideoPanTiltAction('tiltDownFast');
                break;
              }
            case 'lowerRight':
              {
                panTiltAction = getVideoPanTiltAction('panRightTiltDownFast');
                break;
              }
            case 'left':
              {
                panTiltAction = getVideoPanTiltAction('panLeftFast');
                break;
              }
            case 'right':
              {
                panTiltAction = getVideoPanTiltAction('panRightFast');
                break;
              }
            case 'upperLeft':
              {
                panTiltAction = getVideoPanTiltAction('panLeftTiltUpFast');
                break;
              }
            case 'upper':
              {
                panTiltAction = getVideoPanTiltAction('tiltUpFast');
                break;
              }
            case 'upperRight':
              {
                panTiltAction = getVideoPanTiltAction('panRightTiltUpFast');
                break;
              }
            default:
              {
                panTiltAction = getVideoPanTiltAction('none');
              }
          }
          break;
        }
      default:
        {
          panTiltAction = getVideoPanTiltAction('none');
        }
    }
    return panTiltAction;
  };

  /**
   * Pant and Tilt stage for mouse and touch events
   *  
   * @class
   * @see 'videoDriver:VideoPanTiltJoystick' for region computation
   * @alias module:nmodule/videoDriver/rc/live/PanTiltStage
   * @param {object} [params]
   * @param {number} [params.moveInterval=1000] how often to fire move events
   */
  var PanTiltStage = /*#__PURE__*/function () {
    function PanTiltStage(dom) {
      _classCallCheck(this, PanTiltStage);
      this.jq = dom;
    }
    return _createClass(PanTiltStage, [{
      key: "initStage",
      value: function initStage() {
        var rootSvgEl = this.$getRootSvgJq()[0];
        var width = STAGE_HEIGHT;
        var height = STAGE_WIDTH;
        rootSvgEl.appendChild(makeMediumRegion(width, height));
        rootSvgEl.appendChild(makeSlowRegion(width, height));
        var regionsMap = makeRegions(width, height);
        _.forEach(regionsMap.getKeys(), function (key) {
          var region = regionsMap.get(key);
          var points = _.zip(region.xCoords, region.yCoords).map(function (coords) {
            return coords.join(',');
          }).join(' ');

          // append region
          rootSvgEl.appendChild(makePolygon(key, points));
        });
        this.$armHandlers(this.$getRootSvgJq());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getStageDom",
      value: function $getStageDom() {
        return this.jq;
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getRootSvgJq",
      value: function $getRootSvgJq() {
        return this.$getStageDom().find('svg');
      }

      /**
       * @private
       * @returns {number}
       */
    }, {
      key: "$getMoveInterval",
      value: function $getMoveInterval() {
        return this.$moveInterval || DEFAULT_MOVE_INTERVAL;
      }

      /**
       * @param {number} moveInterval how often to fire move events
       */
    }, {
      key: "setMoveInterval",
      value: function setMoveInterval(moveInterval) {
        this.$moveInterval = moveInterval;
      }

      /**
       * Register all the mouse events on the stage
       * 
       * @private
       * @param {SVGElement} svg
       */
    }, {
      key: "$armHandlers",
      value: function $armHandlers(svg) {
        var _this = this;
        var direction, speed, lastX, lastY, lastMovedDirection;
        var getPageX = function getPageX(e) {
          if (e.touches && e.touches.length > 0) {
            return e.touches[0].pageX;
          } else {
            return e.pageX || e.clientX + $(window).scrollLeft();
          }
        };
        var getPageY = function getPageY(e) {
          if (e.touches && e.touches.length > 0) {
            return e.touches[0].pageY;
          } else {
            return e.pageY || e.clientY + $(window).scrollTop();
          }
        };
        var getDirection = function getDirection(e) {
          var pageX = getPageX(e);
          var pageY = getPageY(e);
          if (!isFinite(pageX)) {
            pageX = lastX;
          }
          if (!isFinite(pageY)) {
            pageY = lastY;
          }
          return document.elementFromPoint(pageX, pageY);
        };
        var resetRegions = function resetRegions() {
          svg.find('polygon').toggleClass('ptHighlight', false);
          $(direction).toggleClass('ptEnd', true);
        };
        var reset = function reset() {
          // Always follow with a 'none' on mouseup
          _this.$move(getVideoPanTiltAction('none'));
          resetTicket();
          resetRegions();
          // de-register the events
          svg.unbind();
          // rebind start
          svg.on('mousedown touchstart', moveStart);
        };
        var resetTicket = function resetTicket() {
          if (_this.$ticket) {
            clearTimeout(_this.$ticket);
          }
        };

        /**
         * Convenience to get the rectangle slow/medium region beneath the polygon
         * 
         * @param {Event} e 
         */
        var getSpeed = function getSpeed(e) {
          return getDirection(e);
        };
        var _move = function move() {
          var moveAction = getPanTiltAction(speed.className.baseVal, getActionClass(direction.className.baseVal));
          _this.$ticket = setTimeout(function () {
            return _move();
          }, _this.$getMoveInterval());
          throttled(moveAction);
        };
        var _moveFast = function moveFast() {
          if (lastMovedDirection) {
            var moveAction = getPanTiltAction('fast', getActionClass(lastMovedDirection.className.baseVal));
            _this.$ticket = setTimeout(function () {
              return _moveFast();
            }, _this.$getMoveInterval());
            throttled(moveAction);
          }
        };
        var throttled = baja.throttle(function (moveAction) {
          return _this.$move(moveAction);
        }, {
          interval: 500,
          drop: true
        });
        var moveStart = function moveStart(e) {
          // Arm mousemove
          svg.on('mousemove touchmove', function (e) {
            direction = getDirection(e);
            if (direction && direction.nodeName === 'polygon') {
              lastMovedDirection = direction;
              resetRegions();
              $(direction).toggleClass('ptHighlight', true);
              $(direction).toggleClass('ptEnd', false);
              // hide the polygon to show the rectangular region under it
              var polygonDisplay = direction.style.display;
              direction.style.display = 'none';
              speed = getSpeed(e);
              direction.style.display = polygonDisplay;
              resetTicket();
              return direction && speed && _move();
            } else {
              // A wandering touch event will get you here, just move fast in the last direction touched
              resetTicket();
              return _moveFast();
            }
          });

          // Arm mouseup
          $(document).off('mouseup touchend', reset);
          $(document).one('mouseup touchend', reset);
          svg.one('mouseleave', function () {
            resetTicket();
            _moveFast();
          });
          return false;
        };
        svg.on('mousedown touchstart', moveStart);
      }

      /**
       * @private
       * @param {baja.FrozenEnum} moveAction a 'videoDriver:VideoPanTiltEnum' enum
       */
    }, {
      key: "$move",
      value: function $move(moveAction) {
        this.$getStageDom().trigger(MOVE_EVENT, moveAction);
      }
    }], [{
      key: "STAGE_HEIGHT",
      get: function get() {
        return STAGE_HEIGHT;
      }
    }, {
      key: "STAGE_WIDTH",
      get: function get() {
        return STAGE_WIDTH;
      }
    }, {
      key: "MOVE_EVENT",
      get: function get() {
        return MOVE_EVENT;
      }
    }]);
  }();
  return PanTiltStage;
});
