function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */
/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/surveillance/SurveillanceViewerGrid
 */
define(['baja!', 'bajaux/Widget', 'bajaux/icon/iconUtils', 'log!nmodule.videoDriver.rc.fe.surveillance.SurveillanceViewerGrid', 'jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/videoDriver/rc/fe/surveillance/surveillanceViewerEvents', 'nmodule/videoDriver/rc/live/LiveVideo', 'lex!videoDriver', 'baja!videoDriver:VideoMultistreamLayoutTypesEnum,videoDriver:VideoMultistreamAspectRatioEnum', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, Widget, iconUtils, log, $, Promise, _, events, Command, CommandButton, subscriberMixIn, fe, BaseEditor, surveillanceViewerEvents, LiveVideo, lexs, types) {
  'use strict';

  var logFine = log.fine.bind(log);
  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var noVideoLabel = lex.getSafe('SurveillanceViewer.DefaultGrid.Label');

  /* Template start */
  var noCameraTpl = function noCameraTpl() {
    return "<span class=\"gridText\">".concat(noVideoLabel, "</span>");
  };
  var grid1x1Tpl = function grid1x1Tpl() {
    return "<div class=\"camera blackBackground gridContainer1x1 camera1\"/>";
  };
  var grid2x2Tpl = function grid2x2Tpl() {
    return "<div class=\"gridContainer2x2\">\n                                <div class=\"camera blackBackground camera1\"/>\n                                <div class=\"camera blackBackground camera2\"/>\n                                <div class=\"camera blackBackground camera3\"/>\n                                <div class=\"camera blackBackground camera4\"/>\n                            </div>";
  };
  var grid3x3Tpl = function grid3x3Tpl() {
    return "<div class=\"gridContainer3x3\">\n                                <div class=\"camera blackBackground camera1\"/>\n                                <div class=\"camera blackBackground camera2\"/>\n                                <div class=\"camera blackBackground camera3\"/>\n                                <div class=\"camera blackBackground camera4\"/>\n                                <div class=\"camera blackBackground camera5\"/>\n                                <div class=\"camera blackBackground camera6\"/>\n                                <div class=\"camera blackBackground camera7\"/>\n                                <div class=\"camera blackBackground camera8\"/>\n                                <div class=\"camera blackBackground camera9\"/>\n                              </div>\n                            </div>";
  };
  var gridPiPTpl = function gridPiPTpl() {
    return "<div class=\"PictureInPictureGridContainer\">\n                             <div class=\"camera blackBackground camera1 LiveVideoBig\"/>\n                             <div class=\"camera blackBackground camera2 LiveVideoSmallLowerLeft\"/>\n                            </div>";
  };
  var grid2Big1LargeTpl = function grid2Big1LargeTpl() {
    return "<div class=\"gridContainer2x1\">\n                                    <div class=\"camera blackBackground camera1\"/>\n                                    <div class=\"camera blackBackground camera2\"/>\n                                    <div class=\"camera blackBackground containerX2 camera3\"/>\n                                  </div>";
  };

  /* Template end */

  var LAYOUT_ENUM = baja.$('videoDriver:VideoMultistreamLayoutTypesEnum');

  /**
   * SurveillanceViewerGrid is a parent class for all grid implementations
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/surveillance/SurveillanceViewerGrid
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @param {Object} params
   */
  var SurveillanceViewerGrid = /*#__PURE__*/function (_BaseEditor) {
    function SurveillanceViewerGrid(params) {
      var _this;
      _classCallCheck(this, SurveillanceViewerGrid);
      _this = _callSuper(this, SurveillanceViewerGrid, [_.extend({
        keyName: 'SurveillanceViewerGrid',
        moduleName: 'videoDriver'
      }, params)]);
      _this.layoutType = LAYOUT_ENUM.make(0);
      if (params.properties) {
        _this.layoutType = params.properties.layoutType || _this.layoutType;
      }
      subscriberMixIn(_this);
      return _this;
    }

    /**
     * Initializes the dom for SurveillanceViewerGrid.
     *
     * @param {JQuery} dom
     */
    _inherits(SurveillanceViewerGrid, _BaseEditor);
    return _createClass(SurveillanceViewerGrid, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.html(this.$getGridType()).addClass('SurveillanceViewerGrid');
        return iconUtils.toHtml(['module://icons/x16/refresh.png'], true).then(function (html) {
          html = $(html);
          _this2.$refreshImgJq = $(html.get(0)).addClass('inGridRefreshContainer');
        });
      }

      /**
       * Loads the camera list on to the grid.
       *
       * @param {baja.Component} value
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;
        if (baja.hasType(value, 'videoDriver:VideoPlaybackMultistream')) {
          var promiseArray = [];
          return this.$getAllCameras(value).then(function (inputCameraArray) {
            if (inputCameraArray && inputCameraArray.length > 0) {
              var cameraElements = _this3.$getCameraElements();
              for (var i = 0; i < cameraElements.length; i++) {
                // Break from loop if we are running out of cameras.
                var cameraElement = $(cameraElements[i]);
                if (_.isUndefined(inputCameraArray[i])) {
                  _this3.$addNoCameraElement(cameraElement);
                  continue;
                }
                promiseArray.push(fe.buildFor({
                  formFactor: 'mini',
                  dom: cameraElement,
                  type: _this3.$getType(inputCameraArray[i]),
                  value: inputCameraArray[i],
                  properties: {
                    showPtzAndPresets: false,
                    aspectRatio: value.getAspectRatio()
                  }
                }));
              }
            } else {
              _toConsumableArray(_this3.$getCameraElements()).forEach(function (cameraElement) {
                _this3.$addNoCameraElement(cameraElement);
              });
            }
            return Promise.all(promiseArray).then(function (cameraList) {
              // To make both jasmine and browser happy.
              _this3.$cameraList = cameraList;
              return Promise.all(_toConsumableArray(_this3.$getCameraElements()).map(function (cameraElement) {
                _this3.$addEventHandlers(cameraElement);
                _this3.$hidePresetsAndControls(cameraElement);
                return _this3.$addRefreshCameraElement(cameraElement);
              }));
            });
          });
        } else {
          throw new Error('Invalid type');
        }
      }

      /**
       * @private
       * @param {JQuery} cameraElement
       */
    }, {
      key: "$hidePresetsAndControls",
      value: function $hidePresetsAndControls(cameraElement) {
        $(cameraElement).find('.CameraPresetsWidget').hide();
        $(cameraElement).find('.cameraControlsContainer').hide();
      }

      /**
       * @private
       * @param {JQuery} cameraElement
       */
    }, {
      key: "$addNoCameraElement",
      value: function $addNoCameraElement(cameraElement) {
        $(cameraElement).append(noCameraTpl());
        $(cameraElement).addClass('relativeGridTextPosition');
      }

      /**
       * Refresh camera element will be added to every camera in an absolute right top position.
       *
       * @private
       * @param {jquery} cameraElement
       * @return {Promise}
       */
    }, {
      key: "$addRefreshCameraElement",
      value: function $addRefreshCameraElement(cameraElement) {
        var _this4 = this;
        var element = $(cameraElement);
        element.append(this.$refreshImgJq.clone());
        return fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: element.find('.inGridRefreshContainer'),
          value: new Command({
            module: 'videoDriver',
            lex: 'refreshGridCommand',
            func: function func() {
              var widget;
              if (widget = Widget["in"](element)) {
                _this4.$loadLiveVideoWidget(element, widget.value())["catch"](baja.error);
              }
            }
          })
        });
      }

      /**
       * Callback to add the event handlers.
       *
       * @private
       * @param {JQuery} cameraElement
       * @param {Number} index
       */
    }, {
      key: "$addEventHandlers",
      value: function $addEventHandlers(cameraElement) {
        var _this5 = this;
        // Removing the zoomEnabled as it's adding no useful padding for the LiveVideo.
        $(cameraElement).removeClass('zoomEnabled');
        $(cameraElement).on('click', function (event) {
          _this5.$clickHandler(event);
          return false;
        });
        this.$addDragDropEventHandlers(cameraElement);
      }

      /**
       * Callback to add the drag drop event handlers.
       *
       * @private
       * @param {JQuery} cameraElement
       * @param {Number} index
       */
    }, {
      key: "$addDragDropEventHandlers",
      value: function $addDragDropEventHandlers(cameraElement) {
        var _this6 = this;
        if (!this.value().getPermissions().hasAdminWrite()) {
          return;
        }
        $(cameraElement).on('drop', function (event) {
          // Resolving the camera to provide it to the LiveVideo.
          $(event.currentTarget).removeClass('greenBackground');
          $(event.currentTarget).addClass('blackBackground');
          _this6.$dropHandler(event)["catch"](baja.error);
          return false;
        }).on('dragover', function (event) {
          $(event.currentTarget).removeClass('blackBackground');
          $(event.currentTarget).addClass('greenBackground');
          return false;
        }).on('dragleave', function (event) {
          $(event.currentTarget).removeClass('greenBackground');
          $(event.currentTarget).addClass('blackBackground');
          return false;
        });
      }

      /**
       * @private
       * @param {Event} event
       * @returns {Promise}
       */
    }, {
      key: "$dropHandler",
      value: function $dropHandler(event) {
        var _this7 = this;
        return baja.Ord.make(event.originalEvent.dataTransfer.getData('text/plain')).get().then(function (gridObject) {
          var gridWidget = Widget["in"](event.currentTarget);
          // As soon as the drop is successful the state is considered to be modified.
          _this7.jq().trigger(events.MODIFY_EVENT);
          // If the grid was empty initially and upon on drop create a new fe.
          if (_.isUndefined(gridWidget)) {
            $(event.currentTarget).removeClass('relativeGridTextPosition');
            return _this7.$loadLiveVideoWidget($(event.currentTarget), gridObject);
          } else {
            return gridWidget.load(gridObject).then(function () {
              _this7.$hidePresetsAndControls(gridWidget.jq());
            })["catch"](function (error) {
              logFine('Camera drop action cannot be saved', error);
            });
          }
        })["catch"](function (error) {
          logFine('Camera drop failed', error);
        });
      }

      /**
       * Loads live video widget for drag-drop action and refresh action.
       *
       * @private
       * @param {jquery} dom
       * @param {baja.Component} gridObject
       * @returns {Promise}
       */
    }, {
      key: "$loadLiveVideoWidget",
      value: function $loadLiveVideoWidget(dom, gridObject) {
        var _this8 = this;
        return fe.buildFor({
          formFactor: 'mini',
          dom: dom,
          type: this.$getType(gridObject),
          value: gridObject,
          properties: {
            showPtzAndPresets: false,
            aspectRatio: this.value().getAspectRatio()
          }
        }).then(function (liveVideoWidget) {
          _this8.$addEventHandlers(liveVideoWidget.jq());
          _this8.$hidePresetsAndControls(liveVideoWidget.jq());
          return _this8.$addRefreshCameraElement(liveVideoWidget.jq());
        });
      }

      /**
       * @private
       * @param {Object} obj
       * @returns {baja.Type}
       */
    }, {
      key: "$getType",
      value: function $getType(obj) {
        return LiveVideo;
      }

      /**
       * Handler for the click on camera cell grid event.
       *
       * @private
       * @param {Event} event
       */
    }, {
      key: "$clickHandler",
      value: function $clickHandler(event) {
        var cameraWidget = Widget["in"](event.currentTarget);
        // Camera widget will be undefined if target is an empty cell.
        if (cameraWidget) {
          var ord = cameraWidget.$value.getNavOrd();
          if (this.$isLinkable(ord)) {
            var normalizedOrd = ord.normalize();
            if (window.niagara && window.niagara.env) {
              window.niagara.env.hyperlink(normalizedOrd);
            } else {
              window.location.assign(normalizedOrd.toUri());
            }
          }
        }
      }

      /**
       * Returns the valid camera list.
       *
       * @private
       * @param {baja.Component} value
       * @returns {Promise}
       */
    }, {
      key: "$getAllCameras",
      value: function $getAllCameras(value) {
        var cameraPromArray = [];
        // Surveillance viewer supports camera index 1 to 16.
        for (var i = 1; i <= 16; i++) {
          var cameraOrd = value['getCamera' + i]();
          if (cameraOrd.isNull()) {
            cameraPromArray.push(Promise.resolve());
          } else {
            cameraPromArray.push(cameraOrd.get());
          }
        }

        // Filters any invalid camera saved in the viewer property sheet.
        return Promise.all(cameraPromArray.map(function (promise) {
          return promise.then(function (value) {
            return {
              value: value
            };
          }, function () {
            return {
              rejected: true
            };
          });
        })).then(function (results) {
          return results.filter(function (r) {
            return !r.rejected;
          });
        }).then(function (successes) {
          return successes.map(function (s) {
            return s.value;
          });
        });
      }

      /**
       * Returns the camera holding div element array.
       *
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCameraElements",
      value: function $getCameraElements() {
        return this.jq().find('.camera');
      }

      /**
       * DOM for a specific type of SurveillanceViewerGrid will be returned.
       *
       * @private
       * @returns {string}
       */
    }, {
      key: "$getGridType",
      value: function $getGridType() {
        switch (this.layoutType) {
          case LAYOUT_ENUM.make(0):
            return grid1x1Tpl();
          case LAYOUT_ENUM.make(1):
            return gridPiPTpl();
          case LAYOUT_ENUM.make(2):
            return grid2Big1LargeTpl();
          case LAYOUT_ENUM.make(3):
            return grid2x2Tpl();
          case LAYOUT_ENUM.make(4):
            return grid3x3Tpl();
        }
      }

      /**
       * Returns true if the passed ord is a valid one.
       *
       * @param {baja.Ord} ord
       * @returns {boolean}
       */
    }, {
      key: "$isLinkable",
      value: function $isLinkable(ord) {
        return !!ord && ord !== baja.Ord.DEFAULT;
      }

      /**
       * Saves the widget.
       *
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        var _this9 = this;
        return Promise.all(_toConsumableArray(Array(16).keys()).map(function (index) {
          var cameraId = 'camera' + (index + 1);
          // Get the latest camera ord value from the grid.
          var liveVideoWidget = _this9.jq().find(".".concat(cameraId)).data('widget');
          // If they are different then save.
          if (liveVideoWidget) {
            var currentCameraOrd = liveVideoWidget.value().getNavOrd();
            // Get the initial camera ord value from the viewer.
            var initialCameraOrd = _this9.value()["get".concat(cameraId.capitalizeFirstLetter())]();
            if (!initialCameraOrd.equivalent(currentCameraOrd)) {
              return _this9.value().set({
                slot: cameraId,
                value: currentCameraOrd
              });
            }
          }
        }));
      }

      /**
       * Destroys the widget.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('SurveillanceViewerGrid');
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseEditor);
  return SurveillanceViewerGrid;
});
