function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */
/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget
 */
define(['baja!', 'bajaux/Widget', 'jquery', 'underscore', 'Promise', 'dialogs', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/videoDriver/rc/fe/surveillance/surveillanceViewerEvents', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'bajaux/commands/Command', 'bajaux/util/SaveCommand', 'bajaux/util/CommandButton', 'lex!videoDriver', 'baja!videoDriver:VideoMultistreamAspectRatioEnum', 'baja!videoDriver:VideoFrameRateEnum', 'baja!videoDriver:VideoResolutionEnum', 'baja!videoDriver:VideoCompressionEnum', 'baja!videoDriver:VideoMultistreamLayoutTypesEnum', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, Widget, $, _, Promise, dialogs, events, subscriberMixIn, fe, BaseEditor, surveillanceViewerEvents, OrderedMapEditor, Command, SaveCommand, CommandButton, lexs) {
  'use strict';

  var ASPECT_RATIO_ENUM = baja.$('videoDriver:VideoMultistreamAspectRatioEnum');
  var FRAME_RATE_ENUM = baja.$('videoDriver:VideoFrameRateEnum');
  var RESOLUTION_ENUM = baja.$('videoDriver:VideoResolutionEnum');
  var COMPRESSION_ENUM = baja.$('videoDriver:VideoCompressionEnum');
  var LAYOUT_ENUM = baja.$('videoDriver:VideoMultistreamLayoutTypesEnum');
  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var tpl = function tpl() {
    return "<div class=\"SurveillanceOptionsContainer\"> \n                      <div class=\"feContainer\"> \n                        <span class=\"aspectRatioText\">".concat(lex.getSafe('VideoMultistreamViewer.ChooseAspectRatio'), "</span>\n                        <div class=\"aspectRatio\" />\n                        <span class=\"frameRateText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseFrameRate'), "</span>\n                        <div class=\"frameRate\"></div>\n                        <span class=\"resolutionText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseResolution'), "</span>\n                        <div class=\"resolution\"></div> \n                        <span class=\"compressionText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseCompression'), "</span>\n                        <div class=\"compression\"></div>\n                        <span class=\"layoutText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseLayout'), "</span>\n                        <div class=\"layout\"></div>\n                      </div>\n                     </div>");
  };

  /**
   * SurveillanceOptionsWidget will represent the configuration options for the SurveillanceViewer
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @param {Object} params
   */
  var SurveillanceOptionsWidget = /*#__PURE__*/function (_BaseEditor) {
    function SurveillanceOptionsWidget(params) {
      var _this;
      _classCallCheck(this, SurveillanceOptionsWidget);
      _this = _callSuper(this, SurveillanceOptionsWidget, [params]);
      subscriberMixIn(_this);
      return _this;
    }

    /**
     * Initializes the widget
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(SurveillanceOptionsWidget, _BaseEditor);
    return _createClass(SurveillanceOptionsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('SurveillanceOptionsWidget');
      }

      /**
       * Reads the child widgets and applies those values on to a new copy of the value.
       * doRead invocation will happen out of the lifecycle methods from WebSurveillanceViewer,
       * we send a new changed copy back to validate with the current value.
       *
       * @returns {Promise}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this2 = this;
        return this.getChildWidgets().readAll().then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 5),
            aspectRatio = _ref2[0],
            frameRate = _ref2[1],
            resolution = _ref2[2],
            compression = _ref2[3],
            layout = _ref2[4];
          var newCopy = _this2.value().newCopy();
          var promArray = [];
          if (!_.isUndefined(aspectRatio)) {
            promArray.push(newCopy.set({
              slot: 'aspectRatio',
              value: aspectRatio
            }));
          }
          if (!_.isUndefined(frameRate)) {
            promArray.push(newCopy.set({
              slot: 'frameRate',
              value: frameRate
            }));
          }
          if (!_.isUndefined(resolution)) {
            promArray.push(newCopy.set({
              slot: 'resolution',
              value: resolution
            }));
          }
          if (!_.isUndefined(layout)) {
            promArray.push(newCopy.set({
              slot: 'layout',
              value: layout
            }));
          }
          if (!_.isUndefined(compression)) {
            promArray.push(newCopy.set({
              slot: 'compression',
              value: compression
            }));
          }
          return Promise.all(promArray).then(function () {
            return newCopy;
          });
        });
      }

      /**
       * Saves the widget
       *
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        var _this3 = this;
        return Promise.all(this.getChildWidgets().map(function (child) {
          if (child.isModified()) {
            return child.read().then(function (modifiedChild) {
              var slotName;
              switch (modifiedChild.getType()) {
                case ASPECT_RATIO_ENUM.getType():
                  slotName = 'aspectRatio';
                  break;
                case FRAME_RATE_ENUM.getType():
                  slotName = 'frameRate';
                  break;
                case RESOLUTION_ENUM.getType():
                  slotName = 'resolution';
                  break;
                case COMPRESSION_ENUM.getType():
                  slotName = 'compression';
                  break;
                case LAYOUT_ENUM.getType():
                  slotName = 'layout';
                  break;
              }
              return _this3.value().set({
                slot: slotName,
                value: modifiedChild
              });
            });
          }
        }));
      }

      /**
       * Loads the widget
       *
       * @param {baja.Component} value
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this4 = this;
        if (baja.hasType(value, 'videoDriver:VideoPlaybackMultistream')) {
          var promArr = [];
          if (!value.getHideAspectRatio()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: ASPECT_RATIO_ENUM,
              dom: this.jq().find('.aspectRatio'),
              value: value.getAspectRatio()
            }));
          } else {
            this.jq().find('.aspectRatioText').hide();
            this.jq().find('.aspectRatio').hide();
          }
          if (!value.getHideFrameRate()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: FRAME_RATE_ENUM,
              dom: this.jq().find('.frameRate'),
              value: value.getFrameRate()
            }));
          } else {
            this.jq().find('.frameRateText').hide();
            this.jq().find('.frameRate').hide();
          }
          if (!value.getHideResolution()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: RESOLUTION_ENUM,
              dom: this.jq().find('.resolution'),
              value: value.getResolution()
            }));
          } else {
            this.jq().find('.resolutionText').hide();
            this.jq().find('.resolution').hide();
          }
          if (!value.getHideCompression()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: COMPRESSION_ENUM,
              dom: this.jq().find('.compression'),
              value: value.getCompression()
            }));
          } else {
            this.jq().find('.compressionText').hide();
            this.jq().find('.compression').hide();
          }
          if (!value.getHideLayout()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: OrderedMapEditor,
              dom: this.jq().find('.layout'),
              value: this.$getOrderedLayoutMap(),
              loadParams: {
                selectedValue: this.value().getLayout()
              },
              properties: {
                lexicon: 'videoDriver',
                lexiconIcons: true
              }
            }));
          } else {
            this.jq().find('.layoutText').hide();
            this.jq().find('.layout').hide();
          }
          return Promise.all(promArr).then(function () {
            return _this4.getChildWidgets().setAllEnabled(_this4.value().getPermissions().hasAdminWrite());
          });
        } else {
          throw new Error('Invalid type');
        }
      }

      /**
       * Returns the frameRate widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getFrameRateWidget",
      value: function $getFrameRateWidget() {
        return Widget["in"](this.jq().find('.frameRate'));
      }

      /**
       * Returns the aspectRatio widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAspectRatioWidget",
      value: function $getAspectRatioWidget() {
        return Widget["in"](this.jq().find('.aspectRatio'));
      }

      /**
       * Returns the resolution widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getResolutionWidget",
      value: function $getResolutionWidget() {
        return Widget["in"](this.jq().find('.resolution'));
      }

      /**
       * Returns the compression widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCompressionWidget",
      value: function $getCompressionWidget() {
        return Widget["in"](this.jq().find('.compression'));
      }

      /**
       * Returns the layout widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLayoutWidget",
      value: function $getLayoutWidget() {
        return Widget["in"](this.jq().find('.layout'));
      }

      /**
       * Function gets the map of icons to be fetched from videoDriver module
       *
       * @private
       * @returns {baja.OrderedMap}
       */
    }, {
      key: "$getOrderedLayoutMap",
      value: function $getOrderedLayoutMap() {
        var map = new baja.OrderedMap();
        map.put('oneVideoPlayer', LAYOUT_ENUM.make(0));
        map.put('pictureInPictureLowerLeft', LAYOUT_ENUM.make(1));
        map.put('twoSmallOneLarge', LAYOUT_ENUM.make(2));
        map.put('grid2x2', LAYOUT_ENUM.make(3));
        map.put('grid3x3', LAYOUT_ENUM.make(4));
        return map;
      }

      /**
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('SurveillanceOptionsWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseEditor);
  return SurveillanceOptionsWidget;
});
