function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */
/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'lex!videoDriver', 'nmodule/videoDriver/rc/rpc/rpc', 'underscore', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, $, Promise, subscriberMixIn, fe, BaseEditor, lexs, rpc, _) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var cameraListLabel = lex.getSafe('SurveillanceViewer.CameraList.Label');
  var tpl = function tpl() {
    return "<span class=\"title\">".concat(cameraListLabel, "</span>\n                     <div class=\"deviceList\"></div>");
  };

  /**
   * Trims the given ord down to only the slot part.
   * @param {string} ordString
   * @returns {string}
   */
  var trimToSlotPath = function trimToSlotPath(ordString) {
    return ordString === "null" ? "null" : /slot:\/(.)*/.exec(ordString)[0];
  };

  /**
   * DeviceListWidget will represent the camera list created for the SurveillanceViewer
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  var DeviceListWidget = /*#__PURE__*/function (_BaseEditor) {
    function DeviceListWidget() {
      _classCallCheck(this, DeviceListWidget);
      return _callSuper(this, DeviceListWidget, arguments);
    }
    _inherits(DeviceListWidget, _BaseEditor);
    return _createClass(DeviceListWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('DeviceListWidget');
      }
    }, {
      key: "$getDeviceJq",
      value: function $getDeviceJq(value, index) {
        var deviceValue = _.escape(value);
        return "<div class=\"deviceBox box".concat(index, "\" title=\"").concat(deviceValue, "\" draggable=\"true\">\n                <img src=\"/module/videoDriver/icons/camera.png\" >\n                <span>").concat(deviceValue, "</span>\n              </div>");
      }

      /**
       * Creates the camerabox dom for each camera along with it's event listeners
       *
       * @private
       * @param {Array<Object>} deviceListObj
       * @param {JQuery} dom
       */
    }, {
      key: "$createDeviceListJq",
      value: function $createDeviceListJq(deviceListObj, dom) {
        var _this = this;
        var deviceListJq = dom.find('.deviceList');
        Object.keys(deviceListObj).forEach(function (key, index) {
          var deviceObjValue = deviceListObj[key];
          var deviceJq = _this.$getDeviceJq(deviceObjValue, index);
          deviceListJq.append(deviceJq);
          deviceListJq.find('.box' + index).on('dragstart', {
            value: 'station:|' + key
          }, function (event) {
            _this.$dragStartHandler(event);
          });
        });
      }

      /**
       * @private
       * @param {Event} event
       */
    }, {
      key: "$dragStartHandler",
      value: function $dragStartHandler(event) {
        event.originalEvent.dataTransfer.setData('text/plain', event.data.value);
      }

      /**
       * This method gets the list of added cameras in the station and excludes
       * the ones present in getExcludeCameras of Surveillance Viewer instance.
       *
       * This method can be overriden to provide custom devices.
       *
       * @returns {Promise}
       */
    }, {
      key: "getAddedDevices",
      value: function getAddedDevices(device) {
        var cameraListObj = {};
        var excludedCameraOrds = device.getExcludeCameras().getOrds().map(function (ord) {
          return trimToSlotPath(ord.toString());
        });
        return rpc.getAllCameras().then(function (deviceArray) {
          deviceArray.forEach(function (device) {
            var tokenDevice = device.split("|");
            var displayName = baja.SlotPath.unescape(tokenDevice[0]);
            var slotPath = baja.SlotPath.unescape(tokenDevice[1]);
            if (excludedCameraOrds.indexOf(slotPath) === -1) {
              cameraListObj[slotPath] = displayName;
            }
          });
          return cameraListObj;
        });
      }

      /**
       * Loads the value into the CameraList
       *
       * @param {baja.Component} value a `videoDriver:VideoPlaybackMultistream` instance
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        if (!baja.hasType(value, "videoDriver:VideoPlaybackMultistream")) {
          throw new Error('CameraList must be loaded with videoDriver:VideoPlaybackMultistream');
        }
        return this.$doLoad(value);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doLoad",
      value: function $doLoad(device) {
        var _this2 = this;
        return this.getAddedDevices(device).then(function (deviceListObj) {
          _this2.$createDeviceListJq(deviceListObj, _this2.jq());
        });
      }

      /**
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('DeviceListWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseEditor);
  return DeviceListWidget;
});
