function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/* eslint-env browser  */

/**
 * API Status: **Private**
 * @module  module:nmodule/videoDriver/rc/alarm/VideoCameraChooser
 */
define(['baja!', 'nmodule/webEditors/rc/wb/links/OrdChooser', 'nmodule/webEditors/rc/wb/tree/BajaComplexTreeNode', 'lex!videoDriver', 'baja!videoDriver:IVideoCamera', 'baja!baja:Component'], function (baja, OrdChooser, BajaComplexTreeNode, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    videoDriverLex = _lexs[0];
  /**
   * An editor for selecting a videoDriver:IVideoSource.
   * @class
   * @alias module:nmodule/videoDriver/rc/alarm/VideoCameraChooser
   * @extends module:nmodule/webEditors/rc/wb/links/OrdChooser
   */
  var VideoCameraChooser = function VideoCameraChooser() {
    OrdChooser.apply(this, arguments);
    this.properties().add("rootNode", "station:|slot:/Drivers");
    this.properties().add("displayFilter", function (parent, child) {
      return child instanceof BajaComplexTreeNode && baja.hasType(child.value(), 'baja:Component');
    });
    this.properties().add("selectFilter", function (selected) {
      if (selected !== baja.Ord.DEFAULT) {
        return selected.get().then(function (value) {
          if (!value.getType().is('videoDriver:IVideoCamera')) {
            throw new Error(videoDriverLex.getSafe("VideoCameraChooser.invalidSelection"));
          }
        });
      }
    });
  };
  VideoCameraChooser.prototype = Object.create(OrdChooser.prototype);
  VideoCameraChooser.prototype.constructor = VideoCameraChooser;
  return VideoCameraChooser;
});
