function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/SourceCollection
 */
define(['nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/model/Item', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/util/securityDashboardUtil', 'lex!nss'], function (Entity, Item, ItemCollection, securityDashboardUtil, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    nssLex = _lexs[0];

  /**
   * Collection of all items in a dashboard, from all sources. Items will be
   * organized by source into an array of ItemCollections.
   *
   * @class
   * @alias module:nmodule/nss/rc/model/SourceCollection
   * @param {object} params
   * @param {module:nmodule/nss/rc/model/Entity} params.sourceEntity source entity for source collection
   * @param {module:nmodule/nss/rc/model/ItemCollection[]} [params.itemCollections=[]] - array of item collections, default will be an empty array
   * @param {Date | null} [params.timestamp=null] should be null if generated from a station; returns Date if generated from a supervisor rollup
   * @throws {Error} if sourceEntity is missing or itemCollection is not valid
   */
  return /*#__PURE__*/function () {
    function SourceCollection() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        sourceEntity = _ref.sourceEntity,
        _ref$itemCollections = _ref.itemCollections,
        itemCollections = _ref$itemCollections === void 0 ? [] : _ref$itemCollections,
        _ref$timestamp = _ref.timestamp,
        timestamp = _ref$timestamp === void 0 ? null : _ref$timestamp;
      _classCallCheck(this, SourceCollection);
      if (!(sourceEntity instanceof Entity)) {
        throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.entity.error'));
      }
      if (!isValidItemCollection(itemCollections)) {
        throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.itemCollection.error'));
      }
      if (!(timestamp === null || timestamp instanceof Date)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.date.invalid'));
      }
      this.$timestamp = timestamp;
      this.$sourceEntity = sourceEntity;
      this.$itemCollections = itemCollections || [];
    }

    /**
     * @returns {Date} Date at origin.
     */
    return _createClass(SourceCollection, [{
      key: "getTimestamp",
      value: function getTimestamp() {
        return this.$timestamp;
      }

      /**
       * @returns {module:nmodule/nss/rc/model/Entity} source Entity of the source item collection
       * e.g. station or supervisor
       */
    }, {
      key: "getSourceEntity",
      value: function getSourceEntity() {
        return this.$sourceEntity;
      }

      /**
       * @returns {module:nmodule/nss/rc/model/ItemCollection[]} array of item collections
       */
    }, {
      key: "getItemCollections",
      value: function getItemCollections() {
        return this.$itemCollections.slice();
      }

      /**
       * @param {string} ord ORD of the item collection which is required
       * @returns {module:nmodule/nss/rc/model/ItemCollection | null} Item collection with the matching source ord
       */
    }, {
      key: "getItemCollection",
      value: function getItemCollection(ord) {
        var resultCollection = null;
        for (var i = 0; i < this.$itemCollections.length; i++) {
          if (this.$itemCollections[i].getSourceEntity().getOrd() === ord) {
            resultCollection = this.$itemCollections[i];
          }
        }
        return resultCollection;
      }

      /**
       * Update an item collection
       * 
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection 
       */
    }, {
      key: "updateItemCollection",
      value: function updateItemCollection(itemCollection) {
        for (var i = 0; i < this.$itemCollections.length; i++) {
          if (this.$itemCollections[i].getSourceEntity().equals(itemCollection.getSourceEntity())) {
            this.$itemCollections[i] = itemCollection;
          }
        }
      }

      /**
       * @returns {number} total count of items in all the item collections
       */
    }, {
      key: "getItemCount",
      value: function getItemCount() {
        var totalItemCountInCollection = 0;
        for (var i = 0; i < this.$itemCollections.length; i++) {
          totalItemCountInCollection = totalItemCountInCollection + this.$itemCollections[i].getItemCount();
        }
        return totalItemCountInCollection;
      }

      /**
       * @returns {Object[]} Array of objects with severity and counts from all the item collections
       */
    }, {
      key: "getCountsBySeverity",
      value: function getCountsBySeverity() {
        var itemCollections = this.$itemCollections;
        var countsBySeverityObjects = {},
          countsBySeverityArray = [];
        itemCollections.forEach(function (itemCollection) {
          itemCollection.getCountsBySeverity().forEach(function (countsBySeverityInCollection) {
            var severity = countsBySeverityInCollection.severity;
            var severityName = severity.getName();
            var severityCount = countsBySeverityInCollection.count;
            if (countsBySeverityObjects[severityName]) {
              countsBySeverityObjects[severityName].count += severityCount;
            } else {
              countsBySeverityObjects[severityName] = {
                severity: severity,
                count: severityCount
              };
              countsBySeverityArray.push(countsBySeverityObjects[severityName]);
            }
          });
        });
        return sortCountsBySeverityByPriority(countsBySeverityArray);
      }
    }]);
  }();

  /**
   * @param {module:nmodule/nss/rc/model/ItemCollection[]} itemCollectionList is list of items of type Item
   * @returns {boolean} true if itemCollection is valid and false if invalid
   */
  function isValidItemCollection(itemCollectionList) {
    if (itemCollectionList) {
      if (Array.isArray(itemCollectionList)) {
        return itemCollectionList.every(function (itemCollection) {
          return itemCollection instanceof ItemCollection;
        });
      } else {
        return false;
      }
    }
    return true;
  }

  /**
   * Sorts the countsBySeverityObject from highest to lowest priority.
   * @static
   * @param {Object[]} countsBySeverityObject  is an array of objects of severity and count
   * @returns {Object[]} sorted severityObjects by priority
   */
  function sortCountsBySeverityByPriority(countsBySeverityObject) {
    return countsBySeverityObject.sort(function (severity1, severity2) {
      return severity2.severity.getPriority() - severity1.severity.getPriority();
    });
  }
});
