function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/Severity
 */
define([], function () {
  'use strict';

  /**
   * Class representing a configured severity level, e.g. "caution" or
   * "critical".
   *
   * @class
   * @alias module:nmodule/nss/rc/model/Severity
   * @param {object} params
   * @param {string} [params.displayName=params.name] severity display name
   * @param {string[]} [params.icon=[]] array of strings that define an icon
   * for this severity level
   * @param {string} params.name severity name
   * @param {number} params.priority severity priority
   * @throws {Error} if name or priority is missing
   */
  return /*#__PURE__*/function () {
    function Severity() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        displayName = _ref.displayName,
        icon = _ref.icon,
        name = _ref.name,
        priority = _ref.priority;
      _classCallCheck(this, Severity);
      if (typeof name !== 'string') {
        throw new Error('name required');
      }
      if (typeof priority !== 'number') {
        throw new Error('priority required');
      }
      this.$displayName = displayName || name;
      this.$icon = icon || [];
      this.$name = name;
      this.$priority = priority;
    }

    /**
     * @returns {string} severity display name
     */
    return _createClass(Severity, [{
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$displayName;
      }

      /**
       * @returns {string[]} severity icon
       */
    }, {
      key: "getIcon",
      value: function getIcon() {
        return this.$icon;
      }

      /**
       * @returns {string} severity name
       */
    }, {
      key: "getName",
      value: function getName() {
        return this.$name;
      }

      /**
       * @returns {number} severity priority
       */
    }, {
      key: "getPriority",
      value: function getPriority() {
        return this.$priority;
      }
    }]);
  }();
});
