function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/ItemCollectionSummaryWidget
 */
define(['baja!', 'lex!nss', 'log!nmodule.nss.rc.fe.ItemCollectionSummaryWidget', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'jquery', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/nss/rc/fe/SeverityWidget', 'nmodule/nss/rc/fe/ItemsArrayCompositeEditor', 'nmodule/nss/rc/fe/ItemCollectionDetailsWidget', 'nmodule/nss/rc/fe/CountsBySeverityWidget', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/util/securityDashboardUtil', 'nmodule/webChart/rc/donut/DonutChartWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/BaseWidget', 'css!nmodule/nss/rc/nss'], function (baja, lexicon, log, Widget, Command, CommandButton, $, Promise, asyncUtils, SeverityWidget, ItemsArrayCompositeEditor, ItemCollectionDetailsWidget, CountsBySeverityWidget, ItemCollection, securityDashboardUtil, DonutChartWidget, feDialogs, BaseWidget) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
    nssLex = _lexicon[0];
  var REFRESHING = nssLex.get('SecurityDashboardView.itemCollectionSummary.refreshing');
  var waitInterval = asyncUtils.waitInterval;
  var getSeverityColors = securityDashboardUtil.getSeverityColors,
    getTypeAndCountForSeverity = securityDashboardUtil.getTypeAndCountForSeverity,
    isLinkable = securityDashboardUtil.isLinkable;
  var logSevere = log.severe.bind(log);
  var REFRESH_TIMEOUT = 5000;
  var TIMESTAMP_UPDATE_INTERVAL = 60000;
  var getTemplate = function getTemplate() {
    return "\n      <div class=\"LeftContainer\">\n        <div class = \"EntityContainer\">\n          <span class=\"SeverityWidget\" />\n          <span class=\"EntityHeader entityName\"><a class=\"entityNameLink\" /></span>\n        </div>\n        <div class=\"TsRefreshContainer\">\n          <span class=\"Refresh\" />\n          <span class=\"Timestamp\" />\n        </div>\n        <div class=\"DonutChartContainer\" />\n        <div class=\"CountsBySeverityWidget\" />\n      </div>\n      <div class=\"RightWrapper\">\n        <div class=\"RightContainer\">\n          <div class=\"ItemsContainer\" />\n        </div>\n        <div class=\"MoreContainer\">\n          <a href=\"#\">".concat(nssLex.getSafe('SecurityDashboardView.itemCollectionSummary.more.text'), "</a>\n        </div>\n      </div>");
  };

  /**
   * Displays the ItemCollectionSummary as a card in the Security Dashboard.
   *
   * It supports the following bajaux Properties:
   *
   * - `dashboardService`: IDashboardService used to retrieve new
   *   ItemCollection data from the server.
   * - `baseOrd`: a base ORD used when requesting a new ItemCollection.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/ItemCollectionSummaryWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @see module:nmodule/nss/rc/rpc/rpc.IDashboardService
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function ItemCollectionSummaryWidget() {
      _classCallCheck(this, ItemCollectionSummaryWidget);
      return _callSuper(this, ItemCollectionSummaryWidget, arguments);
    }
    _inherits(ItemCollectionSummaryWidget, _BaseWidget);
    return _createClass(ItemCollectionSummaryWidget, [{
      key: "$showItemCollectionDetailsDialog",
      value:
      /**
       * Show details about the ItemCollection in a popup.
       *
       * @private
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection - Collection of the items to display.
       * @return {Promise}
       */
      function $showItemCollectionDetailsDialog(itemCollection) {
        return feDialogs.showFor({
          type: ItemCollectionDetailsWidget,
          value: itemCollection,
          formFactor: 'compact',
          properties: this.properties().toValueMap(),
          buttons: ['ok']
        });
      }

      /**
       * The base ORD against to resolve the servlet query to refresh this
       * ItemCollection.
       * @private
       * @returns {string|baja.Ord}
       */
    }, {
      key: "$getBaseOrd",
      value: function $getBaseOrd() {
        return this.properties().getValue('baseOrd');
      }

      /**
       * DonutCharContainer will be emitted.
       * @private
       * @return {module:bajaux/Widget}
       */
    }, {
      key: "$getDonutChartWidget",
      value: function $getDonutChartWidget() {
        return Widget["in"](this.jq().find('.DonutChartContainer'));
      }

      /**
       * CountsBySevWidgetContainer will be emitted.
       * @private
       * @return {module:nmodule/nss/rc/fe/CountsBySeverityWidget}
       */
    }, {
      key: "$getCountsBySeverityWidget",
      value: function $getCountsBySeverityWidget() {
        return Widget["in"](this.jq().find('.CountsBySeverityWidget'));
      }

      /**
       * ItemsContainer will be emitted.
       * @private
       * @return {module:bajaux/Widget}
       */
    }, {
      key: "$getItemsArrayWidget",
      value: function $getItemsArrayWidget() {
        return Widget["in"](this.jq().find('.ItemsContainer'));
      }

      /**
       * @private
       * @returns {number} how long to wait after a refresh request before
       * polling for data again
       */
    }, {
      key: "$getRefreshTimeout",
      value: function $getRefreshTimeout() {
        return REFRESH_TIMEOUT;
      }

      /**
       * @private
       * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
       */
    }, {
      key: "$getDashboardService",
      value: function $getDashboardService() {
        return this.properties().getValue('dashboardService');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSeverityWidgetElement",
      value: function $getSeverityWidgetElement() {
        return this.jq().find('.EntityContainer .SeverityWidget');
      }

      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/SeverityWidget} widget showing the max severity for the ItemCollection
       */
    }, {
      key: "$getSeverityWidget",
      value: function $getSeverityWidget() {
        return Widget["in"](this.$getSeverityWidgetElement());
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getRefreshCommand",
      value: function $getRefreshCommand() {
        return this.getCommandGroup().get(0);
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getRefreshButton",
      value: function $getRefreshButton() {
        return Widget["in"](this.jq().find('.Refresh'));
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getTimestampElement",
      value: function $getTimestampElement() {
        return this.jq().find('.Timestamp');
      }

      /**
       * Hyperlink to the ORD of this item collection's source.
       * @private
       */
    }, {
      key: "$doHyperlink",
      value: function $doHyperlink() {
        securityDashboardUtil.hyperlink(this.value().getSourceEntity().getOrd(), this.$getBaseOrd());
      }

      /**
       * Wait a bit for the server to finish refreshing its data, request it,
       * and display it.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$refreshLater",
      value: function $refreshLater() {
        var _this = this;
        this.$getTimestampElement().text(REFRESHING);
        return waitInterval(this.$getRefreshTimeout()).then(function () {
          return _this.$refresh();
        });
      }

      /**
       * Requests a refresh of data from the server.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$requestRefresh",
      value: function $requestRefresh() {
        var entity = this.value().getSourceEntity();
        return this.$getDashboardService().requestRefresh(this.$getBaseOrd(), entity.getName());
      }

      /**
       * Fetch fresh data from the server and update this widget with a new
       * ItemCollection.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$refresh",
      value: function $refresh() {
        var _this2 = this;
        if (this.isDestroyed()) {
          return Promise.resolve();
        }
        var itemCollection = this.value();
        var entity = itemCollection.getSourceEntity();
        return this.$getDashboardService().getItemCollection(this.$getBaseOrd(), entity.getName(), itemCollection.getTimestamp()).then(function (itemCollection) {
          return _this2.load(itemCollection);
        });
      }

      /**
       * Adds the 'ItemCollectionSummaryWidget' class to the dom.
       * @param {JQuery} dom - Html to fill.
       * @return {Promise} Initialized field editors wrapped as a promise.
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this3 = this;
        dom.addClass('ItemCollectionSummaryWidget');
        dom.append(getTemplate());
        dom.on('click', '.entityNameLink', function () {
          _this3.$doHyperlink();
          return false;
        });
        dom.on('click', '.MoreContainer a', function () {
          _this3.$showItemCollectionDetailsDialog(_this3.value())["catch"](logSevere);
          return false;
        });
        this.getCommandGroup().add(new Command({
          module: 'nss',
          lex: 'SecurityDashboardView.refreshCommand',
          func: function func() {
            _this3.$getRefreshCommand().setEnabled(false);
            return _this3.$requestRefresh().then(function () {
              return _this3.$refreshLater();
            });
          }
        }));
        this.$timestampTicket = setInterval(function () {
          _this3.$updateTimestamp()["catch"](logSevere);
        }, TIMESTAMP_UPDATE_INTERVAL);
        return Promise.all([getSeverityColors().then(function (color) {
          return new DonutChartWidget({
            properties: {
              label: '',
              color: color,
              width: 120,
              height: 120,
              radius: 45,
              countYOffset: 16
            }
          }).initialize(dom.find('.DonutChartContainer'));
        }), new CountsBySeverityWidget({
          properties: {
            horizontal: false
          }
        }).initialize(dom.find('.CountsBySeverityWidget')), new ItemsArrayCompositeEditor().initialize(dom.find('.ItemsContainer')), new SeverityWidget().initialize(this.$getSeverityWidgetElement()), new CommandButton().initialize(dom.find('.Refresh'))]);
      }

      /**
       * Loads the CountsBySeverityWidget, DonutChartWidget, ItemCollectionContainer to the dom.
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection - Collection of the items to display.
       * @return {Promise|*}
       */
    }, {
      key: "doLoad",
      value: function doLoad(itemCollection) {
        if (!(itemCollection instanceof ItemCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.itemCollection.type.required.error'));
        }
        var refreshCmd = this.$getRefreshCommand();
        var status = itemCollection.data('status');
        if (status === ItemCollection.status.UP_TO_DATE) {
          refreshCmd.setEnabled(true);
          return;
        }
        var dom = this.jq();
        var countsBySeverity = itemCollection.getCountsBySeverity();
        var items = itemCollection.getItems();
        var maxSeverity = itemCollection.getMaxSeverity();
        var sourceEntity = itemCollection.getSourceEntity();

        // if we're still waiting for results, prevent the user from
        // re-refreshing and poll for the updated results later.
        if (status === ItemCollection.status.PENDING) {
          refreshCmd.setEnabled(false);
          this.$refreshLater()["catch"](logSevere);
        } else {
          refreshCmd.setEnabled(true);
        }
        var ord = baja.Ord.make(sourceEntity.getOrd());
        var entityName = dom.find('.entityName');
        if (isLinkable(ord)) {
          entityName.html($('<a class="entityNameLink">').text(sourceEntity.getDisplayName()).attr('href', ord.toUri()).attr('data-ord', ord));
        } else {
          entityName.text(sourceEntity.getDisplayName());
        }
        return Promise.all([this.$getDonutChartWidget().load(getTypeAndCountForSeverity(countsBySeverity)), this.$getCountsBySeverityWidget().load(countsBySeverity), this.$getItemsArrayWidget().load(items), this.$getRefreshButton().load(refreshCmd), maxSeverity && this.$getSeverityWidget().load(maxSeverity), this.$updateTimestamp()]);
      }

      /**
       * Update the contents of the timestamp display.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateTimestamp",
      value: function $updateTimestamp() {
        var itemCollection = this.value();
        if (!itemCollection) {
          return Promise.resolve();
        }
        var timestamp = itemCollection.getTimestamp();
        var pending = itemCollection.data('status') === ItemCollection.status.PENDING;
        var timestampElement = this.$getTimestampElement();
        if (pending) {
          return Promise.resolve(timestampElement.text(REFRESHING));
        }
        if (!timestamp) {
          return Promise.resolve();
        }
        var relTime = baja.RelTime.make(timestamp - new Date());
        return relTime.toFriendlyString().then(function (intervalString) {
          timestampElement.text(nssLex.get('SecurityDashboardView.itemCollectionSummary.timestampLabel', intervalString));
        });
      }

      /**
       * loads the ItemsContainer with filtered item list.
       * @param  {module:nmodule/nss/rc/model/Severity[]} filter - array of Severity Object
       * @returns {Promise} loads itemContainer with filtered itemList
       */
    }, {
      key: "applyFilter",
      value: function applyFilter(filter) {
        var itemCollection = this.value();
        var emptyFilter = filter.length === 0;
        var more = this.jq().find(".MoreContainer").detach();
        if (emptyFilter) {
          more.appendTo(this.jq().find(".LeftContainer"));
        } else {
          more.appendTo(this.jq().find(".RightWrapper"));
        }
        return this.$getItemsArrayWidget().load(itemCollection.getItems(filter));
      }

      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ItemCollectionSummaryWidget');
        clearInterval(this.$timestampTicket);
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseWidget);
});
