function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015, Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/docDeveloper/rc/JsPlaygroundWidget
 */
define(['baja!', 'lex!docDeveloper', 'Promise', 'jquery', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/mixin/subscriberMixIn', 'nmodule/docDeveloper/ext/@babel/standalone/babel.min', 'nmodule/webEditors/rc/wb/mixin/textEditorMixIn', 'dialogs', 'hbs!nmodule/docDeveloper/rc/JsPlaygroundSavedTemplate', 'css!nmodule/docDeveloper/rc/JsPlaygroundStyle'], function (baja, lexs, Promise, $, Widget, Command, subscriberMixIn, babel, textEditorMixIn, dialogs, savedTemplate) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    docDeveloperLex = _lexs[0];
  var idPropName = 'id';

  /**
   * A playground for JavaScript code! This is used for learning about using Niagara's
   * HTML5 features.
   *
   * @class
   * @alias module:nmodule/docDeveloper/rc/JsPlaygroundWidget
   * @extends module:bajaux/Widget
   */
  var JsPlaygroundWidget = function JsPlaygroundWidget() {
    var that = this;
    Widget.apply(that, arguments);
    that.properties().add({
      name: idPropName,
      value: "",
      hidden: true,
      readonly: true,
      "transient": true,
      parameter: true // Can be loaded from a view parameter.
    });
    subscriberMixIn(that);
    textEditorMixIn(that);
  };
  JsPlaygroundWidget.prototype = Object.create(Widget.prototype);
  JsPlaygroundWidget.prototype.constructor = JsPlaygroundWidget;

  /**
   * Performs Babel/JSX transpilation before running the JS code.
   *
   * @private
   * @param {string} text
   * @param define
   * @returns {Promise}
   */
  JsPlaygroundWidget.prototype.$eval = function (text, define) {
    var transpiled = babel.transform(text, {
      presets: ['env'],
      plugins: ['transform-react-jsx']
    });
    // noinspection DynamicallyGeneratedCodeJS
    return Promise["try"](function () {
      return eval(transpiled.code);
    }); // eslint-disable-line no-eval
  };
  JsPlaygroundWidget.prototype.doLoad = function (playground) {
    var that = this,
      help = playground.getHelp().toString();
    that.$initEditor("jsx");
    that.$setEditorReadOnly(false);

    // If there's help then show the command.
    if (help && help !== baja.Ord.DEFAULT.toString()) {
      that.getCommandGroup().add(new Command({
        module: "docDeveloper",
        lex: "commands.help",
        func: function func() {
          window.niagara.env.hyperlink(help);
        }
      }));
    }
    return playground.load("" + that.properties().getValue(idPropName)).then(function (text) {
      that.$setEditorText(text);
      if (playground.getEnableSave()) {
        that.$addSaveCmd();
        that.$onEditorChange(function () {
          that.setModified(true);
        });
      }
      that.$addRunCmd();
    });
  };
  JsPlaygroundWidget.prototype.doSave = function () {
    var that = this,
      playground = that.value();
    if (playground.getEnableSave()) {
      return playground.save(that.$getEditorText()).then(function (id) {
        var ordStr = that.$toOrdFromId(id),
          uriStr = that.$toUriFromId(id);
        return dialogs.showOk({
          title: docDeveloperLex.get("saved"),
          content: savedTemplate({
            savedMsg: docDeveloperLex.get("saved.message"),
            uriTitle: docDeveloperLex.get("saved.uri"),
            ordTitle: docDeveloperLex.get("saved.ord"),
            uri: uriStr,
            ord: ordStr
          }),
          buttons: [{
            name: "goToLink",
            displayName: docDeveloperLex.get("saved.goToLink"),
            handler: function handler() {
              window.niagara.env.hyperlink(ordStr);
            }
          }]
        }).promise();
      });
    }
  };

  /**
   * Return an ORD string from the specified Id.
   *
   * @private
   * 
   * @param  {String} id The id for the saved JavaScript.
   * @return {String} A ORD String with the embedded id as a parameter.
   */
  JsPlaygroundWidget.prototype.$toOrdFromId = function (id) {
    return this.value().getNavOrd().relativizeToSession().toString() + "|view:docDeveloper:JsPlaygroundWidget?id=" + encodeURIComponent(id);
  };

  /**
   * Return a URI from the specified Id.
   *
   * @private
   * 
   * @param  {String} id The id for the saved JavaScript.
   * @return {String} A URI with the embedded id as a parameter.
   */
  JsPlaygroundWidget.prototype.$toUriFromId = function (id, origin) {
    return (origin || window.location.origin) + "/ord/" + encodeURI(this.value().getNavOrd().relativizeToSession().toString()) + "%7Cview:docDeveloper:JsPlaygroundWidget?id=" + encodeURIComponent(id);
  };
  return JsPlaygroundWidget;
});
