/*
Dynamic spandrel widgets
========================

The first argument to the spandrel function can itself be a function. This
function will receive the value being loaded into the widget (the argument
passed to load()).

This way, the spandrel widget can build itself out in response to the loaded
value. These widgets are called "dynamic" spandrel widgets.

In this example, the widget will show the name and type of the component loaded
in. Be sure to answer Yes to the dialog and choose a component to load.
Otherwise, the widget will do nothing.
*/

/** @jsx spandrel.jsx */

define([ 'bajaux/spandrel' ], function (spandrel) {

  'use strict';

  const ComponentInfoWidget = spandrel((component) => (
    <div>
      <label>Name: </label>
      <span>{ component.getName() } </span>
      <label>Type: </label>
      <span>{ String(component.getType())}</span>
    </div>
  ));

  return ComponentInfoWidget;
});
