/* eslint-env browser */
/* global niagara */

/** @jsx spandrel.jsx */

/*
  This widget demonstrates how to hyperlink between different pages within in bajaux. 

  Instead of using the standard 'window.location.assign' method, a 'niagara' namespace
  is available to use for hyperlinking instead. It supports linking not just to URIs, but to Niagara
  ORDs as well.

  This widget also provides a simple demonstration of building widgets in spandrel. Please see
  the spandrel section under the bajaux tutorials for more information.
*/
define([
  'bajaux/spandrel',
  'css!nmodule/docDeveloper/examples/bajaux/HyperlinkWidgetStyle' ], function (
  spandrel) {

  'use strict';

  return spandrel(
    <div class='example-hyperlink-widget'>
      <div>
        Click one of the following buttons to hyperlink somewhere...
      </div>
      <div>
        <button type='button' onClick={() => niagara.env.hyperlink("module://docDeveloper/doc/jsdoc/bajaux-ux/index.html")}>
          Hyperlink to bajaux Help
        </button>
      </div>
      <div>
        <button type='button' onClick={() => niagara.env.hyperlink("station:|slot:/BajauxExamples/MyFirstWidget")}>
          Hyperlink to MyFirstWidget
        </button>
      </div>
      <div>
        <button type='button' onClick={() => niagara.env.hyperlink("https://www.niagara-central.com")}>
          Hyperlink to Niagara Central
        </button>
      </div>
    </div>
  );
});
