/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by H402747 on 8/7/2022.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/table/fe/AnalyticTableBaselineDetailsFE', 'nmodule/analytics/rc/report/util/reportUtils', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, feDialogs, events, BaseEditor, AnalyticTableBaselineDetailsFE, reportUtils) {
  'use strict';

  var lex = lexs[0];

  /**
   * @param params
   * @constructor
   */
  var AnalyticTableBaselineEditor = function AnalyticTableBaselineEditor(params) {
    BaseEditor.apply(this, arguments);
  };
  AnalyticTableBaselineEditor.prototype = Object.create(BaseEditor.prototype);
  AnalyticTableBaselineEditor.prototype.constructor = AnalyticTableBaselineEditor;

  /**
   * Creates the template for Analytic Data Tag Selector.
   * @param {jQuery} dom
   */
  AnalyticTableBaselineEditor.prototype.doInitialize = function (dom) {
    dom.append('<input type="checkbox" class="table-baseline-enabler">');
    // dom.append('<button type="button" class="ux-btn">' + lex.get('baseLine.details') + '</button>');
    dom.append('<label class="table-baseline-dtls">' + lex.getSafe("baseLine.details.none") + '</label>');
    dom.append('<span class="table-baseline-select-icon icon-icons-x16-find"></span>');
    this.$registered = false;
    return BaseEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   *  Load the value of the tag in to the text box.
   *  Register an event on the selection button
   * @param dom
   */
  AnalyticTableBaselineEditor.prototype.doLoad = function (val) {
    var that = this,
      jq = that.jq(),
      baselineTogglerElem = $(".table-baseline-enabler", jq);
    if (val.getEnabled()) {
      baselineTogglerElem.prop('checked', true);
      that.$populateBaselineDtls(val);
    }
    if (!this.$registered) {
      this.registerEvents(val);
      this.$registered = true;
    }
    return Promise.resolve(val);
  };

  /**
   * Returns the selected data tag
   * @returns {String} the selected data tag
   */
  AnalyticTableBaselineEditor.prototype.doRead = function () {
    var that = this,
      jq = that.jq();
    var v = that.value();
    v.setEnabled($(".table-baseline-enabler", jq).prop("checked"));
    return Promise.resolve(v);
  };

  /**
   * Register events for the tag chooser editor
   */
  AnalyticTableBaselineEditor.prototype.registerEvents = function (val) {
    var that = this;
    var jq = that.jq();
    var props = this.properties();
    var contentDiv = props.getValue("contentDiv");
    var hasContentRoot = false;
    var feBase = {
      value: val,
      type: AnalyticTableBaselineDetailsFE,
      title: lex.get("baseLine.details.title"),
      formFactor: "mini"
    };
    if (contentDiv) {
      hasContentRoot = true;
    }
    this.$offClickHandler();
    var blEnabler = $(".table-baseline-enabler", jq);
    blEnabler.change(function (e) {
      var baslineDtlsElem = $(".table-baseline-dtls", jq);
      if ($(this).prop('checked')) {
        that.$isEnabled = true;
        that.$populateBaselineDtls(val);
      } else {
        that.$isEnabled = true;
        baslineDtlsElem.html(lex.getSafe("baseLine.details.none"));
      }
      that.setModified(true);
    });
    jq.on('click', 'span.table-baseline-select-icon', function () {
      if (blEnabler.prop("checked")) {
        var prop = that.properties();
        if (hasContentRoot) {
          // Open the field editor in the content div
          fe.buildFor($.extend(feBase, {
            dom: contentDiv,
            value: that.value()
          }));
        } else {
          // Open the tag editor in a popup
          feDialogs.showFor($.extend(feBase, {
            value: that.value(),
            properties: {
              timeRange: prop.getValue("timeRange")
            },
            progressCallback: function progressCallback(msg, arg) {}
          })).then(function (baseline) {
            if (baseline !== null) {
              that.$populateBaselineDtls(baseline);
              that.setModified(true);
            }
          })["finally"](function () {});
        }
      }
    });
  };

  /**
   *
   * @param val
   */
  AnalyticTableBaselineEditor.prototype.$populateBaselineDtls = function (val) {
    var that = this,
      jq = that.jq();
    var baslineDtlsElem = $(".table-baseline-dtls", jq);
    var timeRange = val.getTimeRange();
    baslineDtlsElem.html(lex.getSafe({
      key: "chart.baseline.dtls.format",
      args: [timeRange.getDisplayTag()]
    }));
  };
  AnalyticTableBaselineEditor.prototype.$offClickHandler = function () {
    var jq = this.jq();
    $("span.table-baseline-select-icon", jq).off();
    this.$registered = false;
  };

  /**
   * Update the properties
   */
  AnalyticTableBaselineEditor.prototype.doUpdate = function (groupList, timeRange) {
    var that = this;
    that.properties().setValue("groups", groupList);
    that.properties().setValue("timeRange", timeRange);
    return Promise.resolve(true);
  };
  return AnalyticTableBaselineEditor;
});
