/* eslint-disable promise/no-return-wrap,promise/catch-or-return */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/mixin/subscriberMixIn', 'bajaux/events', 'Promise', 'jquery', 'underscore', 'd3', 'dialogs', 'nmodule/analytics/ext/datatables/jquery.dataTables',
// 'nmodule/analytics/rc/datatables/dataTables.colReorder',
// 'nmodule/analytics/rc/datatables/dataTables.fixedHeader',
'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsBaseWidget', 'nmodule/analytics/rc/chart/utils/AnalyticsDataUtils', 'nmodule/analytics/rc/chart/base/AnalyticsCommandBar', 'nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel', 'nmodule/analytics/rc/chart/base/analyticEvents', 'nmodule/analytics/rc/table/AnalyticsTableConfigModel', 'nmodule/analytics/rc/chart/utils/AnalyticsChartDragDropUtils', 'nmodule/analytics/rc/chart/fe/TableConfigurationSettingsFE', 'nmodule/analytics/rc/chart/fe/TableUxWebChartSettingsFE', 'nmodule/webEditors/rc/wb/util/ICollectionSupport', 'hbs!nmodule/analytics/rc/chart/templates/table/analyticsBaseTable', 'hbs!nmodule/analytics/rc/chart/templates/table/analyticsBaseTableTemplate', 'lex!baja,analytics', "baja!analytics:AnalyticUxWebChartParams," + "analytics:Interval," + "analytics:Combination," + "analytics:AnalyticsTableConfigModel", 'css!nmodule/analytics/ext/datatables/jquery.dataTables',
// 'css!nmodule/analytics/rc/datatables/fixedHeader.dataTables',
// 'css!nmodule/analytics/rc/datatables/colReorder.jqueryui',
'css!nmodule/analytics/rc/table/analyticsBaseTable'], function (baja, subscriberMixIn, events, Promise, $, _, d3, dialogs, datatables,
// colReorder,
// fixedHeader,
analyticsUtil, AnalyticsBaseWidget, AnalyticsDataUtils, AnalyticsCommandBar, AnalyticsBaseDataModel, analyticEvents, AnalyticsTableConfigModel, AnalyticsChartDragDropUtils, TableConfigurationSettingsFE, TableUxWebChartSettingsFE, ICollectionSupport, baseTable, baseTemplate, lexicon, types) {
  "use strict";

  var lex = lexicon[1];

  /**
   *
   * @class
   * @alias module:nmodule/analytics/rc/table/AnalyticsBaseTable
   * @extends module:nmodule/analytics/rc/chart/base/AnalyticsBaseWidget
   * @mixes module:nmodule/webEditors/rc/wb/util/ICollectionSupport
   * @param {Object} [params]
   */
  var AnalyticsBaseTable = function AnalyticsBaseTable(params) {
    AnalyticsBaseWidget.apply(this, $.extend({}, params));
    subscriberMixIn(this);
    ICollectionSupport(this);
    this.chartModelList = [];
    this.textSize = 0;
    this.textScale = d3.scale.linear().domain([100, 1300]).range([12, 16]);
    this.tsFormat = "MMMM Do YYYY, HH:mm:ss"; // Needs to be from constants
  };
  AnalyticsBaseTable.prototype = Object.create(AnalyticsBaseWidget.prototype);
  AnalyticsBaseTable.prototype.constructor = AnalyticsBaseTable;

  /**
   * Initializes the chart, get's called once.
   * @param element
   */
  AnalyticsBaseTable.prototype.doInitialize = function (element) {
    var that = this;
    return AnalyticsBaseWidget.prototype.doInitialize.apply(that, [element]).then(function (load) {
      // Now render the base template
      element.html(baseTable({
        columns: that.getColumns(),
        rows: that.getRows(),
        include: baseTemplate()
      }));

      //register the events for settings icon
      that.registerDoubleClickEvent();
      registerChartChangedEvent(that);
      load();
      return Promise.resolve(that.jq());
    });
  };

  /**
   * Loads the table with data and configuration.
   * @param chartSource
   */
  AnalyticsBaseTable.prototype.doLoad = function (source) {
    var that = this;
    return AnalyticsBaseWidget.prototype.doLoad.apply(this, [source]).then(function (chartSource) {
      if (_.isEmpty(chartSource)) {
        return Promise.resolve(true);
      }
      var modelPromise = AnalyticsDataUtils.getModel(that, chartSource, that.getDefaultSettings());
      return modelPromise.then(function (inModel) {
        if (!analyticsUtil.isUniqueOrd(that, inModel)) {
          return Promise.resolve();
        }
        if (!_.isEmpty(inModel[1])) {
          that.$tabConfigDataModel.$rebuild(inModel[1]);
        }
        that.chartModelList.push.apply(that.chartModelList, inModel[0]);
        return that.$doLoad();
      });
    });
  };

  /**
   * Helper method for doLoad to do the delegated tasks.
   */
  AnalyticsBaseTable.prototype.$doLoad = function () {
    var that = this;
    var promiseList = [];
    var exclKeys = ['timestamp', 'seriesName', 'trendFlags', 'date'];
    _.each(that.chartModelList, function (tableModel) {
      if (that.isMultiNode) {
        promiseList.push(AnalyticsDataUtils.getMultiOrdTableData(tableModel));
      } else {
        promiseList.push(AnalyticsDataUtils.getTableData(tableModel));
      }
    });
    var retPromise = Promise.all(promiseList).then(function (values) {
      that.chartModelList = values;
      if (!that.isMultiNode) {
        // If series names are same, we add extra index to identify one series with another.
        var groupedBySeries = _.groupBy(values, function (val) {
          return baja.SlotPath.unescape(val.getSeriesName());
        });
        if (_.keys(groupedBySeries).length !== values.length) {
          values = _.map(values, function (val, index) {
            return val.setSeriesName(val.getSeriesName() + index);
          });
        }
      }
      that.refresh(that.isMultiNode ? analyticsUtil.getMultiNodeOrdTableData(that) : analyticsUtil.getMultiOrdTableData(that, exclKeys)).then(function () {
        if (!that.$widgetCommandBarRendered && that.isInitCommandBar) {
          that.initCommandBar().then(function () {
            that.$widgetCommandBarRendered = true;
          });
        }
        that.finishTasks();
      });
    });
    // if(that.source !== "report") {
    //   dialogs.showLoading(200, retPromise);
    // }
    return retPromise;
  };

  /**
   * Refreshes the table with current data, can be used for binding changed events in future.
   */
  AnalyticsBaseTable.prototype.refresh = function (source) {
    var that = this,
      tableContainer = that.jq().find(".tableContainer");

    // Settings the all here, may not be ideal, will move it to a nice place in future.
    that.getTabConfigDataModel().setColumnList(source.allColumns.toString());

    // Empty the columns of data tables.
    that.jq().find(".lengthCol").empty();
    that.jq().find(".searchCol").empty();
    that.jq().find(".infoCol").empty();
    that.jq().find(".pagingCol").empty();

    // Just attaching table, nothing else.
    tableContainer.html($(baseTable(source)).find(".analyticsTable"));

    // Apply the data table of any columns exist.
    if (source.columns.length !== 0) {
      tableContainer.find(".analyticsTable").DataTable({
        // Below call back gets executed before every row insertion.
        "fnRowCallback": function fnRowCallback(row, data, displayIndex, fullDisplayIndex) {
          // Will input a row data
          _.each(data, function (dat, index) {
            var inValue = dat,
              colorVal;
            try {
              // Unparsable objects will fall in catch.
              var parsedObj = JSON.parse(dat);
              if (_.isNumber(parsedObj)) {
                $('td:eq(' + index + ')', row).html(analyticsUtil.standardizeInput(parsedObj));
                // eslint-disable-next-line brace-style
              }
              // For the parsed one is a javascript object, below if condition works,
              // others which don't get executed through this logic will assumed as-is by datatables.
              else if (_.isObject(parsedObj)) {
                inValue = baja.SlotPath.unescape(parsedObj.value);
                colorVal = parsedObj.color;
                // Span approach, nice one, keep it until feedback comes in.
                // Create a span and set a color to it and append it to the <td>.
                // var span = $("<span></span>");
                // span.attr("style", "background:" + colorVal + ";float:left;height:16px;width:16px;margin-right:4px;");
                // $('td:eq(' + index + ')', row).html(span);
                // $('<span style="float:left">' + inValue + '</span>').appendTo($('td:eq(' + index + ')', row));

                // Without Span approach, liked by HUE
                $('td:eq(' + index + ')', row).html(inValue);
                $('td:eq(' + index + ')', row).attr("style", "border-left: 1em solid " + colorVal);
              }
            } catch (err) {}
          });
        },
        //Column definitions are not required as of now, as the actual columns are typed.
        //Kept them commented for future use.
        //sorting applied based on date
        'columnDefs': [{
          'type': 'date',
          'targets': 0
        }],
        "pagingType": "simple",
        colReorder: true,
        pageLength: 100,
        lengthMenu: [[10, 50, 100, -1], [10, 50, 100, "All"]],
        fixedHeader: {
          header: true,
          footer: true
        },
        fnInitComplete: function fnInitComplete(oSettings, json) {
          $("input[type='search']").addClass("ux-input");
          $("select").addClass("ux-select");
        },
        //oLanguage to change the data table's visible text.
        "oLanguage": {
          "sSearch": lex.getSafe('analyticsTable.search.text'),
          "sLengthMenu": '<b>' + lex.getSafe('analyticsTable.show.text') + '</b>' + "_MENU_",
          "sInfo": "<b>" + "_START_ - _END_ " + lex.getSafe('analyticsTable.of.text') + " _TOTAL_" + "</b>",
          "oPaginate": {
            "sPrevious": '<i class="icon-icons-x16-arrowLeft" ></i>',
            "sNext": '<i class="icon-icons-x16-arrowRight" ></i>'
          }
        },
        // Toggled it off as it requires further discussion on what needs to be saved in the state.
        'dom': 'lfipt'
      });
      that.jq().find(".dataTables_length").appendTo(that.jq().find(".lengthCol"));
      that.jq().find(".dataTables_filter").appendTo(that.jq().find(".searchCol"));
      that.jq().find(".dataTables_info").appendTo(that.jq().find(".infoCol"));
      that.jq().find(".dataTables_paginate").appendTo(that.jq().find(".pagingCol"));
    }
    return Promise.resolve(that.jq());
  };

  /**
   * Chart initializes with these columns.
   * @returns {string[]}
   */
  AnalyticsBaseTable.prototype.getColumns = function () {
    return [];
  };

  /**
   * Chart initializes with dummy rows.
   * @returns {Array}
   */
  AnalyticsBaseTable.prototype.getRows = function () {
    return [];
  };
  /**
   * Returns the set text scale for the base chart.
   * @returns {*}
   */
  AnalyticsBaseWidget.prototype.getTextScale = function () {
    return this.textScale;
  };
  /**
   *  Build Chart Settings
   * @param chartSettings
   * @param settings
   * @returns {*}
   */
  AnalyticsBaseTable.prototype.buildSettings = function (chartSettingsColl, settings) {
    var optionalParam;
    if (chartSettingsColl.getInterval()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Interval").make(chartSettingsColl.getInterval()));
      optionalParam.setSelected(chartSettingsColl.isIntervalSelected());
      settings.setInterval(optionalParam);
    }
    if (chartSettingsColl.getRollup()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Combination").make(chartSettingsColl.getRollup()));
      optionalParam.setSelected(chartSettingsColl.isRollupSelected());
      settings.setRollup(optionalParam);
    }
    if (chartSettingsColl.getAggregation()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Combination").make(chartSettingsColl.getAggregation()));
      optionalParam.setSelected(chartSettingsColl.isAggregationSelected());
      settings.setAggregation(optionalParam);
    }
    settings.setData(chartSettingsColl.getData() || "n:history");
    settings.setDataFilter(chartSettingsColl.getDataFilter() || "");
    if (chartSettingsColl.getUnit()) {
      settings.setUnit(chartSettingsColl.getUnit());
    }
    if (chartSettingsColl.getOrd()) {
      settings.setOrd(chartSettingsColl.getOrd());
    }
    if (chartSettingsColl.getDataSource()) {
      settings.setDataSource(chartSettingsColl.getDataSource());
    }
    if (chartSettingsColl.getDataSourceName()) {
      settings.setDataSourceName(chartSettingsColl.getDataSourceName());
    }
    if (chartSettingsColl.getSeriesName()) {
      settings.setSeriesName(chartSettingsColl.getSeriesName());
    }
    if (chartSettingsColl.getBrush()) {
      settings.setBrush(chartSettingsColl.getBrush());
    }
    if (chartSettingsColl.getSeriesNameBFormat()) {
      settings.setSeriesNameBFormat(chartSettingsColl.getSeriesNameBFormat());
    }
    if (chartSettingsColl.getUniqueKey()) {
      settings.setUniqueKey(chartSettingsColl.getUniqueKey());
    }
    if (chartSettingsColl.getNode()) {
      settings.setNode(chartSettingsColl.getNode());
    }
    return settings;
  };

  /**
   *  This method needs to be overridden by sub classes to provide the necessary
   *  painting mechanism.
   * @param chartSettingsCollection
   */
  AnalyticsBaseTable.prototype.reDraw = function (chartSource) {};

  /**
   * Helper method to redraw, table doesn't need this.
   * @param chartSettingsCollection
   */
  AnalyticsBaseTable.prototype.render = function (chartSettingsCollection) {};

  /**
   * This method should be overridden by subclasses to return respective chart types.
   * The default implementation retruns "none".
   * @returns {string}
   */
  AnalyticsBaseTable.prototype.getSupportedExportTypes = function () {
    return ["atable", "csv"];
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  AnalyticsBaseTable.prototype.getConfigurationTabType = function () {
    return TableConfigurationSettingsFE;
  };

  /**
   * Base model java class for configuration.
   * Child classes should override this method and mention their configuration class.
   * @returns {*}
   */
  AnalyticsBaseTable.prototype.getConfigTabParamType = function () {
    return baja.$("analytics:AnalyticsTableConfigModel");
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  AnalyticsBaseTable.prototype.getTabModelType = function () {
    return AnalyticsTableConfigModel;
  };

  /**
   * Abstract method allows the child class to implement the logic to update their tab model based on the web object.
   * @param chartObj
   */
  AnalyticsBaseTable.prototype.updateChartConfiguration = function (data) {
    var that = this;
    that.getTabConfigDataModel().setExclusionList(data.getExclusionList());
  };

  /**
   * This method should be overridden by subclasses to return respective chart types.
   * The default implementation retruns "none".
   * @returns {string}
   */
  AnalyticsBaseTable.prototype.getSupportedExportTypes = function () {
    return ["atable", "csv"];
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  AnalyticsBaseTable.prototype.getSettingsEditorType = function () {
    return TableUxWebChartSettingsFE;
  };

  /**
   * Get Get X Formatter
   * @returns {*}
   */
  AnalyticsBaseTable.prototype.getTableKeyFormatter = function () {
    return this.properties().getValue("xKeyFormatter");
  };
  AnalyticsBaseTable.prototype.getDefaultOrdScheme = function () {
    return "analyticBaselineTrend:";
  };

  /**
   *
   */
  function registerChartChangedEvent(that) {
    that.jq().find('.tableContainer').off(analyticEvents.CHART_CHANGED);
    that.jq().find('.tableContainer').on(analyticEvents.CHART_CHANGED, function (event, callee) {
      that.alien = callee;
      that.doRefresh(analyticsUtil.understandData(that));
    });
  }
  AnalyticsBaseTable.prototype.doDestroy = function () {
    this.jq().find('.tableContainer').removeData();
    return Promise.resolve(this.jq().find('.tableContainer').remove());
  };
  return AnalyticsBaseTable;
});
