/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/decorator/JSONUxAreaValueMixin
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'dialogs', 'underscore', 'bajaux/events', 'nmodule/analytics/rc/report/fe/JSONUxNodeSelectionEditor', 'nmodule/analytics/rc/report/util/reportWidgetEvents', 'lex!analytics'], function (baja, $, Promise, Widget, dialogs, _, events, JSONUxNodeSelectionEditor, reportWidgetEvents, lexicon) {
  'use strict';

  var lex = lexicon[0];

  /**
   * This decorates the Node selection editor by adding area normalization related values to it
   * Currently area value is added to it
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/decorator/JSONUxAreaValueMixin
   * @extends module:nmodule/analytics/rc/report/fe/JSONUxNodeSelectionEditor
   * @param widget
   * @param params
   */
  var JSONUxNodeAreaMixin = function JSONUxNodeAreaMixin() {
    JSONUxNodeSelectionEditor.apply(this, arguments);
  };
  JSONUxNodeAreaMixin.prototype = Object.create(JSONUxNodeSelectionEditor.prototype);
  JSONUxNodeAreaMixin.prototype.constructor = JSONUxNodeAreaMixin;

  /**
   * Load the editor for selected  node and register an event to handle
   * the area value lloaded event
   * @param jsonStr
   */
  JSONUxNodeAreaMixin.prototype.doUpdate = function (areaCfg, useGrpNameOnly) {
    var that = this;
    var root = that.jq(),
      groups = $('.group-content', root);
    groups.each(function (index, grp) {
      var g = $(grp),
        grpName = $('.group-display-name', g).attr('guid');
      if (areaCfg.useGrpName) {
        // Unescape and escape is done to take care of the accidental escaping of an escaped character.
        grpName = baja.SlotPath.escape(baja.SlotPath.unescape($('.group-display-name', g).text()));
      }
      if (grpName) {
        var nodeAreaConfig = areaCfg[grpName],
          areaCfgText = '';
        if (nodeAreaConfig && nodeAreaConfig.req && !nodeAreaConfig.bl) {
          if (nodeAreaConfig.value > 0) {
            areaCfgText = lex.get({
              key: "report.area.legend",
              args: [nodeAreaConfig.value, nodeAreaConfig.units && nodeAreaConfig.units.toString() === "null" ? lex.get("report.area.nounit.label") : nodeAreaConfig.units.getUnitName()]
            });
          } else {
            areaCfgText = lex.get("report.area.na");
          }
        }
        $('.group-metadata', g).text(areaCfgText);
      }
    });
  };
  return JSONUxNodeAreaMixin;
});
