function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/RawDataFilterEditor
 */
define(['baja!', 'baja!analytics:RawDataFilter', 'bajaux/Widget', 'bajaux/events', 'Promise', 'jquery', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/history/rc/fe/RolloverValueEditor', 'lex!analytics', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, types, Widget, events, Promise, $, ComplexCompositeEditor, RolloverValueEditor, lexs) {
  'use strict';

  var lex = lexs[0];
  var highLimitLabel = lex.getSafe('outlier.highLimit'),
    lowLimitLabel = lex.getSafe('outlier.lowLimit');
  var rawDataFilterEditor = function rawDataFilterEditor() {
    return "\n   <span class='HighLimit-label' style=\"padding-right:0.2em;\"><label>".concat(highLimitLabel, "</label></span>\n   <span class='HighLimit' style=\"padding-right:2em\"></span>\n   <span class='LowLimit-label' style=\"padding-right:0.2em\"><label>").concat(lowLimitLabel, "</label></span>\n   <span class='LowLimit'></span>\n  ");
  };

  /**
   *  Baja UX field editor for Raw Data Field Editor
   *  It has two Rollover Value Editors to accept the user input.
   *  High Limit and Low limit is the limit beyond which the values will be filtered out.The text box accepts double values
   *  If the check box for high limit is checked then the text box gets disabled and high limit will not be applied
   *  If the check box for low limit is checked then the text box gets disabled and low limit will not be applied
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/RawDataFilterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */
  var RawDataFilterEditor = /*#__PURE__*/function (_ComplexCompositeEdit) {
    function RawDataFilterEditor() {
      _classCallCheck(this, RawDataFilterEditor);
      return _callSuper(this, RawDataFilterEditor, arguments);
    }
    _inherits(RawDataFilterEditor, _ComplexCompositeEdit);
    return _createClass(RawDataFilterEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;
        dom.addClass('RawDataFilterEditor');
        dom.html(rawDataFilterEditor());
        this.validators().add(function (value) {
          var val = _this.value(),
            highVal = val.getHighLimit(),
            lowVal = val.getLowLimit();
          if (!highVal.getUnspecified() && !lowVal.getUnspecified()) {
            var highLimit = highVal.getValue();
            var lowLimit = lowVal.getValue();
            if (!isValid(highLimit, lowLimit)) {
              return Promise.reject(new Error(lex.get("outlier.limitError")));
            }
          }
        });
        return _superPropGet(RawDataFilterEditor, "doInitialize", this, 3)(arguments);
      }

      /**
       * Initialize editors for the `HighLimit` and `LowLimit` slots.
       *
       * @returns {Array}
       */
    }, {
      key: "getSlotFilter",
      value: function getSlotFilter() {
        return [{
          slot: 'HighLimit',
          type: RolloverValueEditor
        }, {
          slot: 'LowLimit',
          type: RolloverValueEditor
        }];
      }

      /**
       * @overrides module:nmodule/webEditors/rc/fe/CompositeEditor
       * @returns {CompositeBuilder}
       */
    }, {
      key: "makeBuilder",
      value: function makeBuilder() {
        var _this2 = this;
        var builder = _superPropGet(RawDataFilterEditor, "makeBuilder", this, 3)(arguments);
        builder.getDomFor = function (key) {
          var jq = _this2.jq(),
            jqElement = jq;
          switch (key) {
            case 'HighLimit':
              return $('.HighLimit', jqElement);
            case 'LowLimit':
              return $('.LowLimit', jqElement);
            default:
              break;
          }
        };
        return builder;
      }

      /**
       * Reads the value of the value editor from the RolloverValue Editor.
       * @returns {Promise}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var builder = this.getBuilder(),
          highLimitEd = builder.getEditorFor('HighLimit'),
          lowLimitEd = builder.getEditorFor('LowLimit');
        var highLimitVal = highLimitEd.value(),
          lowLimitVal = lowLimitEd.value();
        return Promise.join(highLimitEd.read(), lowLimitEd.read(), function (highLimitDiff, lowLimitDiff) {
          return Promise.join(highLimitDiff.apply(highLimitVal), lowLimitDiff.apply(lowLimitVal));
        });
      }
    }]);
  }(ComplexCompositeEditor);
  /**
   * Function is used to check if the highLimit is greater than the low Limit
   * @param {double} highLimit - high limit for raw data filter
   * @param {double} lowLimit - low limit for raw data filter
   * @returns {boolean}
   */
  function isValid(highLimit, lowLimit) {
    return highLimit >= lowLimit;
  }
  return RawDataFilterEditor;
});
