/* eslint-disable promise/no-return-wrap */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/JSONUxNodeSelectionEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'dialogs', 'underscore', 'bajaux/events', 'bajaux/dragdrop/dragDropUtils', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/analytics/rc/report/util/reportConstants', 'nmodule/analytics/rc/report/fe/UxNodeSelectionEditor', 'lex!analytics', 'baja!analytics:AnalyticNodeGroup,analytics:AnalyticNode,gx:Color', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, $, Promise, Widget, subscriberMixIn, dialogs, _, events, dragDropUtils, BaseEditor, fe, reportConstants, UxNodeSelectionEditor, lexicon, types) {
  'use strict';

  /**
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/JSONUxNodeSelectionEditor
   * @extends module:nmodule/analytics/rc/report/fe/UxNodeSelectionEditor
   */
  var JSONUxNodeSelectionEditor = function JSONUxNodeSelectionEditor() {
    UxNodeSelectionEditor.apply(this, arguments);
  };
  /**
   * Attach the parent's prototye and change the constructor and overidden methods
   * @type {BaseEditor}
   */
  JSONUxNodeSelectionEditor.prototype = Object.create(UxNodeSelectionEditor.prototype);

  // Setting the constructor
  JSONUxNodeSelectionEditor.prototype.constructor = JSONUxNodeSelectionEditor;

  /**
   * Initalize the Node selection FE with blank node group place holder
   * @param dom
   */
  JSONUxNodeSelectionEditor.prototype.doInitialize = function (dom) {
    return UxNodeSelectionEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   *
   * @param {baja.Folder} folder a `baja:Folder` value, which contains a list
   * of 'analytics:AnalyticNodeGroup'
   */
  JSONUxNodeSelectionEditor.prototype.doLoad = function (jsonStr) {
    var that = this;
    // eslint-disable-next-line promise/catch-or-return
    that.getAnalyticNodeHierarchy(jsonStr || "{}").then(function (root) {
      arguments[0] = root;
      return UxNodeSelectionEditor.prototype.doLoad.apply(that, arguments);
    });
  };

  /**
   * Read the value from parent and serialize to JSON
   * @param root
   * @returns {Promise|*}
   */
  JSONUxNodeSelectionEditor.prototype.doRead = function () {
    var that = this;
    return UxNodeSelectionEditor.prototype.doRead.apply(this, arguments).then(function (groups) {
      var ret = {};
      for (var i = 0; i < groups.length; i++) {
        var nodeList = [];
        var nodes = groups[i].getSlots().is("analytics:AnalyticNode").toArray(),
          nodeLen = nodes.length;
        for (var j = 0; j < nodeLen; j++) {
          var node = groups[i].get(nodes[j]);
          nodeList.push({
            name: node.getDisplayName(),
            ord: node.getNodePath().encodeToString()
          });
        }
        ret[groups[i].getName()] = {
          "guid": groups[i].getGuid() || groups[i].getName(),
          "dn": groups[i].getDisplayName() || groups[i].getName(),
          "color": groups[i].getSeriesColor().encodeToString(),
          "nodeList": nodeList
        };
        var elem = $('span.group-content:eq(' + i + ')', that.jq());
        var navWidget = elem.parent().data('widget');
        if (navWidget) {
          navWidget.resetGuid();
        }
      }
      return Promise.resolve(JSON.stringify(ret));
    });
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  JSONUxNodeSelectionEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  JSONUxNodeSelectionEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  JSONUxNodeSelectionEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  /**
   * This function converts the JSON string to baja Folder heirarchy
   */
  JSONUxNodeSelectionEditor.prototype.getAnalyticNodeHierarchy = function (nodeHierarchyTree) {
    var jsonObj = _.isString(nodeHierarchyTree) ? JSON.parse(nodeHierarchyTree || "{}") : nodeHierarchyTree;
    var root = baja.$("baja:Folder");
    var pList = [],
      dMap = {};
    _.each(jsonObj, function (valueObj, key, list) {
      var analyticGroup = baja.$("analytics:AnalyticNodeGroup");
      analyticGroup.setGuid(valueObj.guid);
      var color = valueObj.color || "#000000"; // Pls read from constants
      analyticGroup.setSeriesColor(baja.$("gx:Color").decodeFromString(color));
      // analyticGroup.setGuid(_.uniqueId(reportConstants.GRP_GUID_PREFIX));
      var promise = analyticGroup.add({
        slot: "displayNames",
        value: baja.NameMap.make({})
      }).then(function () {
        var value = valueObj.nodeList,
          dMap = {};
        var npList = [];
        if (_.isArray(value)) {
          var isSingleNodeConfig = value.length === 1 && value[0].name === (valueObj.dn || key);
          _.each(value, function (nodeObj, i) {
            var analyticNode = baja.$("analytics:AnalyticNode", {
              nodePath: nodeObj.ord
            });
            var obj = {
              slot: nodeObj.name + "?",
              value: analyticNode
            };
            if (isSingleNodeConfig) {
              obj.flags = baja.Flags.HIDDEN;
            }
            npList.push(analyticGroup.add(obj).then(function (prop) {
              dMap[prop.getName()] = nodeObj.name;
              return Promise.resolve(dMap);
            }));
          });
        }
        return Promise.all(npList).then(function () {
          return analyticGroup.set({
            slot: "displayNames",
            value: baja.NameMap.make(dMap)
          });
        });
      }).then(function () {
        var dn = valueObj.dn ? valueObj.dn : key;
        return root.add({
          slot: key,
          value: analyticGroup
        }).then(function () {
          dMap[key] = dn;
          return Promise.resolve(dMap);
        });
      });
      pList.push(promise);
    });
    return Promise.all(pList).then(function () {
      return root.add({
        slot: "displayNames",
        value: baja.NameMap.make(dMap)
      }).then(function () {
        return Promise.resolve(root);
      });
    });
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  JSONUxNodeSelectionEditor.prototype.doDestroy = function () {
    var that = this;
    that.jq().remove();
    return UxNodeSelectionEditor.prototype.doDestroy.apply(this, arguments);
  };
  return JSONUxNodeSelectionEditor;
});
