/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E845876 on 5/9/2017.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'underscore', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'hbs!nmodule/analytics/rc/report/templates/UxDegreeDayMappingEditor', 'nmodule/analytics/rc/report/fe/AnalyticOrdChooser', 'lex!analytics', 'css!nmodule/analytics/rc/report/styles/uxstyles', 'baja!analytics:AnalyticDegreeDayNodeItem'], function (baja, lexs, $, Promise, _, Widget, fe, events, BaseEditor, UxDegreeDayMappingEditor, AnalyticOrdChooser, types) {
  'use strict';

  var lex = lexs[0];
  /**
   * <pre> DegreeDayGroupMapEditor </pre>
   * This field editor is used to edit key value pairs of group name and the Ord for the node which has the Outside air
   * temperature configured.
   * <p>
   * @param params
   * @constructor
   */
  var DegreeDayGroupMapEditor = function DegreeDayGroupMapEditor(params) {
    BaseEditor.apply(this, arguments);
  };
  DegreeDayGroupMapEditor.prototype = Object.create(BaseEditor.prototype);
  DegreeDayGroupMapEditor.prototype.constructor = DegreeDayGroupMapEditor;

  /**
   * Creates the template for Combination data map Editor.
   * @param {jQuery} dom
   */
  DegreeDayGroupMapEditor.prototype.doInitialize = function (dom) {
    var that = this,
      groups = that.properties().getValue("groups");
    that.gMap = {};
    dom.append(UxDegreeDayMappingEditor({
      grpName: lex.get("report.headerText.groupName"),
      grpNode: lex.get("node"),
      groups: _.map(groups, function (group) {
        return baja.SlotPath.unescape(group.display);
      })
    }));
    var promiseList = [];
    for (var index = 0; index < groups.length; index++) {
      var gnFE = fe.buildFor({
        dom: $(".grp-name-" + index, that.jq()),
        value: baja.SlotPath.unescape(groups[index].display),
        properties: {
          guid: groups[index].tag
        },
        readonly: true,
        formFactor: 'mini'
      });
      promiseList.push(gnFE);
      var gNodeElem = $(".grp-node-" + index, that.jq());
      that.gMap[groups[index].tag] = gNodeElem;
    }
    return Promise.all(promiseList);
  };
  /**
   * Creates the template for Combination data map Editor.
   * @param {jQuery} dom
   */
  DegreeDayGroupMapEditor.prototype.doLoad = function (value) {
    var degreeDayMappings = value.getSlots().properties().dynamic().is("analytics:AnalyticDegreeDayNodeItem").toValueArray();
    var that = this,
      promiseList = [];
    _.each(degreeDayMappings, function (mapping, i) {
      var gne = mapping.getGuid(),
        root = that.gMap[gne];
      if (root) {
        var degDayFE = fe.buildFor({
          dom: root,
          value: baja.Ord.make(mapping.getDegDayRoot()),
          type: AnalyticOrdChooser,
          formFactor: 'mini'
        });
        that.gMap = _.omit(that.gMap, gne);
        promiseList.push(degDayFE);
      }
    });
    _.each(that.gMap, function (val, key) {
      promiseList.push(fe.buildFor({
        dom: val,
        value: baja.Ord.make("slot:"),
        type: AnalyticOrdChooser,
        formFactor: 'mini'
      }));
    });
    return Promise.all(promiseList);
  };

  /**
   * Read the map of DegreeDayGroupMapEditor components.
   */
  DegreeDayGroupMapEditor.prototype.doRead = function () {
    var that = this;
    var map = this.value(),
      itemType = "analytics:AnalyticDegreeDayNodeItem";
    var removeList = [];
    map.getSlots().is(itemType).each(function (slot) {
      removeList.push(map.remove(slot));
    });
    return Promise.all(removeList).then(function () {
      var childEditors = that.getChildEditors();
      return childEditors.readAll().then(function (editorValues) {
        var promiseList = [];
        for (var i = 0; i < editorValues.length; i += 2) {
          var item = baja.$(itemType);
          var gn = baja.SlotPath.unescape(editorValues[i]);
          item.setGroupName(gn);
          item.setDegDayRoot(editorValues[i + 1]);
          var guid = childEditors[i].properties().getValue('guid') || 0;
          item.setGuid(guid);
          promiseList.push(map.add({
            value: item
          }));
        }
        return Promise.all(promiseList).then(function () {
          return map;
        });
      });
    });
  };
  return DegreeDayGroupMapEditor;
});
