/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E491819 on 5/9/2017.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/report/fe/AnalyticDataTagEditor', 'hbs!nmodule/analytics/rc/report/templates/UxDataTagSelector', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, feDialogs, events, BaseEditor, AnalyticDataTagEditor, UxDataTagSelector) {
  'use strict';

  var lex = lexs[0];

  /**
   * A field editor for selecting data tags
   *   <caption>
   *       Use the contentDiv property with this specific field editor.
   *   </caption>
   *   fe.buildFor({
     *    value: 'hs:power',
     *     type: 'AnalyticDataTagSelector',
     *     dom: $('#dataTagSelectorDiv'),
     *     properties: { contentDiv: $("some div id"} }
   *   }).then(function (stringEditor) {
     *     // do the needful
     *   });
   *  If the property 'contentDiv' is not passed the data tag selection editor will be open
   *  inside a popup dialog
   * @param params
   * @constructor
   */
  var AnalyticDataTagSelector = function AnalyticDataTagSelector(params) {
    BaseEditor.apply(this, arguments);
  };
  AnalyticDataTagSelector.prototype = Object.create(BaseEditor.prototype);
  AnalyticDataTagSelector.prototype.constructor = AnalyticDataTagSelector;

  /**
   * Creates the template for Analytic Data Tag Selector.
   * @param {jQuery} dom
   */
  AnalyticDataTagSelector.prototype.doInitialize = function (dom) {
    dom.html(UxDataTagSelector());
    this.$registered = false;
    return BaseEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   *  Load the value of the tag in to the text box.
   *  Register an event on the selection button
   * @param dom
   */
  AnalyticDataTagSelector.prototype.doLoad = function (val) {
    this.$getDataElement().val(val);
    if (!this.$registered) {
      this.registerEvents(val);
      this.$registered = true;
    }
    return Promise.resolve(val);
  };

  /**
   * Returns the selected data tag
   * @returns {String} the selected data tag
   */
  AnalyticDataTagSelector.prototype.doRead = function () {
    return this.$getDataElement().val();
  };

  /**
   * Register events for the tag chooser editor
   */
  AnalyticDataTagSelector.prototype.registerEvents = function (val) {
    var that = this;
    var jq = that.jq();
    var props = this.properties();
    var contentDiv = props.getValue("contentDiv");
    var hasContentRoot = false;
    var de = this.$getDataElement();
    that.$lastVal = val;
    de.on("input propertychange paste", function () {
      that.setModified(that.doRead() !== that.$lastVal);
      that.$lastVal = that.doRead();
    });
    var feBase = {
      value: val,
      type: AnalyticDataTagEditor,
      title: lex.get("dataTag.select.title")
    };
    if (contentDiv) {
      hasContentRoot = true;
    }
    this.$offClickHandler();
    jq.on('click', 'span.datatag-select-icon', function () {
      if (hasContentRoot) {
        // Open the field editor in the content div
        fe.buildFor($.extend(feBase, {
          dom: contentDiv
        }));
      } else {
        // Open the tag editor in a popup
        feDialogs.showFor($.extend(feBase, {
          progressCallback: function progressCallback(msg, arg) {}
        })).then(function (str) {
          if (str !== null) {
            that.$getDataElement().val(str);
            that.setModified(true);
          }
        })["finally"](function () {});
      }
    });
  };
  /**
   * Unregister any event handlers
   * @param dom
   */
  AnalyticDataTagSelector.prototype.doDestroy = function (dom) {
    this.$offClickHandler();
    return BaseEditor.prototype.doDestroy.apply(this, arguments);
  };
  AnalyticDataTagSelector.prototype.$offClickHandler = function () {
    var jq = this.jq();
    $("span.datatag-select-icon", jq).off();
    this.$registered = false;
  };
  /**
   * Get the reference to text box
   * @returns {*|jQuery|HTMLElement}
   */
  AnalyticDataTagSelector.prototype.$getDataElement = function () {
    var jq = this.jq();
    return $(".dataSelectValue", jq);
  };
  return AnalyticDataTagSelector;
});
