/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 *
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/report/container/base/AnalyticsBaseReport', 'nmodule/analytics/rc/chart/spectrum/SpectrumChart', 'nmodule/analytics/rc/table/AnalyticsBaseTable', 'lex!analytics', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, d3, fe, feDialogs, AnalyticsBaseReport, SpectrumChart, AnalyticsBaseTable, lexicon) {
  "use strict";

  var lex = lexicon[0];
  var SpectrumReport = function SpectrumReport(params) {
    AnalyticsBaseReport.apply(this, $.extend({}, params));
  };
  SpectrumReport.prototype = Object.create(AnalyticsBaseReport.prototype);
  SpectrumReport.prototype.constructor = SpectrumReport;
  SpectrumReport.prototype.getChartType = function () {
    return SpectrumChart;
  };
  SpectrumReport.prototype.getTableType = function () {
    return AnalyticsBaseTable;
  };

  /**
   * Get the list of settings applicable for Spectrum Chart
   * @returns {*}
   */
  /**
   * Get the list of settings applicable for Spectrum Chart
   * @returns {*}
   */
  SpectrumReport.prototype.getApplicableSettings = function () {
    var baseSettings = AnalyticsBaseReport.prototype.getApplicableSettings.apply(this, arguments);
    return $.extend(baseSettings, {
      interval: {
        req: true,
        value: "fifteenMinutes",
        selected: true
      },
      dataTag: {
        req: true,
        value: "hs:power"
      },
      colorRange: {
        req: true,
        value: {
          maxColor: "red",
          minColor: "blue",
          avgColor: "white"
        }
      },
      extras: {
        groupLimit: 1,
        groupLimitMessage: lex.get({
          key: "spectrum.settings.nodecountlimit.content",
          args: [1],
          showColorSelector: false
        })
      },
      legendPosition: {
        req: false,
        value: ""
      }
    });
  };

  /**
   * Overridden Report name
   */
  SpectrumReport.prototype.getReportName = function () {
    return lex.get("report.spectrum");
  };

  /**
   * Returns the requirement of the report to aggregate the MultiNode or MultiOrd Requests.
   * @returns {boolean}
   */
  SpectrumReport.prototype.getAggMode = function () {
    return true;
  };

  /**
   * Some child reports might support multi part rollup and data tags.
   * @returns {boolean}
   */
  SpectrumReport.prototype.isColorChoiceAllowed = function () {
    return false;
  };

  /**
   * Returns the report name
   * @returns {string}
   */
  SpectrumReport.prototype.getName = function () {
    return "SpectrumReport";
  };
  return SpectrumReport;
});
