/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/report/container/base/AnalyticsBaseReport', 'nmodule/analytics/rc/chart/equipop/eqopaggregate/EqOpAggregateChart', 'nmodule/analytics/rc/table/AnalyticsBaseTable', 'lex!analytics', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, d3, fe, feDialogs, AnalyticsBaseReport, EqOpAggregateChart, AnalyticsBaseTable, lexicon) {
  "use strict";

  var lex = lexicon[0];
  var EquipmentOperationReport = function EquipmentOperationReport(params) {
    AnalyticsBaseReport.apply(this, $.extend({}, params));
  };
  EquipmentOperationReport.prototype = Object.create(AnalyticsBaseReport.prototype);
  EquipmentOperationReport.prototype.constructor = EquipmentOperationReport;

  /**
   * Displa Average Profile Chart in this report
   * @returns {*}
   */
  EquipmentOperationReport.prototype.getChartType = function () {
    return EqOpAggregateChart;
  };
  EquipmentOperationReport.prototype.getTableType = function () {
    return AnalyticsBaseTable;
  };

  /**
   * Get the list of settings applicable for Average Profile Chart
   * @returns {*}
   */
  EquipmentOperationReport.prototype.getApplicableSettings = function () {
    var baseSettings = AnalyticsBaseReport.prototype.getApplicableSettings.apply(this, arguments);
    return $.extend(baseSettings, {
      interval: {
        req: true,
        value: "none",
        selected: true
      },
      dataTag: {
        req: true,
        value: "hs:run"
      },
      // rollup: {req: true, value: "mode"},
      // aggregation: {req: true, value: "or"},
      units: {
        req: true,
        value: ""
      },
      extras: {
        showColorSelector: true
      },
      legendPosition: {
        req: false,
        value: ""
      }
    });
  };

  /**
   * Overridden Report name
   */
  EquipmentOperationReport.prototype.getReportName = function () {
    return lex.get("report.equipoperation");
  };

  /**
   * Returns the requirement of the report to aggregate the MultiNode or MultiOrd Requests.
   * @returns {boolean}
   */
  EquipmentOperationReport.prototype.getAggMode = function () {
    return true;
  };

  /**
   * Returns the report name
   * @returns {string}
   */
  EquipmentOperationReport.prototype.getName = function () {
    return "EquipmentOperationReport";
  };
  EquipmentOperationReport.prototype.showLegend = function () {
    return true;
  };

  /**
   * Some child reports might support multi part rollup and data tags.
   * @returns {boolean}
   */
  EquipmentOperationReport.prototype.isMultiPartSupported = function () {
    return false;
  };

  /**
   * This aggregates the data for Aggregation report
   * @param chartDataModel
   * @param source
   */
  EquipmentOperationReport.prototype.processDataForTable = function (chart, source) {
    var grpArray = [],
      processedSeriesList = chart.series,
      modelList = chart.getModel();
    _.each(processedSeriesList, function (processedSeries, index) {
      var data = processedSeries.data,
        model = modelList[index];
      var inMemArr = [];
      _.each(data, function (dataItem, index1) {
        var inObj = {};
        if (index === 0) {
          inObj.x = dataItem.x;
          inObj.y = dataItem.y;
        }
        inObj[model.getSeriesName()] = dataItem.y;
        inObj[model.getSeriesName() + "interpolationStatus"] = dataItem.metaData.interpolationStatus;
        inObj.date = dataItem.x.getTime();
        inMemArr.push(inObj);
      });
      grpArray.push(inMemArr);
    });
    var consolidatedObjects = [];
    var trendCount = grpArray.length;
    if (trendCount > 0) {
      var recordCount = grpArray[0].length;
      for (var i = 0; i < recordCount; i++) {
        var obj = {};
        for (var j = 0; j < trendCount; j++) {
          for (var key in grpArray[j][i]) {
            if (key) {
              var val = grpArray[j][i][key];
              obj[key] = key === 'x' || key === 'y' || key === 'date' ? val : val === 0 ? lex.get("chart.equipment.op.off") : val === 1 ? lex.get("chart.equipment.op.on") : "";
            }
          }
        }
        consolidatedObjects.push(obj);
      }
    }
    return consolidatedObjects;
  };

  /**
   * Format the X Value
   * @returns {Function}
   */
  EquipmentOperationReport.prototype.getTableKeyFormatter = function () {
    var that = this;
    return function (xVal, key) {
      if (key === 'date') {
        return new Date(xVal).toLocaleString();
      } else if (key === 'y' || key === 'yPercentile') {
        var val = xVal;
        if (xVal.toString().indexOf(".") !== -1) {
          val = d3.format(".1f")(xVal);
        }
        if (key === 'yPercentile') {
          val += "%";
        }
        return val;
      }
      return AnalyticsBaseReport.prototype.getTableKeyFormatter.apply(that)(xVal, key);
    };
  };
  return EquipmentOperationReport;
});
