/* eslint-disable promise/no-return-wrap */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/command/AnalyticNodeRenameCommand
 */
define(['baja!', 'lex!webEditors', 'underscore', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/ComponentEditorCommand', 'nmodule/webEditors/rc/wb/commands/RenameCommand', 'nmodule/analytics/rc/report/util/reportWidgetEvents'], function (baja, lexs, _, $, Promise, feDialogs, ComponentEditorCommand, RenameCommand, reportWidgetEvents) {
  'use strict';

  var lex = lexs[0];
  /**
   * A command for renaming slots on an editor's `Component` value.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/ComponentEditorCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/RenameCommand
   * @param {module:bajaux/Widget} ed the `Widget` to bind this `Command` to
   * @param {baja.Component} component the component on which to rename slots
   * @throws {Error} if no `Widget` provided
   */
  var AnalyticNodeRenameCommand = function AnalyticNodeRenameCommand(ed, component, wIndex) {
    var that = this;
    that.$ed = ed;
    that.$oldName = component.getName();
    that.$wIndex = wIndex;
    ComponentEditorCommand.call(that, {
      module: 'webEditors',
      lex: 'commands.rename'
    }, component);
    that.$renameCommand = new RenameCommand(ed, component);
  };
  AnalyticNodeRenameCommand.prototype = Object.create(ComponentEditorCommand.prototype);
  AnalyticNodeRenameCommand.prototype.constructor = AnalyticNodeRenameCommand;

  /**
   * Make sure we have admin write permissions and we're not renaming a
   * frozen slot.
   *
   * @param {baja.Component} comp
   * @param {baja.Slot} slot
   * @returns {Boolean} true if I can rename this slot
   */
  AnalyticNodeRenameCommand.prototype.canPerformCommand = function (comp, slot) {
    return this.$renameCommand.canPerformCommand(comp, slot);
  };

  /**
   * Shows a dialog for the component's currently configured slot name,
   * and renames the slot after the user clicks OK.
   *
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots the slots to rename (*Note*: only the
   * first given slot will be renamed)
   * @returns {Promise}
   */
  AnalyticNodeRenameCommand.prototype.performCommand = function (node, slots, params) {
    var jsonNode;
    var performCommand = this.handleRename(node, this.$slots || slots);
    var that = this,
      oldName = that.$oldName;
    return performCommand.then(function (newName) {
      var dnObj = node.get('displayNames'),
        method = "add",
        dMap = {};
      // var newName = slots[0].getName();
      dMap[oldName] = newName;
      if (dnObj) {
        // Update the existing map
        var keys = dnObj.list();
        _.each(keys, function (key) {
          if (key !== oldName) {
            dMap[key] = dnObj.get(key).valueOf();
          }
        });
        method = "set";
      }
      return node[method]({
        slot: "displayNames",
        value: baja.NameMap.make(dMap)
      }).then(function () {
        var edList = that.$ed.getChildEditors(),
          ed = null;
        for (var wIndex = 0; wIndex < edList.length; wIndex++) {
          var wEd = edList[wIndex];
          var wProp = wEd.properties();
          if (wProp.getValue("wIndex") === that.$wIndex) {
            ed = wEd;
            break;
          }
        }
        if (ed) {
          jsonNode = ed.value();
          var renameInfo = {
            oldName: oldName,
            newName: newName
          };
          ed.jq().trigger(reportWidgetEvents.RE_RENDER_NODES_REQUEST, {
            data: jsonNode,
            meta: renameInfo
          });
        }
        return Promise.resolve(jsonNode);
      });
    })["catch"](baja.error);
  };
  /**
   * Custom implement the rename command in order to handle renaming to same group name.
   * @param comp
   * @param slots
   * @param params
   */
  AnalyticNodeRenameCommand.prototype.handleRename = function (comp, slots, params) {
    var slot = slots[0];
    if (!slot) {
      return Promise.reject(new Error('slot to rename required'));
    }
    var oldName = comp.get(slot).getDisplayName();
    return feDialogs.showFor({
      title: lex.get('commands.rename.description'),
      value: baja.SlotPath.unescape(oldName),
      formFactor: 'mini'
    }).then(function (newName) {
      if (newName === null) {
        return Promise.resolve(oldName);
      }
      if (newName.trim() === '') {
        throw new Error(lex.get('enterName'));
      }
      newName = baja.SlotPath.escape(newName.trim());
      if (newName) {
        return Promise.resolve(newName);
      }
    })["catch"](feDialogs.error);
  };
  return AnalyticNodeRenameCommand;
});
