/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/fe/JSONUxNodeSelectionEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'dialogs', 'underscore', 'bajaux/events', 'nmodule/analytics/rc/report/util/reportConstants', 'nmodule/analytics/rc/report/util/reportWidgetEvents', 'nmodule/analytics/rc/report/base/JSONAnalyticReportConfigEditor', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, $, Promise, Widget, subscriberMixIn, dialogs, _, events, reportConstants, reportWidgetEvents, JSONAnalyticReportConfigEditor) {
  'use strict';

  /**
   * Area enhanced report config editor
   * @class
   * @alias module:nmodule/analytics/rc/report/fe/JSONUxNodeSelectionEditor
   * @extends module:nmodule/analytics/rc/report/base/JSONAnalyticReportConfigEditor
   */
  var JSONAnalyticReportCfgAreaMixin = function JSONAnalyticReportCfgAreaMixin() {
    JSONAnalyticReportConfigEditor.apply(this, arguments);
  };
  /**
   * Attach the parent's prototype and change the constructor and overidden methods
   * @type {BaseEditor}
   */
  JSONAnalyticReportCfgAreaMixin.prototype = Object.create(JSONAnalyticReportConfigEditor.prototype);

  // Setting the constructor
  JSONAnalyticReportCfgAreaMixin.prototype.constructor = JSONAnalyticReportCfgAreaMixin;
  JSONAnalyticReportCfgAreaMixin.prototype.handleValueLoadEvents = function () {
    var that = this;
    that.jq().on(reportWidgetEvents.REPORT_AREA_VAL_LOADED, function (e, areaCfg) {
      var ed = that.getChildEditors()[0]; // Node selection editor
      if (ed) {
        ed.applyValueLoadEvent(areaCfg);
      }
    });
  };
  return JSONAnalyticReportCfgAreaMixin;
});
