/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/base/AnalyticReportConfigItemEditor
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/analytics/rc/report/fe/AnalyticReportPeriodSelectionFE', 'nmodule/analytics/rc/report/fe/AnalyticDataTagSelector', 'nmodule/analytics/rc/report/fe/decorator/JSONUxNodeAreaMixin', 'nmodule/analytics/rc/report/fe/OptionSelector', 'nmodule/analytics/rc/report/fe/AnalyticBaselineEditor', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/analytics/rc/report/fe/ColorRangeEditor', 'nmodule/webEditors/rc/fe/baja/UnitEditor', 'nmodule/analytics/rc/report/fe/AnalyticNormalizationEditor', 'nmodule/analytics/rc/report/fe/CombinationDataMapEditor', 'nmodule/analytics/rc/report/fe/MissingDataStrategyEditor', 'nmodule/analytics/rc/report/fe/ReportOptionalValueFE', 'nmodule/analytics/rc/report/fe/ReportCombinerOptionalValueFE', 'lex!analytics', 'baja!analytics:AnalyticCompositeConfiguration,analytics:AnalyticReportConfiguration,analytics:AnalyticConfigurationItem', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, $, Promise, Widget, fe, events, ComplexCompositeEditor, AnalyticReportPeriodSelectionFE, AnalyticDataTagSelector, JSONUxNodeAreaMixin, OptionSelector, AnalyticBaselineEditor, StringEditor, FrozenEnumEditor, BooleanEditor, ColorRangeEditor, UnitEditor, AnalyticNormalizationEditor, CombinationDataMapEditor, MissingDataStrategyEditor, ReportOptionalValueFE, ReportCombinerOptionalValueFE, lexs, types) {
  'use strict';

  var lex = lexs[0];
  /**
   * A field editor to be used in Analytics module for configuring all report
   * related parameters
   *
   * @class
   * @alias module:nmodule/analytics/rc/report/base/AnalyticReportConfigItemEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */
  var AnalyticReportConfigItemEditor = function AnalyticReportConfigItemEditor(params) {
    ComplexCompositeEditor.call(this, $.extend({
      keyName: 'AnalyticReportConfigItemEditor'
    }, params));
  };
  AnalyticReportConfigItemEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  AnalyticReportConfigItemEditor.prototype.constructor = AnalyticReportConfigItemEditor;

  /**
   * Get the list of slots to be displayed
   * @param value
   */
  AnalyticReportConfigItemEditor.prototype.getSlotFilter = function (item) {
    var slotList = [];
    // Push by name (the first 3 are mandatory)
    if ((this.$edName = item.getName()) === "node") {
      slotList = [{
        slot: "propertyValue",
        type: JSONUxNodeAreaMixin,
        properties: this.properties().toValueMap()
      }];
    } else if ((this.$edName = item.getName()) === "dataTag") {
      slotList = [{
        slot: "propertyValue",
        type: AnalyticDataTagSelector
      }];
    } else if ((this.$edName = item.getName()) === "timeRange") {
      slotList = [{
        slot: "propertyValue",
        type: AnalyticReportPeriodSelectionFE,
        properties: {
          showDOWInclusion: true
        }
      }];
      // eslint-disable-next-line brace-style
    }
    // The comprehensive ones
    else if ((this.$edName = item.getName()) === "rollup" || item.getName() === "aggregation") {
      slotList = [{
        slot: "propertyValue",
        type: ReportCombinerOptionalValueFE,
        properties: this.properties().toValueMap()
        // properties: {
        //     propName: item.getName()
        // }
      }];
    } else if ((this.$edName = item.getName()) === "dataFilter") {
      slotList = [{
        slot: "propertyValue",
        type: StringEditor
      }];
    } else if ((this.$edName = item.getName()) === "units") {
      slotList = [{
        slot: "propertyValue",
        type: UnitEditor
      }];
      // eslint-disable-next-line brace-style
    }
    // Now the configurable ones
    else if ((this.$edName = item.getName()) === "interval") {
      slotList = [{
        slot: "propertyValue",
        type: ReportOptionalValueFE,
        properties: this.properties().toValueMap()
      }];
    } else if ((this.$edName = item.getName()) === "baseline") {
      slotList = [{
        slot: "propertyValue",
        type: AnalyticBaselineEditor,
        properties: this.properties().toValueMap()
      }];
    } else if ((this.$edName = item.getName()) === "colorRange") {
      slotList = [{
        slot: "propertyValue",
        type: ColorRangeEditor
      }];
    } else if ((this.$edName = item.getName()) === "chartValue") {
      slotList = [{
        slot: "propertyValue",
        type: OptionSelector,
        properties: this.properties().toValueMap()
      }];
    } else if ((this.$edName = item.getName()) === "normalizationConfig") {
      slotList = [{
        slot: "propertyValue",
        type: AnalyticNormalizationEditor,
        properties: this.properties().toValueMap()
      }];
    } else if ((this.$edName = item.getName()) === "missingDataStrategy") {
      slotList = [{
        slot: "propertyValue",
        type: MissingDataStrategyEditor
      }];
    } else if ((this.$edName = item.getName()) === "rollupDataTagMap") {
      slotList = [{
        slot: "propertyValue",
        type: CombinationDataMapEditor
      }];
    } else if ((this.$edName = item.getName()) === "hisTotEnabled") {
      var msg = lex.get("testTotalizeNeql.message");
      slotList = [{
        slot: "propertyValue",
        type: BooleanEditor,
        properties: {
          trueText: msg,
          falseText: msg
        }
      }];
    } else if ((this.$edName = item.getName()) === "interpolationStatus") {
      slotList = [{
        slot: "propertyValue",
        type: BooleanEditor
      }];
    } else if ((this.$edName = item.getName()) === "legendPosition") {
      slotList = [{
        slot: "propertyValue",
        type: FrozenEnumEditor
      }];
    }
    return slotList;
  };

  /**
   * Read the value
   */
  AnalyticReportConfigItemEditor.prototype.doRead = function () {
    if (this.$edName === "interval" || this.$edName === "rollup" || this.$edName === "aggregation") {
      var ed = this.getChildEditors();
      if (ed.length === 1) {
        this.value().setSelected(ed[0].properties().getValue('selected'));
      }
    }
    return ComplexCompositeEditor.prototype.doRead.apply(this, arguments);
  };

  /**
   * Update the child editors
   */
  AnalyticReportConfigItemEditor.prototype.doUpdate = function (parent) {
    // Right now handle chart valye FE
    if (this.$edName === "chartValue") {
      var ed = this.getChildEditors();
      if (ed.length === 1) {
        return ed[0].doUpdate(parent.getChartValueProperties(parent.$comp.getRollupDataTagMap()));
      }
    }
    if (this.$edName === "baseline" || this.$edName === "normalizationConfig") {
      var edbn = this.getChildEditors();
      if (edbn.length === 1) {
        return parent.read().then(function () {
          return edbn[0].doUpdate(parent.getGroupList(parent.$comp.getNode()), parent.$comp.getTimeRange().getPropertyValue().getTimeRange());
        });
      }
    }
    return Promise.resolve(true);
  };

  /**
   * Update the child editors with dynamically loaded values
   * like area, color range value limits etc.
   */
  AnalyticReportConfigItemEditor.prototype.applyValueLoadEvent = function (valueCfg) {
    // Right now handle chart value FE
    if (this.$edName === "node") {
      var ed = this.getChildEditors();
      if (ed.length === 1) {
        ed[0].doUpdate(valueCfg);
      }
    }
    return Promise.resolve(true);
  };
  return AnalyticReportConfigItemEditor;
});
