/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/chart/utils/AnalyticsChartDragDropUtils
 */
define(['jquery', 'bajaux/dragdrop/dragDropUtils', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/analyticEvents', 'lex!analytics'], function ($, dragDropUtils, analyticsUtil, analyticEvents, lexicon) {
  "use strict";

  var AnalyticsChartDragDropUtils = {};
  var DRAG_ENABLER_CLASS = 'analytics-dashboard-widget-drag-over';
  var lex = lexicon[0];

  /**
   * Register a drag  drop handler for the chart
   */
  AnalyticsChartDragDropUtils.registerDragDrop = function (element, drophandler) {
    var that = this;
    element.on('dragover', function (e) {
      element.addClass(DRAG_ENABLER_CLASS);
      if (AnalyticsChartDragDropUtils.$isMouseInsideChart.apply(that, [e])) {
        element.removeClass(DRAG_ENABLER_CLASS);
      }
      e.preventDefault();
    }).on('dragleave', function (e) {
      element.removeClass(DRAG_ENABLER_CLASS);
      e.preventDefault();
    }).on('drop', function (e) {
      element.removeClass(DRAG_ENABLER_CLASS);
      if (drophandler && $.isFunction(drophandler)) {
        drophandler(e);
      }
      e.preventDefault();
      e.stopPropagation();
    });
  };

  /**
   * Expecting the dragged over element to be in bounds of chart area.
   * If found that mouse is not present in chart area, remove the yellow color overlay.
   * @param {Event} e
   * @returns {boolean}
   */
  AnalyticsChartDragDropUtils.$isMouseInsideChart = function (e) {
    return e.clientX < this.windowSize.width * 0.10 || e.clientX > this.windowSize.width * 0.90 || e.clientY < this.windowSize.height * 0.10 || e.clientY > this.windowSize.height * 0.90;
  };

  /**
   * Handle the drop of any nav node on to the chart area.
   * The nav node will be serialized to a JSON and passed to the view for chart rendering.
   */
  AnalyticsChartDragDropUtils.handleChartDrop = function (chartView, dataTransfer) {
    return dragDropUtils.fromClipboard(dataTransfer).then(function (envelope) {
      switch (envelope.getMimeType()) {
        case 'niagara/navnodes':
          // eslint-disable-next-line promise/catch-or-return
          envelope.toJson().then(function (json) {
            var obj = json && json[0];
            if (obj && obj.ord) {
              if (analyticsUtil.isNodeExists(obj.ord, chartView)) {
                analyticsUtil.showError(lex.get("node.alreadyExists"));
              } else {
                chartView.$isDragDropInvoked = true;
                chartView.$isDataLimitReached = false;
                chartView.jq().find('.trCmdBar').trigger(analyticEvents.DROP_ACTION_PERFORMED);
                return chartView.load(obj);
              }
            }
          });
      }
    });
  };
  return AnalyticsChartDragDropUtils;
});
