/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by H463956 on 8/7/2022.
 */

define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/chart/fe/AnalyticDataEditorFE', 'nmodule/analytics/rc/chart/fe/AnalyticUxC3WebChartSettingsFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/loadDurationWebChartSettings', 'lex!baja,analytics', 'baja!webEditors:FrozenEnumEditor,webEditors:UnitEditor,webEditors:StringEditor,analytics:AnalyticDataEditor', 'nmodule/webChart/rc/fe/color/ColorEditor', 'nmodule/analytics/rc/chart/fe/AnalyticChartBaselineEditor'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, events, fe, feDialogs, BaseEditor, AnalyticDataEditor, AnalyticUxC3WebChartSettingsFE, loadDurationWebChartSettings, lexicon, types, ColorEditor, AnalyticChartBaselineEditor) {
  'use strict';

  var lex = lexicon[1];
  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:analytics/rc/chart/fe/AnalyticUxC3WebChartSettingsFE
   */
  var LoadDurationUxWebChartSettingsFE = function LoadDurationUxWebChartSettingsFE() {
    AnalyticUxC3WebChartSettingsFE.apply(this, arguments);
  };
  // Inheriting AnalyticUxC3WebChartSettingsFE from BaseEditor
  LoadDurationUxWebChartSettingsFE.prototype = Object.create(AnalyticUxC3WebChartSettingsFE.prototype);
  //Setting the constructor
  LoadDurationUxWebChartSettingsFE.prototype.constructor = LoadDurationUxWebChartSettingsFE;

  /**
   * Creates the necessary setting fields for configuring analytic web chart
   * @param {jQuery} dom
   */
  LoadDurationUxWebChartSettingsFE.prototype.doInitialize = function (dom) {
    // Load all properties in to the template
    var that = this;
    dom.html(loadDurationWebChartSettings(that.initParams()));
  };
  LoadDurationUxWebChartSettingsFE.prototype.initParams = function () {
    var that = this,
      params = AnalyticUxC3WebChartSettingsFE.prototype.initParams.apply(that);
    params.chartBaseline = lex.get("chartBaseline");
    return params;
  };
  LoadDurationUxWebChartSettingsFE.prototype.initFieldEditors = function (settingsObj) {
    var that = this;
    var fes = AnalyticUxC3WebChartSettingsFE.prototype.initFieldEditors.apply(that, [settingsObj]);
    fes.push({
      dom: $(".baselineFE", that.jq()),
      type: AnalyticChartBaselineEditor,
      value: settingsObj.getBaseline(),
      formFactor: 'mini',
      properties: {
        timeRange: settingsObj.getDetailedTimeRange()
      },
      keyName: "baseline"
    });
    return fes;
  };
  return LoadDurationUxWebChartSettingsFE;
});
