/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by H402747 on 8/7/2022.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/chart/fe/AnalyticChartBaselineDetailsFE', 'nmodule/analytics/rc/report/util/reportUtils', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, feDialogs, events, BaseEditor, AnalyticChartBaselineDetailsFE, reportUtils) {
  'use strict';

  var lex = lexs[0];

  /**
   * @param params
   * @constructor
   */
  var AnalyticChartBaselineEditor = function AnalyticChartBaselineEditor(params) {
    BaseEditor.apply(this, arguments);
  };
  AnalyticChartBaselineEditor.prototype = Object.create(BaseEditor.prototype);
  AnalyticChartBaselineEditor.prototype.constructor = AnalyticChartBaselineEditor;

  /**
   * Creates the template for Analytic Data Tag Selector.
   * @param {jQuery} dom
   */
  AnalyticChartBaselineEditor.prototype.doInitialize = function (dom) {
    dom.append('<input type="checkbox" class="chart-baseline-enabler">');
    // dom.append('<button type="button" class="ux-btn">' + lex.get('baseLine.details') + '</button>');
    dom.append('<label class="chart-baseline-dtls">' + lex.getSafe("baseLine.details.none") + '</label>');
    dom.append('<span class="chart-baseline-select-icon icon-icons-x16-find"></span>');
    this.$registered = false;
    return BaseEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   *  Load the value of the tag in to the text box.
   *  Register an event on the selection button
   * @param dom
   */
  AnalyticChartBaselineEditor.prototype.doLoad = function (val) {
    var that = this,
      jq = that.jq(),
      baselineTogglerElem = $(".chart-baseline-enabler", jq);
    if (val.getEnabled()) {
      baselineTogglerElem.prop('checked', true);
      that.$populateBaselineDtls(val);
    }
    if (!this.$registered) {
      this.registerEvents(val);
      this.$registered = true;
    }
    return Promise.resolve(val);
  };

  /**
   * Returns the selected data tag
   * @returns {String} the selected data tag
   */
  AnalyticChartBaselineEditor.prototype.doRead = function () {
    var that = this,
      jq = that.jq();
    var v = that.value();
    v.setEnabled($(".chart-baseline-enabler", jq).prop("checked"));
    return Promise.resolve(v);
  };

  /**
   * Register events for the tag chooser editor
   */
  AnalyticChartBaselineEditor.prototype.registerEvents = function (val) {
    var that = this;
    var jq = that.jq();
    var props = this.properties();
    var contentDiv = props.getValue("contentDiv");
    var hasContentRoot = false;
    var feBase = {
      value: val,
      type: AnalyticChartBaselineDetailsFE,
      title: lex.get("baseLine.details.title"),
      formFactor: "mini"
    };
    if (contentDiv) {
      hasContentRoot = true;
    }
    this.$offClickHandler();
    var blEnabler = $(".chart-baseline-enabler", jq);
    blEnabler.change(function (e) {
      var baslineDtlsElem = $(".chart-baseline-dtls", jq);
      if ($(this).prop('checked')) {
        that.$isEnabled = true;
        that.$populateBaselineDtls(val);
      } else {
        that.$isEnabled = true;
        baslineDtlsElem.html(lex.getSafe("baseLine.details.none"));
      }
      that.setModified(true);
    });
    jq.on('click', 'span.chart-baseline-select-icon', function () {
      if (blEnabler.prop("checked")) {
        var prop = that.properties();
        if (hasContentRoot) {
          // Open the field editor in the content div
          fe.buildFor($.extend(feBase, {
            dom: contentDiv,
            value: that.value()
          }));
        } else {
          // Open the tag editor in a popup
          feDialogs.showFor($.extend(feBase, {
            value: that.value(),
            properties: {
              timeRange: prop.getValue("timeRange")
            },
            progressCallback: function progressCallback(msg, arg) {}
          })).then(function (baseline) {
            if (baseline !== null) {
              that.$populateBaselineDtls(baseline);
              that.setModified(true);
            }
          })["finally"](function () {});
        }
      }
    });
  };

  /**
   *
   * @param val
   */
  AnalyticChartBaselineEditor.prototype.$populateBaselineDtls = function (val) {
    var that = this,
      jq = that.jq();
    var baslineDtlsElem = $(".chart-baseline-dtls", jq);
    var color = val.getBaselineColor(),
      timeRange = val.getTimeRange();
    baslineDtlsElem.css('color', color);
    baslineDtlsElem.html(lex.getSafe({
      key: "chart.baseline.dtls.format",
      args: [timeRange.getDisplayTag()]
    }));
  };
  AnalyticChartBaselineEditor.prototype.$offClickHandler = function () {
    var jq = this.jq();
    $("span.chart-baseline-select-icon", jq).off();
    this.$registered = false;
  };

  /**
   * Update the properties
   */
  AnalyticChartBaselineEditor.prototype.doUpdate = function (groupList, timeRange) {
    var that = this;
    that.properties().setValue("groups", groupList);
    that.properties().setValue("timeRange", timeRange);
    return Promise.resolve(true);
  };
  return AnalyticChartBaselineEditor;
});
