/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file Model for Tab Configuration Data for analytics views
 * @author : Komaravolu, sai
 *
 */
define(['baja!', 'jquery', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel'], function (baja, $, analyticsUtil, AnalyticsTabConfigBaseModel) {
  "use strict";

  /**
   * Represents a model for tab configurations.
   * @constructor
   */
  var AnalyticsTabConfigC3Model = function AnalyticsTabConfigC3Model(input) {
    AnalyticsTabConfigBaseModel.apply(this, [$.extend({}, {}, input)]);
    var that = this;
    that.$legendPosition = input.legendPosition || "inset";
  };
  AnalyticsTabConfigC3Model.prototype = Object.create(AnalyticsTabConfigBaseModel.prototype);
  AnalyticsTabConfigC3Model.prototype.constructor = AnalyticsTabConfigC3Model;
  AnalyticsTabConfigC3Model.prototype.getLegendPosition = function () {
    return this.$legendPosition;
  };
  AnalyticsTabConfigC3Model.prototype.setLegendPosition = function (legendPosition) {
    this.$legendPosition = legendPosition;
  };

  /**
   * Children should implement the method to rebuild the tab configuration model.
   * @param inModel
   */
  AnalyticsTabConfigC3Model.prototype.rebuild = function (inModel) {
    this.setLegendPosition(inModel.$legendPosition);
    return inModel;
  };

  /**
   * Open for implementation by children.
   * By default it returns false.
   * @param inModel
   * @returns {boolean}
   */
  AnalyticsTabConfigC3Model.prototype.equals = function (inModel) {
    return inModel.getLegendPosition() === this.getLegendPosition();
  };
  AnalyticsTabConfigC3Model.prototype.toString = function () {
    var that = this;
    var temp = AnalyticsTabConfigBaseModel.prototype.toString.apply(that);
    temp.legendPosition = that.$legendPosition;
    return temp;
  };
  return AnalyticsTabConfigC3Model;
});
