/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ux;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.net.HttpUtil;
import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.ux.BWbOrdTargetResolver;
import com.tridium.ux.NiagaraEnv;
import com.tridium.ux.UxUtil;
import com.tridium.web.RequireJsUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.bajaux.BBajauxJsBuild;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.web.BFormFactorEnum;
import javax.baja.web.WebDev;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.BJsBuild;
import javax.baja.web.js.JsInfo;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WbWebWidgetServlet
extends HttpServlet {
    public static final String themeNameKey = "theme";
    public static final String useLocalWbRcKey = "useLocalWbRc";
    public static final String attachAfterInitKey = "attachAfterInit";
    private static final boolean forceUseAsyncTimeout = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.forceAsyncTimeout"));
    private static final Pattern ordPattern = Pattern.compile("([^/]+:.+)$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context cx;
        BOrd jsOrd;
        WebWidgetInitInfo info;
        Matcher matcher;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            resp.sendError(404, "No path info found!");
            return;
        }
        String uri = pathInfo;
        if (uri.startsWith("/")) {
            uri = uri.substring(1, uri.length());
        }
        if (!(matcher = ordPattern.matcher(uri)).find()) {
            resp.sendError(404, "Invalid ORD!");
            return;
        }
        uri = matcher.group(1);
        if (req.getQueryString() != null && uri.startsWith("view:")) {
            uri = uri + "?" + req.getQueryString();
        }
        if ((info = WbWebWidgetServlet.getWebWidgetInitInfo(jsOrd = BOrd.make((String)HttpUtil.decodeUrl((String)uri)), cx = (Context)req.getAttribute("niagara.context"))) == null) {
            resp.sendError(404);
            return;
        }
        JSONObject params = null;
        Map paramMap = req.getParameterMap();
        if (paramMap != null && paramMap.size() > 0) {
            Set keys = paramMap.keySet();
            String[] paramNames = keys.toArray(new String[0]);
            String[] values = new String[paramNames.length];
            for (int i = 0; i < paramNames.length; ++i) {
                String[] vals = (String[])paramMap.get(paramNames[i]);
                values[i] = vals != null && vals.length > 0 ? vals[0] : "";
            }
            params = WbWebWidgetServlet.paramsToJsonObject(paramNames, values);
        }
        resp.setContentType("text/html");
        HtmlWriter out = null;
        try {
            out = new HtmlWriter((Writer)resp.getWriter());
            out.w((Object)"<!DOCTYPE html>").nl();
            out.w((Object)"<html>").nl();
            out.w((Object)"<head>").nl();
            out.w((Object)"<title>").w((Object)info.getDisplayName()).w((Object)"</title>").nl();
            boolean isJavaFx = Objects.toString(req.getHeader("User-Agent"), "").contains("JavaFX");
            WbWebWidgetServlet.writeNiagaraAsyncFunction(out, isJavaFx);
            boolean useLocalWbRc = params != null && params.getBoolean(useLocalWbRcKey);
            boolean bindResources = !useLocalWbRc && !WebDev.get((String)"js").isEnabled() && !WebDev.get((String)"search").isEnabled() && !WebDev.get((String)"webChart").isEnabled() && !WebDev.get((String)"webEditors").isEnabled() && !WebDev.get((String)"bajaScript").isEnabled() && !WebDev.get((String)"hierarchy-ux").isEnabled();
            String themeName = params != null && params.has(themeNameKey) ? JSONUtil.getString((JSONObject)params, (String)themeNameKey) : "";
            RequireJsUtil requireJsUtil = RequireJsUtil.make((boolean)useLocalWbRc, (Context)cx);
            if (bindResources) {
                long lastBuildTime = Sys.getRegistry().getLastBuildTime().getMillis();
                String typeSpec = BWbOrdTargetResolver.TYPE.toString().replace(":", "%3A");
                out.println("<script type='text/javascript'>");
                requireJsUtil.requirejsNoHtml((Writer)out);
                out.println("</script>");
                out.w((Object)String.format("<link rel='stylesheet' type='text/css' href='/vfile/wb/app.css?typeSpec=%s&version=%d'/>", typeSpec, lastBuildTime));
                out.w((Object)String.format("<script type='text/javascript' src='/vfile/wb/app.js?typeSpec=%s&version=%d'></script>", typeSpec, lastBuildTime));
                out.println("<script type='text/javascript'>");
                out.println(requireJsUtil.defineSystemProperties());
                out.println("</script>");
            } else {
                requireJsUtil.requirejs((Writer)out);
                String moduleStr = RequireJsUtil.getModulePrefix((boolean)useLocalWbRc);
                out.w((Object)"<link rel='stylesheet' type='text/css' href='").w((Object)moduleStr).w((Object)"bajaux/rc/container/container.css' />").nl();
                out.w((Object)"<link rel='stylesheet' type='text/css' href='").w((Object)moduleStr).w((Object)"web/rc/theme/theme.css' />").nl();
            }
            BFormFactorEnum formFactor = BFormFactorEnum.max;
            boolean attachAfterInit = false;
            if (params != null) {
                if (params.has("formFactor")) {
                    formFactor = (BFormFactorEnum)BFormFactorEnum.DEFAULT.getRange().get(JSONUtil.getString((JSONObject)params, (String)"formFactor"));
                }
                if (!themeName.isEmpty()) {
                    NiagaraWebSession session;
                    BOrd ord = UxUtil.checkThemeOrd(themeName, cx);
                    if (!ord.isNull()) {
                        out.w((Object)"<link rel='stylesheet' type='text/css' href='").w((Object)ord.toString().replaceAll("module://", RequireJsUtil.getModulePrefix((boolean)useLocalWbRc))).w((Object)"' />").nl();
                    }
                    if ((session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true)) != null) {
                        session.setAttribute("themeName", (Object)themeName);
                    }
                }
                if (params.has(attachAfterInitKey)) {
                    attachAfterInit = params.getBoolean(attachAfterInitKey);
                }
            }
            out.w((Object)"<script type='text/javascript'>").nl();
            out.w((Object)"'use strict';").nl();
            out.w((Object)"window.wbLoaded = function () {").nl();
            out.w((Object)"if (window.wbLoadedInvoked) { return; }").nl();
            out.w((Object)"window.wbLoadedInvoked = true;").nl();
            NiagaraSuperSession superSession = SessionManager.getCurrentNiagaraSuperSession();
            new NiagaraEnv(NiagaraEnv.EnvType.WORKBENCH).withCustomProperty(useLocalWbRcKey, useLocalWbRc).withCustomProperty("modulePrefix", RequireJsUtil.getModulePrefix((boolean)useLocalWbRc)).withCustomProperty("csrfToken", superSession == null ? null : superSession.getCsrfToken()).toJavaScript((PrintWriter)out);
            this.writeContainerInitScript(out, info, formFactor, params, isJavaFx, attachAfterInit);
            out.w((Object)"};").nl();
            out.w((Object)"if (window.wbHasLoaded) { window.wbLoaded(); }").nl();
            out.w((Object)"</script>").nl();
            out.w((Object)"</head>").nl();
            out.w((Object)("<body class='niagara-env-wb" + (!themeName.isEmpty() ? " " + themeName : "") + "'>")).nl();
            out.w((Object)"<div id='bajaux-container' class='bajaux-container ux-root ux-fullscreen-support'>").nl();
            out.w((Object)"  <div id='bajaux-toolbar-outer' class='bajaux-toolbar-outer'>").nl();
            out.w((Object)"    <div id='bajaux-toolbar' class='bajaux-toolbar'></div>").nl();
            out.w((Object)"  </div>").nl();
            out.w((Object)"  <div id='bajaux-widget-outer' class='bajaux-widget-container'>").nl();
            out.w((Object)"    <div id='bajaux-widget' class='bajaux-widget'></div>").nl();
            out.w((Object)"  </div>").nl();
            out.w((Object)"  <div id='bajaux-error' class='bajaux-error'></div>").nl();
            out.w((Object)"</div>").nl();
            out.w((Object)"</body>").nl();
            out.w((Object)"</html>");
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private void writeContainerInitScript(HtmlWriter out, WebWidgetInitInfo info, BFormFactorEnum formFactor, JSONObject params, boolean isJavaFx, boolean attachAfterInit) {
        RequireJsUtil.withRequiredBuiltFiles((PrintWriter)out, () -> {
            out.w((Object)"require(['Promise', 'bajaux/container/wb/wbContainer', '").w((Object)info.getJsId()).w((Object)"'], ");
            out.w((Object)"function (Promise, container, Widget) {").nl();
            out.w((Object)"  if (Widget.__esModule) { Widget = Widget.default || Widget; }").nl();
            if (isJavaFx) {
                out.w((Object)"typeof Promise.setScheduler === 'function' && Promise.setScheduler(window.niagaraAsync);").nl();
            }
            out.w((Object)String.join((CharSequence)"\n", "(function () {", "  var FUNCTIONS_THAT_RETURN_PROMISES = [ 'hyperlink', 'toHyperlink', 'reload', 'updateTransformOptions' ];", "  function createNamespace(name, func) {", "    var res = name.split('_'),", "        i,", "        token,", "        obj = window;", "", "    for (i = 0; i < res.length; ++i) {", "      token = res[i];", "      if (i === res.length - 1) {", "        if (FUNCTIONS_THAT_RETURN_PROMISES.includes(token)) {", "          obj[token] = function () {", "            var that = this;", "            var args = Array.prototype.slice.call(arguments);", "            return Promise.resolve()", "              .then(function () { return func.apply(that, args); });", "          }", "        } else {", "          obj[token] = func;", "        }", "      } else {", "        obj[token] = obj[token] || {};", "      }", "      obj = obj[token];", "    }", "  }", "", "  var p;", "  for (p in window) {", "    if (window.hasOwnProperty(p) && ", "        /^niagara_.*/.test(p) && ", "        typeof window[p] === 'function') {", "      createNamespace(p, window[p]);", "    }", "  }", "}());")).nl();
            out.w((Object)("  container.initializeContainer({attachAfterInit:" + attachAfterInit + "});")).nl();
            CharSequence[] widgetConstructorParams = new String[]{"'" + info.getModuleName() + "'", "'" + info.getTypeName() + "'", "'" + formFactor.getTag() + "'"};
            out.w((Object)"  container.initialize(").w((Object)"new Widget(").w((Object)String.join((CharSequence)", ", widgetConstructorParams)).w((Object)"), ").w((Object)params).w((Object)");").nl();
            out.w((Object)"});").nl();
        }, (BIWebResource.DependencyGraph)info.resolveDependencies(new BIWebResource[]{BBajauxJsBuild.INSTANCE}));
    }

    private static void writeNiagaraAsyncFunction(HtmlWriter out, boolean isJavaFx) {
        if (isJavaFx) {
            out.w((Object)"<script type='text/javascript'>").nl().w((Object)"window.niagaraAsync = (function () {\n");
            if (forceUseAsyncTimeout) {
                out.w((Object)"return function (func) {\n  setTimeout(func, 0);\n};\n");
            } else {
                out.w((Object)"  var queue = [],\n      messageName = \"niagara-async-post-message\";\n\n  function handleMessage(event) {\n    if (event.source === window && event.data === messageName) {\n      event.stopPropagation();\n      if (queue.length > 0) {\n        queue.shift()();\n      }\n    }\n  }\n\n  window.addEventListener(\"message\", handleMessage, true);\n\n  return function (func) {\n    queue.push(func);\n    window.postMessage(messageName, \"*\");\n  };\n");
            }
            out.w((Object)"}());").nl().w((Object)"</script>").nl();
        }
    }

    public static WebWidgetInitInfo getWebWidgetInitInfo(BOrd jsOrd, Context cx) throws IOException {
        TypeInfo widgetTypeInfo;
        WebWidgetInitInfo info = null;
        if (jsOrd.isNull()) {
            return null;
        }
        OrdTarget target = jsOrd.resolve((BObject)BLocalHost.INSTANCE, cx);
        BObject obj = target.get();
        if (obj instanceof BIFile && ((BIFile)obj).getFileSpace() == BFileSystem.INSTANCE) {
            info = new WebWidgetInitInfo();
            BIFile file = (BIFile)obj;
            info.jsId = "/file/" + TextUtil.join((String[])file.getFilePath().getNames(), (char)'/') + "?lm=" + file.getLastModified().getMillis();
        } else if (target.getViewQuery() != null && (widgetTypeInfo = Sys.getRegistry().getType(target.getViewQuery().getViewId())).is(BIJavaScript.TYPE)) {
            info = WbWebWidgetServlet.getWebWidgetInitInfo((BIJavaScript)widgetTypeInfo.getInstance(), cx);
        }
        if (info != null) {
            info.params = WbWebWidgetServlet.getParameters(target);
        }
        return info;
    }

    public static WebWidgetInitInfo getWebWidgetInitInfo(BIJavaScript js, Context cx) {
        WebWidgetInitInfo info = new WebWidgetInitInfo();
        TypeInfo typeInfo = js.getType().getTypeInfo();
        info.displayName = typeInfo.getDisplayName(cx);
        info.moduleName = typeInfo.getModuleName();
        info.typeName = typeInfo.getTypeName();
        JsInfo jsInfo = js.getJsInfo(cx);
        info.buildId = jsInfo.getBuildId();
        info.jsId = jsInfo.getJsId();
        return info;
    }

    public static JSONObject getParameters(OrdTarget target) throws IOException {
        String[] names;
        ViewQuery query = target.getViewQuery();
        String[] paramNames = null;
        String[] values = null;
        if (query != null && (names = query.getParameterNames()) != null && names.length > 0) {
            paramNames = names;
            values = new String[paramNames.length];
            for (int i = 0; i < paramNames.length; ++i) {
                values[i] = query.getParameter(paramNames[i]);
            }
        }
        return paramNames == null ? null : WbWebWidgetServlet.paramsToJsonObject(paramNames, values);
    }

    private static JSONObject paramsToJsonObject(String[] paramNames, String[] values) {
        JSONObject obj = new JSONObject();
        for (int i = 0; i < paramNames.length; ++i) {
            obj.put(SlotPath.unescape((String)paramNames[i]), (Object)values[i]);
        }
        return obj;
    }

    public static final class WebWidgetInitInfo {
        private String displayName = "";
        private String moduleName = "";
        private String typeName = "";
        private String jsId = "";
        private String buildId;
        private JSONObject params;

        public String getDisplayName() {
            return this.displayName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getJsId() {
            return this.jsId;
        }

        public JSONObject getParameters() {
            return this.params;
        }

        public Optional<String> getBuildId() {
            return Optional.ofNullable(this.buildId);
        }

        public BIWebResource.DependencyGraph resolveDependencies(BIWebResource ... additionalDependencies) {
            Collection builds = this.getBuildId().flatMap(BJsBuild::forId).map(build -> {
                ArrayList<Object> resources = new ArrayList<Object>();
                resources.add(build);
                resources.addAll(Arrays.asList(additionalDependencies));
                return resources;
            }).orElseGet(() -> Arrays.asList(additionalDependencies));
            return BIWebResource.resolve((Collection)builds);
        }
    }
}

