/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ux;

import com.tridium.util.CustomThemeModuleManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

public final class UxUtil {
    private static Logger logger = Logger.getLogger("web.theme");
    private static final long minWarningTicks = 900000L;
    private static ConcurrentHashMap<String, Long> requestedMissingThemes = new ConcurrentHashMap();

    private UxUtil() {
    }

    public static BOrd checkThemeOrd(String themeName, Context cx) {
        BOrd ord;
        block7: {
            ord = BOrd.make((String)("module://theme" + themeName + "/ux/theme.css"));
            try {
                ord.resolve((BObject)BLocalHost.INSTANCE, cx);
            }
            catch (Throwable e) {
                BDynamicEnum themeEnum = CustomThemeModuleManager.getModuleEnumForTag((String)themeName);
                ord = themeEnum.equals((Object)BDynamicEnum.DEFAULT) ? BOrd.NULL : BOrd.make((String)("module://theme" + themeEnum.getTag() + "/ux/theme.css"));
                String username = "";
                try {
                    BUser user = cx.getUser();
                    username = user == null ? cx.getFacet("username").toString() : user.getUsername();
                }
                catch (Throwable user) {
                    // empty catch block
                }
                if (ord.equals((Object)BOrd.NULL)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.severe("There are no themes installed in the station and the UI may be unusable.");
                    }
                }
                String logMessage = String.format("The user selected theme %s was not available and was switched to a fallback. You can select a different theme by going to the user %s's profile configuration.", themeName, username);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(logMessage);
                }
                long now = Clock.ticks();
                if (requestedMissingThemes.containsKey(themeName) && now - requestedMissingThemes.get(themeName) < 900000L) break block7;
                requestedMissingThemes.put(themeName, now);
                logger.warning(logMessage);
            }
        }
        return ord;
    }
}

