/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ux;

import com.tridium.file.util.BInputStreamFileStore;
import com.tridium.file.util.SupplierInputStream;
import com.tridium.web.BIOrdTargetResolver;
import com.tridium.web.RequireJsUtil;
import com.tridium.web.js.NiagaraRequireJsMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BCssFile;
import javax.baja.file.types.text.BJavascriptFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.js.JsInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType
@NiagaraSingleton
public final class BWbOrdTargetResolver
extends BSingleton
implements BIOrdTargetResolver {
    @Generated
    public static final BWbOrdTargetResolver INSTANCE = new BWbOrdTargetResolver();
    @Generated
    public static final Type TYPE = Sys.loadType(BWbOrdTargetResolver.class);
    private static final BOrd profileCss = BOrd.make((String)"module://webEditors/rc/wb/profile/profile.css");
    private static final BOrd bajauxContainerCss = BOrd.make((String)"module://bajaux/rc/container/container.css");
    private static final BOrd baseThemeCss = BOrd.make((String)"module://web/rc/theme/theme.css");
    private static final Pattern cssModuleIdPattern = Pattern.compile("^module://(.+)\\.css$", 2);
    private static final Pattern uriPattern = Pattern.compile("^.*/(app.(js|css))$");
    private static final Map<String, Collection<Supplier<InputStream>>> MODULE_TO_ADD_JS;
    private static final Map<String, List<String>> MODULE_TO_CSS_ORDS;
    private static final String[] REQUIRED_JS_MODULES;
    private static final String[] REQUIRED_CSS_MODULES;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BWbOrdTargetResolver() {
    }

    public OrdTarget resolve(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return BWbOrdTargetResolver.resolve(request, BOrd.NULL, BOrd.NULL, BOrd.NULL, BOrd.NULL);
    }

    public static OrdTarget resolve(HttpServletRequest request, BOrd coreJs, BOrd coreCss, BOrd containerJs, BOrd containerCss) throws IOException {
        return BWbOrdTargetResolver.resolve(request, coreJs, coreCss, containerJs, containerCss, null);
    }

    public static OrdTarget resolve(HttpServletRequest request, BOrd coreJs, BOrd coreCss, BOrd containerJs, BOrd containerCss, Runnable runnable) throws IOException {
        request.setAttribute("snoop", (Object)"false");
        String pathInfo = Objects.toString(request.getPathInfo(), "");
        Matcher matcher = uriPattern.matcher(pathInfo);
        if (!matcher.matches()) {
            return null;
        }
        String fileName = matcher.group(1);
        BAbsTime lastRegBuildTime = Sys.getRegistry().getLastBuildTime();
        if (fileName.toLowerCase().endsWith(".css")) {
            return OrdTarget.unmounted((BObject)new BCssFile((BIFileStore)new BInputStreamFileStore(new FilePath(fileName), lastRegBuildTime, BPermissions.all, () -> {
                if (runnable != null) {
                    runnable.run();
                }
                return new SupplierInputStream(Arrays.asList(BWbOrdTargetResolver.add(coreCss), BWbOrdTargetResolver.add(bajauxContainerCss), BWbOrdTargetResolver.add(containerCss), BWbOrdTargetResolver.add(baseThemeCss), BWbOrdTargetResolver.add(profileCss), () -> new SupplierInputStream((Collection)BWbOrdTargetResolver.getAllRequiredCss().map(BWbOrdTargetResolver::add).collect(Collectors.toList()))));
            })));
        }
        return OrdTarget.unmounted((BObject)new BJavascriptFile((BIFileStore)new BInputStreamFileStore(new FilePath(fileName), lastRegBuildTime, BPermissions.all, () -> {
            if (runnable != null) {
                runnable.run();
            }
            Stream<Supplier> cssStubs = Stream.concat(Stream.of(coreCss, bajauxContainerCss, containerCss, baseThemeCss, profileCss), BWbOrdTargetResolver.getAllRequiredCss()).map(BWbOrdTargetResolver::stubCss).map(BWbOrdTargetResolver::add);
            Stream allJsAndCss = Stream.of(BWbOrdTargetResolver.getAllRequiredJs(), Stream.of(BWbOrdTargetResolver.add(coreJs), BWbOrdTargetResolver.addDefine(containerJs, containerJs.isNull() ? "" : JsInfo.toRequireJsId((BOrd)containerJs))), cssStubs).reduce(Stream::concat).orElseGet(Stream::empty);
            return new SupplierInputStream((Collection)allJsAndCss.collect(Collectors.toList()));
        })));
    }

    private static Supplier<InputStream> wrapDefine(BOrd ord, String id) {
        return () -> new SupplierInputStream(Arrays.asList(() -> SupplierInputStream.toInputStream((String)("(function(){\nvar define=function(){var args=Array.prototype.slice.call(arguments);if(args.length === 1){return window.define.apply(this,['" + id + "'].concat(args));} else {return typeof args[0] === 'string' ? window.define.apply(this, args) : window.define.apply(this,['" + id + "'].concat(args));" + '}' + "};define.amd=true;")), () -> SupplierInputStream.toInputStream((BOrd)ord), () -> SupplierInputStream.toInputStream((String)"}());")));
    }

    private static Supplier<InputStream> add(BOrd ord) {
        return () -> SupplierInputStream.toInputStream((BOrd)ord);
    }

    private static Supplier<InputStream> addDefine(BOrd ord, String id) {
        if (ord.isNull()) {
            return SupplierInputStream::toEmptyStream;
        }
        return () -> new SupplierInputStream(Arrays.asList(() -> SupplierInputStream.toInputStream((BOrd)ord), () -> SupplierInputStream.toInputStream((String)("define('" + id + "',[],undefined);"))));
    }

    private static Supplier<InputStream> add(String str) {
        return () -> SupplierInputStream.toInputStream((String)str);
    }

    private static String stubCss(BOrd cssOrd) {
        if (cssOrd.isNull()) {
            return "";
        }
        Matcher cssMatcher = cssModuleIdPattern.matcher(cssOrd.toString());
        if (cssMatcher.find()) {
            String cssPath = cssMatcher.group(1);
            String cssId = NiagaraRequireJsMapper.getInstance().pathToRequireJsModuleId(cssPath);
            return "define('css!" + cssId + "',[],undefined);";
        }
        throw new BajaRuntimeException("Illegal module ORD: " + cssOrd);
    }

    private static Stream<Supplier<InputStream>> getAllRequiredJs() {
        return Arrays.stream(REQUIRED_JS_MODULES).map(moduleName -> MODULE_TO_ADD_JS.get(moduleName)).filter(Objects::nonNull).flatMap(Collection::stream);
    }

    private static Stream<BOrd> getAllRequiredCss() {
        return Arrays.stream(REQUIRED_CSS_MODULES).map(moduleName -> MODULE_TO_CSS_ORDS.get(moduleName)).filter(Objects::nonNull).flatMap(Collection::stream).map(BOrd::make).filter(o -> !o.isNull());
    }

    private static String[] split(String str) {
        return str.trim().split(",\\s*");
    }

    static {
        HashMap<String, List<Supplier<Object>>> moduleToJs = new HashMap<String, List<Supplier<Object>>>();
        moduleToJs.put("js", Arrays.asList(BWbOrdTargetResolver.add(BOrd.make((String)"module://js/rc/d3/d3.min.js")), BWbOrdTargetResolver.add(BOrd.make((String)"module://js/com/tridium/js/ext/require/require.min.js")), BWbOrdTargetResolver.add("define('d3', [], d3);"), BWbOrdTargetResolver.add(BOrd.make((String)"module://js/rc/jquery/jquery.min.js")), BWbOrdTargetResolver.add("jQuery.noConflict();"), RequireJsUtil.USE_NATIVE_PROMISES ? BWbOrdTargetResolver.add("") : BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/rc/bluebird/bluebird.min.js"), "Promise"), BWbOrdTargetResolver.add(BOrd.make((String)"module://js/rc/js.built.min.js")), BWbOrdTargetResolver.add("define('nmodule/js/rc/js.built.min', [], function () {});"), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/com/tridium/js/ext/require/css.js"), "css"), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/rc/jquery/Relevant-Dropdowns/js/jquery.relevant-dropdown.js"), "nmodule/js/rc/jquery/Relevant-Dropdowns/js/jquery.relevant-dropdown"), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/rc/jquery/contextMenu/jquery.contextMenu.min.js"), "nmodule/js/rc/jquery/contextMenu/jquery.contextMenu"), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/rc/jquery/contextMenu/jquery.ui.position.min.js"), "nmodule/js/rc/jquery/contextMenu/jquery.ui.position"), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/rc/handlebars/handlebars.min.js"), "Handlebars"), BWbOrdTargetResolver.add(BOrd.make((String)"module://js/rc/require-handlebars-plugin/hbs.built.min.js")), BWbOrdTargetResolver.add(BOrd.make((String)"module://js/rc/jquery/split-pane/split-pane.js")), BWbOrdTargetResolver.add("define('nmodule/js/rc/jquery/split-pane/split-pane', [], undefined);"), BWbOrdTargetResolver.add(BOrd.make((String)"module://js/rc/underscore/underscore.min.js")), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/rc/moment/moment.min.js"), "moment"), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://js/rc/pikaday/pikaday.js"), "nmodule/js/rc/pikaday/pikaday")));
        moduleToJs.put("alarm", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://alarm/rc/alarm.built.min.js"), "nmodule/alarm/rc/alarm.built.min")));
        moduleToJs.put("bajaScript", Arrays.asList(BWbOrdTargetResolver.add(BOrd.make((String)"module://bajaScript/rc/bs.built.min.js")), BWbOrdTargetResolver.add("define('bajaScript/bs.built.min', [], undefined);"), BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://bajaScript/rc/plugin/baja.js"), "baja")));
        moduleToJs.put("bajaui", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://bajaui/rc/bajaui.built.min.js"), "nmodule/bajaui/rc/bajaui.built.min")));
        moduleToJs.put("bajaux", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://bajaux/rc/bajaux.built.min.js"), "bajaux/bajaux.built.min")));
        moduleToJs.put("bql", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://bql/rc/bql.built.min.js"), "nmodule/bql/rc/bql.built.min")));
        moduleToJs.put("control", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://control/rc/control.built.min.js"), "nmodule/control/rc/control.built.min")));
        moduleToJs.put("converters", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://converters/rc/converters.built.min.js"), "nmodule/converters/rc/converters.built.min")));
        moduleToJs.put("export", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://export/rc/export.built.min.js"), "nmodule/export/rc/export.built.min")));
        moduleToJs.put("gx", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://gx/rc/gx.built.min.js"), "nmodule/gx/rc/gx.built.min")));
        moduleToJs.put("hierarchy", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://hierarchy/rc/hierarchy.built.min.js"), "nmodule/hierarchy/rc/hierarchy.built.min")));
        moduleToJs.put("history", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://history/rc/history.built.min.js"), "nmodule/history/rc/history.built.min")));
        moduleToJs.put("kitControl", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://kitControl/rc/kitControl.built.min.js"), "nmodule/kitControl/rc/kitControl.built.min")));
        moduleToJs.put("kitPx", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://kitPx/rc/kitPx.built.min.js"), "nmodule/kitPx/rc/kitPx.built.min")));
        moduleToJs.put("search", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://search/rc/search.built.min.js"), "nmodule/search/rc/search.built.min")));
        moduleToJs.put("web", Collections.singletonList(BWbOrdTargetResolver.wrapDefine(BOrd.make((String)"module://web/rc/util/activityMonitor.js"), "nmodule/web/rc/util/activityMonitor")));
        moduleToJs.put("webChart", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://webChart/rc/webChart.built.min.js"), "nmodule/webChart/rc/webChart.built.min")));
        moduleToJs.put("webEditors", Collections.singletonList(BWbOrdTargetResolver.addDefine(BOrd.make((String)"module://webEditors/rc/webEditors.built.min.js"), "nmodule/webEditors/rc/webEditors.built.min")));
        LinkedHashMap<String, Collection<Supplier<InputStream>>> orderedMap = new LinkedHashMap<String, Collection<Supplier<InputStream>>>();
        List<String> expectedOrder = Arrays.asList("js", "web", "bajaScript", "bajaux", "export", "converters", "webEditors", "gx", "bajaui", "bql", "history", "webChart", "hierarchy", "search", "control", "alarm", "kitControl", "kitPx");
        for (String moduleName : expectedOrder) {
            orderedMap.put(moduleName, (Collection<Supplier<InputStream>>)moduleToJs.get(moduleName));
        }
        if (!orderedMap.keySet().equals(moduleToJs.keySet())) {
            throw new IllegalArgumentException("When adding modules to app.js, ensure that ordering is respected");
        }
        MODULE_TO_ADD_JS = orderedMap;
        HashMap<String, List<String>> moduleToCss = new HashMap<String, List<String>>();
        moduleToCss.put("alarm", Arrays.asList("module://alarm/com/tridium/alarm/hx/alarm.css", "module://alarm/rc/console/templates/alarmConsole.css", "module://alarm/rc/db/templates/view.css", "module://alarm/rc/fe/alarmEditors.css"));
        moduleToCss.put("bajaui", Collections.singletonList("module://bajaui/rc/bajaui.css"));
        moduleToCss.put("bql", Collections.singletonList("module://bql/rc/bql.css"));
        moduleToCss.put("gx", Collections.singletonList("module://gx/rc/gx.css"));
        moduleToCss.put("hierarchy", Collections.singletonList("module://hierarchy/rc/hierarchy.css"));
        moduleToCss.put("history", Collections.singletonList("module://history/rc/history.css"));
        moduleToCss.put("icons", Collections.singletonList("module://icons/sprite/sprite.css"));
        moduleToCss.put("js", Arrays.asList("module://js/rc/dialogs/dialogs.css", "module://js/rc/jquery/split-pane/split-pane.css", "module://js/rc/pikaday/pikaday.css", "module://js/rc/jquery/contextMenu/jquery.contextMenu.css", "module://js/rc/jquery/Relevant-Dropdowns/css/style.css"));
        moduleToCss.put("kitPx", Collections.singletonList("module://kitPx/rc/kitPx.css"));
        moduleToCss.put("search", Collections.singletonList("module://search/rc/search.css"));
        moduleToCss.put("webChart", Arrays.asList("module://webChart/rc/gauge/CircularGaugeWidgetStyle.css", "module://webChart/rc/fe/color/colorChooserStyle.css", "module://webChart/rc/line/LineStyle.css", "module://webChart/rc/ChartWidgetStyle.css"));
        moduleToCss.put("webEditors", Arrays.asList("module://webEditors/rc/wb/mixin/PropertySheetRowDragSupport.css", "module://webEditors/rc/fe/webEditors-structure.css", "module://webEditors/rc/wb/composite/style/CompositeEditor.css", "module://webEditors/rc/wb/tree/NavTreeStyle.css", "module://webEditors/rc/wb/mixin/PropertySheetRowLinkSupport.css", "module://webEditors/rc/wb/mixin/PropertySheetDragSupport.css"));
        moduleToCss.put("wiresheet", Collections.singletonList("module://wiresheet/rc/wiresheet.css"));
        orderedMap = new LinkedHashMap();
        expectedOrder = Arrays.asList("icons", "js", "webEditors", "gx", "history", "webChart", "hierarchy", "search", "alarm", "wiresheet", "bajaui", "kitPx", "bql");
        for (String moduleName : expectedOrder) {
            orderedMap.put(moduleName, (Collection<Supplier<InputStream>>)moduleToCss.get(moduleName));
        }
        if (!orderedMap.keySet().equals(moduleToCss.keySet())) {
            throw new IllegalArgumentException("When adding modules to app.css, ensure that ordering is respected");
        }
        MODULE_TO_CSS_ORDS = orderedMap;
        String jsProp = AccessController.doPrivileged(() -> System.getProperty("niagara.web.bundle.includeJsModules"));
        String cssProp = AccessController.doPrivileged(() -> System.getProperty("niagara.web.bundle.includeCssModules"));
        REQUIRED_JS_MODULES = jsProp == null ? MODULE_TO_ADD_JS.keySet().toArray(new String[0]) : BWbOrdTargetResolver.split(jsProp);
        REQUIRED_CSS_MODULES = cssProp == null ? MODULE_TO_CSS_ORDS.keySet().toArray(new String[0]) : BWbOrdTargetResolver.split(cssProp);
    }
}

