/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.transport;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.IRequesterComponent;
import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.BSigningRequestState;
import com.tridium.signing.BSigningService;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BAbstractSigningProfile;
import com.tridium.signing.transport.BISigningTransport;
import com.tridium.signing.transport.BSigningTransportFolder;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperty(name="enabled", type="boolean", defaultValue="true")
public final class BLocalSigningTransport
extends BComponent
implements BISigningTransport,
BIRestrictedComponent {
    @Generated
    public static final Property enabled = BLocalSigningTransport.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalSigningTransport.class);
    private static final BCertificateParameter[] EMPTY_PARAM_ARRAY = new BCertificateParameter[0];
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"keys.png"), (BIcon)BIcon.std((String)"badges/lock.png"));

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!(parent instanceof BSigningTransportFolder)) {
            throw new IllegalChildException("baja", "IllegalChildException.parentAndChild", new Object[]{this.getType(), parent.getType()});
        }
        BIRestrictedComponent.checkForDuplicatesInParent((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public BIcon getIcon() {
        return icon;
    }

    void onboard(String requesterId, IRequesterComponent requesterComponent, String profileName, Context cx) throws SigningServiceException {
        this.enabledCheck();
        if (BLocalSigningTransport.permCheck(requesterComponent, cx)) {
            BSigningService signingService = this.getSigningService();
            String profileId = signingService.findProfileIdByName(profileName);
            BLocalSigningTransport.profilePermCheck(signingService, profileId, cx);
            try {
                AccessController.doPrivileged(() -> {
                    SigningServiceUtils.checkRequestPermitted();
                    SigningServiceUtils.checkRequesterId(requesterId);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw (SigningServiceException)((Object)e.getException());
            }
        } else {
            throw new SigningServiceException("signingService", "requester.local.insufficient.perms", BLocalSigningTransport.componentToDisplayPathString(requesterComponent, cx));
        }
    }

    BCertificateParameter[] getCertificateParameterTemplates(String requesterId, String onboardingProfile) throws SigningServiceException {
        this.enabledCheck();
        BSigningService signingService = this.getSigningService();
        String profileId = onboardingProfile != null && !onboardingProfile.trim().isEmpty() ? signingService.findProfileIdByName(onboardingProfile) : this.getProfileId(requesterId);
        try {
            Map params = AccessController.doPrivileged(() -> signingService.getCsrParameters(profileId, null));
            return params.values().toArray(EMPTY_PARAM_ARRAY);
        }
        catch (PrivilegedActionException e) {
            throw (SigningServiceException)((Object)e.getException());
        }
    }

    void submitCertificateSigningRequest(String requesterId, String onboardingProfile, IRequesterComponent requesterComponent, NPKCS10CertificationRequest csr, boolean renewal, Context cx) throws SigningServiceException {
        this.enabledCheck();
        if (BLocalSigningTransport.permCheck(requesterComponent, cx)) {
            BSigningService signingService = this.getSigningService();
            String profileId = onboardingProfile != null && !onboardingProfile.trim().isEmpty() ? signingService.findProfileIdByName(onboardingProfile) : this.getProfileId(requesterId);
            BLocalSigningTransport.profilePermCheck(signingService, profileId, cx);
            String metadata = BLocalSigningTransport.makeMetadata(requesterComponent, cx);
            try {
                AccessController.doPrivileged(() -> {
                    signingService.registerRequester(profileId, requesterId, metadata, renewal);
                    signingService.processCsr(csr.encodeToString(), profileId, requesterId, metadata, renewal);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw (SigningServiceException)((Object)e.getException());
            }
        } else {
            throw new SigningServiceException("signingService", "requester.local.insufficient.perms", BLocalSigningTransport.componentToDisplayPathString(requesterComponent, cx));
        }
    }

    X509Certificate[] getCertificateSigningResult(String requesterId) throws SigningServiceException {
        this.enabledCheck();
        BSigningService signingService = this.getSigningService();
        Optional<BCertificateSigningRecord> record = signingService.getRecord(requesterId);
        if (record.isPresent()) {
            BCertificateSigningRecord signingRecord = record.get();
            if (BSigningRequestState.rejected.equals((Object)signingRecord.getRequestState())) {
                throw new SigningServiceException("signingService", "channel.exception.signingRequestRejected", requesterId);
            }
            if (!BSigningRequestState.complete.equals((Object)signingRecord.getRequestState())) {
                return null;
            }
            X509Certificate cert = signingRecord.getCertificate().getX509Certificate();
            String profileId = this.getProfileId(requesterId);
            BAbstractSigningProfile profile = signingService.findProfile(profileId);
            Object[] caChain = profile.getCaCertificateChain(requesterId);
            Object[] combined = (X509Certificate[])ArrayUtil.addOne((Object[])caChain, (Object)cert);
            return (X509Certificate[])ArrayUtil.toTop((Object[])combined, (int)(combined.length - 1));
        }
        return null;
    }

    private void enabledCheck() throws SigningServiceException {
        if (!this.getEnabled()) {
            throw new SigningServiceException("signingService", "requester.local.disabled");
        }
    }

    private BSigningService getSigningService() {
        return (BSigningService)((BSigningTransportFolder)this.getParent().as(BSigningTransportFolder.class)).getParent().as(BSigningService.class);
    }

    private String getProfileId(String requesterId) throws SigningServiceException {
        return this.getSigningService().findProfileId(requesterId).orElseThrow(() -> new SigningServiceException("signingService", "signing.service.requester.notFound", requesterId));
    }

    private static boolean permCheck(IRequesterComponent requesterComponent, Context cx) {
        return requesterComponent instanceof BComponent && ((BComponent)requesterComponent).getPermissions(cx).hasAdminWrite();
    }

    private static void profilePermCheck(BSigningService signingService, String profileId, Context cx) throws SigningServiceException {
        BAbstractSigningProfile profile = signingService.findProfile(profileId);
        BLocalSigningTransport.profilePermCheck(profile, cx);
    }

    private static void profilePermCheck(BAbstractSigningProfile profile, Context cx) throws SigningServiceException {
        if (!profile.getPermissions(cx).hasAdminWrite()) {
            throw new SigningServiceException("signingService", "requester.local.insufficient.perms", BLocalSigningTransport.componentToDisplayPathString((Object)profile, cx));
        }
    }

    private static String makeMetadata(IRequesterComponent requesterComponent, Context cx) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("comment", SigningServiceUtils.LEX.getText("requester.local.comment", new Object[]{BLocalSigningTransport.componentToDisplayPathString(requesterComponent, cx)}));
        metadata.put("requestingStation", Sys.getStation().getStationName());
        if (cx != null && cx.getUser() != null) {
            metadata.put("username", cx.getUser().getUsername());
        }
        return SigningServiceUtils.convertMetadataToString(metadata);
    }

    private static String componentToDisplayPathString(Object component, Context cx) {
        if (component instanceof BComponent) {
            return ((BComponent)component).toDisplayPathString(cx);
        }
        return component.toString();
    }
}

