/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.sec;

import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BSigningRecordStore;
import com.tridium.signing.profile.BSimpleSigningProfile;
import com.tridium.signing.profile.ExpiringRecordsReport;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"signingService:SimpleSigningProfile"})})
public final class BSigningProfileSecurityDashboardAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSigningProfileSecurityDashboardAgent.class);
    private BSimpleSigningProfile profile;
    private SecurityDashboardItemBuilder builder;
    public static final String SECTION_HEADER = "securityDashboard.signing.profile.sectionHeader";
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    public static final String CA_EXP_SUMMARY = "securityDashboard.ca.expired";
    public static final String CA_EXP_DESCRIPTION = "securityDashboard.ca.desc";
    public static final String CA_EXP_SOON_SUMMARY = "securityDashboard.ca.expiring";
    public static final String CA_EXP_SOON_DESCRIPTION = "securityDashboard.ca.expiring.desc";
    public static final String CA_OK_SUMMARY = "securityDashboard.ca.ok";
    public static final String CA_OK_DESCRIPTION = "securityDashboard.ca.ok.desc";
    public static final String CA_MISSING_SUMMARY = "securityDashboard.ca.missing";
    public static final String CA_MISSING_DESCRIPTION = "securityDashboard.ca.missing.desc";
    public static final String NOT_EXP_SUMMARY = "securityDashboard.not.expiring.summary";
    public static final String NOT_EXP_DESCRIPTION = "securityDashboard.not.expiring.desc";
    public static final String PENDING_EXP_SUMMARY = "securityDashboard.pending.expiring.summary";
    public static final String PENDING_EXP_DESCRIPTION = "securityDashboard.pending.expiring.desc";
    public static final String PENDING_EXP_DETAILS = "signing.store.pendingExpCertSummary";
    public static final String GRACE_SUMMARY = "securityDashboard.grace.summary";
    public static final String GRACE_DESCRIPTION = "securityDashboard.grace.desc";
    public static final String GRACE_DETAILS = "signing.store.gracePeriodCertSummary";
    public static final String EXPIRED_SUMMARY = "securityDashboard.expired.summary";
    public static final String EXPIRED_DESCRIPTION = "securityDashboard.expired.desc";
    public static final String EXPIRED_DETAILS = "signing.store.expiredCertRemovedSummary";
    public static final String NONE_SUMMARY = "securityDashboard.no.certs.summary";
    public static final String NONE_DESCRIPTION = "securityDashboard.no.certs.desc";
    private static final String CA_WARNING_THRESHOLD_PROP = "signing.securityDashboard.ca.threshold.days";
    public static final int CA_WARNING_THRESHOLD_DAYS = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty(CA_WARNING_THRESHOLD_PROP, "30")));

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.profile = (BSimpleSigningProfile)object.as(BSimpleSigningProfile.class);
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        String profileName = this.profile != null ? this.profile.getDisplayName(cx) : SigningServiceUtils.UNKNOWN;
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER, (String)profileName);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.profile.getCertificateStore().getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.profile != null) {
            this.checkCA(items);
            BSigningRecordStore store = this.profile.getCertificateStore();
            BRelTime alertProximityTime = store.getProximityToCertificateExpirationForAlerts();
            ExpiringRecordsReport report = new ExpiringRecordsReport(store);
            this.addItem(items, BSecurityItemStatus.securityStatusOK, false, report.getCertsNotExpiringSoon(), NOT_EXP_SUMMARY, NOT_EXP_DESCRIPTION, alertProximityTime, null);
            this.addItem(items, BSecurityItemStatus.securityStatusWarning, false, report.getCertsPendingExpiration(), PENDING_EXP_SUMMARY, PENDING_EXP_DESCRIPTION, alertProximityTime, PENDING_EXP_DETAILS);
            this.addItem(items, BSecurityItemStatus.securityStatusAlert, false, report.getExpiredCertsInGracePeriod(), GRACE_SUMMARY, GRACE_DESCRIPTION, store.getExpiredCertificateGracePeriod(), GRACE_DETAILS);
            List<BCertificateSigningRecord> recentlyRemovedCerts = store.recentlyRemovedCerts();
            this.addItem(items, BSecurityItemStatus.securityStatusAlert, true, recentlyRemovedCerts, EXPIRED_SUMMARY, EXPIRED_DESCRIPTION, null, EXPIRED_DETAILS);
            if (report.noRecords() && recentlyRemovedCerts.isEmpty()) {
                items.add(this.builder.makeInfo(NONE_SUMMARY, NONE_DESCRIPTION));
            }
        }
        return Collections.unmodifiableList(items);
    }

    private void addItem(List<SecurityDashboardItem> items, BSecurityItemStatus status, boolean pastTense, Collection<BCertificateSigningRecord> records, String summaryKey, String descriptionKey, Object descriptionParam, String detailsKey) {
        if (!records.isEmpty()) {
            String certificateWordingLex = BSigningProfileSecurityDashboardAgent.getCertificateWordingLex(records.size() > 1, pastTense);
            StringJoiner recordDetails = new StringJoiner("\r\n");
            int count = 1;
            for (BCertificateSigningRecord record : records) {
                if (record == null || detailsKey == null) continue;
                recordDetails.add(SigningServiceUtils.makeExpiringCertSummary(detailsKey, count++, record));
            }
            SecurityDashboardItemBuilder.ItemBuild item = this.builder.make(status).withSummary(summaryKey, new Object[]{records.size(), SigningServiceUtils.LEX.getText(certificateWordingLex)});
            ArrayList<Object> descriptionArgs = new ArrayList<Object>();
            if (descriptionParam != null) {
                descriptionArgs.add(descriptionParam);
            }
            if (detailsKey != null) {
                descriptionArgs.add(recordDetails.toString());
            }
            items.add(item.withDescription(descriptionKey, descriptionArgs.toArray()));
        }
    }

    private void checkCA(List<SecurityDashboardItem> items) {
        String alias = this.profile.getCaAliasAndPassword().getAlias();
        if (!alias.isEmpty() && !alias.equals("default")) {
            try {
                ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                X509Certificate cert = cryptoManager.getKeyStore().getCertificate(alias);
                if (cert == null) {
                    items.add(this.builder.makeAlert().withSummary(CA_MISSING_SUMMARY, new Object[0]).withDescription(CA_MISSING_DESCRIPTION, new Object[]{alias}));
                } else {
                    this.checkCA(items, cert, alias);
                }
            }
            catch (Exception e) {
                SigningServiceUtils.LOG.log(Level.WARNING, "Security Dashboard failed to check CA cert for profile " + this.profile.getName(), e);
            }
        }
    }

    private void checkCA(List<SecurityDashboardItem> items, X509Certificate cert, String alias) {
        long millisRemaining = cert.getNotAfter().getTime() - BAbsTime.now().getMillis();
        int daysRemaining = BRelTime.make((long)millisRemaining).getDays();
        if (millisRemaining < 0L) {
            items.add(this.builder.makeAlert().withSummary(CA_EXP_SUMMARY, new Object[0]).withDescription(CA_EXP_DESCRIPTION, new Object[]{alias}));
        } else if (daysRemaining < CA_WARNING_THRESHOLD_DAYS) {
            items.add(this.builder.makeWarning().withSummary(CA_EXP_SOON_SUMMARY, new Object[]{alias, daysRemaining}).withDescription(CA_EXP_SOON_DESCRIPTION, new Object[]{alias}));
        } else {
            items.add(this.builder.makeOk(CA_OK_SUMMARY, CA_OK_DESCRIPTION));
        }
    }

    private static String getCertificateWordingLex(boolean multipleRecords, boolean pastTense) {
        StringBuilder certificateWordingLex = new StringBuilder("securityDashboard.certificate");
        if (multipleRecords) {
            certificateWordingLex.append('s');
        }
        return certificateWordingLex.append(pastTense ? ".past" : ".present").toString();
    }
}

