/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.profile;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.BSigningCertificateState;
import com.tridium.signing.BSigningRequestState;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BProfilesFolder;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="profileId", type="String", defaultValue="BString.DEFAULT", flags=69)
public abstract class BAbstractSigningProfile
extends BComponent {
    @Generated
    public static final Property profileId = BAbstractSigningProfile.newProperty((int)69, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractSigningProfile.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"keys.png"), (BIcon)BIcon.std((String)"badges/lock.png"));

    @Generated
    public String getProfileId() {
        return this.getString(profileId);
    }

    @Generated
    public void setProfileId(String v) {
        this.setString(profileId, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BProfilesFolder.TYPE);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11 && this.getProfileId().isEmpty()) {
            this.generateUniqueProfileId();
        }
        return super.fw(x, a, b, c, d);
    }

    public final void registerRequester(String requesterId, String metadata, boolean renewal) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        BCertificateSigningRecord record = this.doRegisterRequester(requesterId, renewal);
        record.transitionState(BSigningRequestState.pending);
        record.setMessage("");
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        this.updateRecord(record);
    }

    protected abstract BCertificateSigningRecord doRegisterRequester(String var1, boolean var2) throws SigningServiceException;

    public final void rejectRequester(String requesterId, String reason) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        BCertificateSigningRecord record = this.getRecord(requesterId).orElseThrow(() -> new SigningServiceException("signingService", "signing.service.retrieve.failed", requesterId));
        record.transitionState(BSigningRequestState.rejected);
        record.setMessage(reason);
        this.updateRecord(record);
    }

    public final void validateCsr(NPKCS10CertificationRequest csr) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        this.doValidateCsr(csr);
    }

    protected abstract void doValidateCsr(NPKCS10CertificationRequest var1) throws SigningServiceException;

    public final void signCertificate(NPKCS10CertificationRequest csr, String requesterId) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        BCertificateSigningRecord record = this.getRecord(requesterId).orElseThrow(() -> new SigningServiceException("signingService", "signing.service.retrieve.failed", requesterId));
        try {
            X509Certificate signedCert = this.doSignCertificate(csr, requesterId);
            record.setCertificate(BX509Certificate.make((X509Certificate)signedCert));
            record.setCaFingerprint(this.getCaFingerprint());
            record.transitionState(BSigningCertificateState.active);
            record.transitionState(BSigningRequestState.complete);
            record.setMessage("");
            this.updateRecord(record);
        }
        catch (SigningServiceException e) {
            this.rejectRequester(requesterId, e.getMessage());
        }
    }

    protected abstract X509Certificate doSignCertificate(NPKCS10CertificationRequest var1, String var2) throws SigningServiceException;

    public final Map<String, BValue> getCsrParameters(Context cx) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        return this.doGetCsrParameters(cx);
    }

    protected abstract Map<String, BValue> doGetCsrParameters(Context var1) throws SigningServiceException;

    public final Optional<BCertificateSigningRecord> getRecord(String requesterId) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        return this.doGetRecord(requesterId);
    }

    protected abstract Optional<BCertificateSigningRecord> doGetRecord(String var1) throws SigningServiceException;

    public final Iterator<BCertificateSigningRecord> getAllRecords() throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        return this.doGetAllRecords();
    }

    protected abstract Iterator<BCertificateSigningRecord> doGetAllRecords() throws SigningServiceException;

    protected abstract void updateRecord(BCertificateSigningRecord var1) throws SigningServiceException;

    public abstract X509Certificate[] getCaCertificateChain(String var1) throws SigningServiceException;

    public abstract String getCaFingerprint() throws SigningServiceException;

    private void generateUniqueProfileId() {
        String profileId;
        while (this.exists(profileId = BAbstractSigningProfile.generateProfileId())) {
        }
        this.setProfileId(profileId);
    }

    private static String generateProfileId() {
        return UUID.randomUUID().toString();
    }

    private boolean exists(String profileId) {
        BProfilesFolder folder = (BProfilesFolder)this.getParent().as(BProfilesFolder.class);
        return Arrays.stream(folder.getChildren(BAbstractSigningProfile.class)).anyMatch(profile -> profile.getProfileId().equals(profileId));
    }

    public BIcon getIcon() {
        return icon;
    }
}

