/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.ext.NBasicConstraints;
import com.tridium.crypto.core.cert.ext.NExtendedKeyUsage;
import com.tridium.crypto.core.cert.ext.NKeyUsage;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.platcrypto.signing.BCertificateDnFieldParameter;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.BCommonNameTemplate;
import com.tridium.platcrypto.signing.CertificateParameterType;
import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.BSigningService;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.fox.BFoxSigningTransport;
import com.tridium.signing.profile.BKeyPurpose;
import com.tridium.signing.transport.BSessionToken;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.nre.security.IX509Extension;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public final class SigningServiceUtils {
    public static final Lexicon LEX = Lexicon.make(BSigningService.class);
    public static final String SIGNING_MODULE = "signingService";
    public static final Logger LOG = Logger.getLogger("signingService");
    public static final String UNKNOWN = Lexicon.make((String)"baja").get("unknown", "unknown");
    private static final String UNKNOWN_STATION = "signing.record.station.unknown";
    public static final String DEFAULT_REQUESTER_CERT_ALIAS = LEX.getText("signedCertConfig.defaultAliasInstructions");
    private static final String METADATA_KEY_VALUE_DELIMITER = ": ";
    private static final String METADATA_ENTRY_DELIMITER = "\n";
    public static final String METADATA_COMMENT_KEY = "comment";
    public static final String METADATA_USERNAME_KEY = "username";
    public static final String METADATA_STATION_KEY = "requestingStation";
    private static final Comparator<Map.Entry<String, String>> USER_COMMENT_TO_BOTTOM = (e1, e2) -> {
        String e2Key;
        String e1Key = (String)e1.getKey();
        int result = e1Key.compareTo(e2Key = (String)e2.getKey());
        if (result != 0) {
            if (e1Key.equals(METADATA_COMMENT_KEY)) {
                return 1;
            }
            if (e2Key.equals(METADATA_COMMENT_KEY)) {
                return -1;
            }
        }
        return result;
    };

    private SigningServiceUtils() {
    }

    public static void checkRequestPermitted() throws SigningServiceException {
        BSigningService service = (BSigningService)Sys.getService((Type)BSigningService.TYPE).as(BSigningService.class);
        if (!service.isOperational()) {
            throw new SigningServiceException(SIGNING_MODULE, "signing.service.inoperational");
        }
        SigningServiceUtils.checkSecurity();
    }

    public static void checkSecurity() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new NiagaraBasicPermission("SIGNING_SERVICE"));
        }
    }

    public static void checkRequesterId(String requesterId) throws SigningServiceException {
        if (requesterId == null || requesterId.isEmpty()) {
            throw new SigningServiceException(SIGNING_MODULE, "signing.service.requesterId.missing");
        }
    }

    public static String getProfileIdFromTokenStore(String requesterId, BSigningService signingService) throws SigningServiceException, PrivilegedActionException {
        BSessionToken sessionToken = AccessController.doPrivileged(() -> SigningServiceUtils.getFoxSigningTransport().getSessionTokenStore().getSessionToken(requesterId));
        if (sessionToken == null) {
            throw new SigningServiceException(SIGNING_MODULE, "signing.service.requester.notFound", requesterId);
        }
        String profileName = sessionToken.getProfile();
        return signingService.findProfileIdByName(profileName);
    }

    public static BFoxSigningTransport getFoxSigningTransport() throws SigningServiceException {
        BSigningService signingService = (BSigningService)Sys.getService((Type)BSigningService.TYPE).as(BSigningService.class);
        BFoxSigningTransport[] foxTransports = (BFoxSigningTransport[])signingService.getTransports().getChildren(BFoxSigningTransport.class);
        if (foxTransports.length > 0) {
            return foxTransports[0];
        }
        throw new SigningServiceException(SIGNING_MODULE, "signing.service.transport.notfound", BFoxSigningTransport.TYPE);
    }

    public static NPKCS10CertificationRequest decodeCsr(String csrPem) throws SigningServiceException {
        try {
            return NPKCS10CertificationRequest.make((String)csrPem);
        }
        catch (Exception e) {
            throw new SigningServiceException(SIGNING_MODULE, "signing.service.decode.failed", (Throwable)e);
        }
    }

    public static String readFieldFromMetadataString(String metadataString, String metadataKey) {
        String prefix = metadataKey + METADATA_KEY_VALUE_DELIMITER;
        int idx = metadataString.lastIndexOf(prefix);
        int fieldEnd = metadataString.indexOf(METADATA_ENTRY_DELIMITER, idx);
        if (fieldEnd < 0) {
            fieldEnd = metadataString.length();
        }
        if (idx >= 0 && idx < fieldEnd) {
            return metadataString.substring(idx + prefix.length(), fieldEnd);
        }
        return "";
    }

    public static String readUserCommentFromMetadataString(String metadataString) {
        return SigningServiceUtils.readFieldFromMetadataString(metadataString, METADATA_COMMENT_KEY);
    }

    public static String readStationNameFromMetadataString(String metadataString) {
        String stationName = SigningServiceUtils.readFieldFromMetadataString(metadataString, METADATA_STATION_KEY);
        if (stationName.isEmpty()) {
            return LEX.getText(UNKNOWN_STATION);
        }
        return stationName;
    }

    public static String convertMetadataToString(Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return "";
        }
        return metadata.entrySet().stream().sorted(USER_COMMENT_TO_BOTTOM).map(e -> (String)e.getKey() + METADATA_KEY_VALUE_DELIMITER + (String)e.getValue()).collect(Collectors.joining(METADATA_ENTRY_DELIMITER));
    }

    public static boolean isDefaultOrEmptyAlias(String alias) {
        return alias == null || alias.trim().isEmpty() || "default".equals(alias) || DEFAULT_REQUESTER_CERT_ALIAS.equals(alias);
    }

    public static void validateDn(NPKCS10CertificationRequest csr, BCertificateParameter[] csrParameters) throws SigningServiceException {
        X500Name csrDn = csr.getSubjectDN();
        AtomicReference duplicateDnField = new AtomicReference();
        Map<ASN1ObjectIdentifier, RDN> csrAttributes = Arrays.stream(csrDn.getRDNs()).collect(Collectors.toMap(rdn -> rdn.getFirst().getType(), rdn -> rdn, (rdn1, rdn2) -> {
            duplicateDnField.set(rdn1.getFirst().getType().getId());
            return rdn1;
        }));
        String duplicate = (String)duplicateDnField.get();
        if (duplicate != null) {
            throw new SigningServiceException(SIGNING_MODULE, "profile.exception.dupeDn", csrDn);
        }
        ArrayList<RDN> parameterRdns = new ArrayList<RDN>();
        Optional parameterDn = SigningServiceUtils.getValidationParameter(csrParameters, CertificateParameterType.DN);
        if (parameterDn.isPresent()) {
            X500Name requiredDn = new X500Name(((BString)parameterDn.get()).toString());
            parameterRdns.addAll(Arrays.asList(requiredDn.getRDNs()));
        }
        List<BCertificateDnFieldParameter> dnFieldParameters = SigningServiceUtils.getDnFieldValidationParameters(csrParameters);
        for (BCertificateDnFieldParameter dnFieldParameter : dnFieldParameters) {
            ASN1ObjectIdentifier oid = BCStyle.INSTANCE.attrNameToOID(dnFieldParameter.getDnField());
            String value = ((BString)dnFieldParameter.getValue()).getString();
            parameterRdns.add(new RDN(oid, BCStyle.INSTANCE.stringToValue(oid, value)));
        }
        X500Name requiredDn = new X500Name(parameterRdns.toArray(new RDN[0]));
        for (RDN requiredAttribute : requiredDn.getRDNs()) {
            RDN csrAttribute;
            ASN1ObjectIdentifier requiredType = requiredAttribute.getFirst().getType();
            String requiredValue = requiredAttribute.getFirst().getValue().toString();
            if (requiredValue.isEmpty() || requiredAttribute.equals((Object)(csrAttribute = csrAttributes.get(requiredType)))) continue;
            String dnTypeDisplay = BCStyle.INSTANCE.oidToDisplayName(requiredType);
            dnTypeDisplay = dnTypeDisplay == null ? requiredType.toString() : dnTypeDisplay;
            throw new SigningServiceException(SIGNING_MODULE, "profile.exception.missingDnValue", csrDn, dnTypeDisplay + '=' + requiredValue);
        }
    }

    public static void validateCommonNameTemplate(NPKCS10CertificationRequest csr, BCertificateParameter[] csrParameters) throws SigningServiceException {
        boolean cnExists;
        boolean templateExists = Arrays.stream(csrParameters).anyMatch(parameter -> parameter instanceof BCommonNameTemplate);
        if (templateExists && !(cnExists = Arrays.stream(csr.getSubjectDN().getRDNs(BCStyle.CN)).anyMatch(rdn -> !rdn.getFirst().toString().trim().isEmpty()))) {
            throw new SigningServiceException(SIGNING_MODULE, "profile.exception.commonNameTemplate.unresolved", csr.getSubjectDN());
        }
    }

    public static void validateKeyType(NPKCS10CertificationRequest csr, BCertificateParameter[] csrParameters) throws SigningServiceException {
        Optional keyType = SigningServiceUtils.getValidationParameter(csrParameters, CertificateParameterType.KEY_TYPE);
        if (keyType.isPresent()) {
            String csrKeyType = csr.getKeyAlgorithm();
            String paramKeyType = ((BString)keyType.get()).toString();
            if (!paramKeyType.equalsIgnoreCase(csrKeyType)) {
                throw new SigningServiceException(SIGNING_MODULE, "profile.exception.wrongKeyType", csrKeyType, paramKeyType);
            }
        }
    }

    public static void validateKeySize(NPKCS10CertificationRequest csr, BCertificateParameter[] csrParameters) throws SigningServiceException {
        int paramMinKeySize;
        int paramKeySize;
        int csrKeySize = csr.getKeySize();
        Optional keySize = SigningServiceUtils.getValidationParameter(csrParameters, CertificateParameterType.KEY_SIZE);
        if (keySize.isPresent() && (paramKeySize = ((BInteger)keySize.get()).getInt()) != csrKeySize) {
            throw new SigningServiceException(SIGNING_MODULE, "profile.exception.wrongKeySize", csrKeySize, paramKeySize);
        }
        Optional minKeySize = SigningServiceUtils.getValidationParameter(csrParameters, CertificateParameterType.MIN_KEY_SIZE);
        if (minKeySize.isPresent() && (paramMinKeySize = ((BInteger)minKeySize.get()).getInt()) > csrKeySize) {
            throw new SigningServiceException(SIGNING_MODULE, "profile.exception.minKeySize", csrKeySize, paramMinKeySize);
        }
    }

    public static void checkKeyPurpose(NPKCS10CertificationRequest csr, BKeyPurpose keyPurpose) {
        switch (keyPurpose.getValue()) {
            case 0: {
                SigningServiceUtils.checkKeyUsageExtension(csr, 128);
                SigningServiceUtils.checkExtendedKeyUsageExtension(csr, KeyPurposeId.id_kp_clientAuth);
                break;
            }
            case 1: {
                SigningServiceUtils.checkKeyUsageExtension(csr, 128, 32);
                SigningServiceUtils.checkExtendedKeyUsageExtension(csr, KeyPurposeId.id_kp_serverAuth);
                break;
            }
            case 2: {
                SigningServiceUtils.checkKeyUsageExtension(csr, 4, 2);
                SigningServiceUtils.checkBasicConstraintsExtension(csr);
                break;
            }
            case 3: {
                SigningServiceUtils.checkKeyUsageExtension(csr, 128);
                SigningServiceUtils.checkExtendedKeyUsageExtension(csr, KeyPurposeId.id_kp_codeSigning);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized key purpose type: " + keyPurpose.getTag());
            }
        }
    }

    public static void checkKeyUsageExtension(NPKCS10CertificationRequest csr, int ... requiredKeyUsages) {
        try {
            IX509Extension[] extensions = csr.getExtensions();
            NKeyUsage keyUsageExtension = null;
            for (IX509Extension extension : extensions) {
                if (!(extension instanceof NKeyUsage)) continue;
                keyUsageExtension = (NKeyUsage)extension;
                if (CertUtils.checkKeyUsageExtension((NKeyUsage)((NKeyUsage)extension), (int[])requiredKeyUsages)) continue;
                LOG.info("The supplied certificate does not have all required key usages " + Arrays.toString(requiredKeyUsages) + ". The KeyUsage extension will be replaced.");
            }
            if (keyUsageExtension == null) {
                LOG.info("The supplied certificate is missing the KeyUsage extension. This extension will be added during signing.");
            }
        }
        catch (Exception e) {
            LOG.warning("Could not parse extensions for the supplied certificate.");
        }
    }

    public static void checkExtendedKeyUsageExtension(NPKCS10CertificationRequest csr, KeyPurposeId ... requiredKeyPurposeIds) {
        try {
            IX509Extension[] extensions = csr.getExtensions();
            NExtendedKeyUsage extendedKeyUsageExtension = null;
            for (IX509Extension extension : extensions) {
                if (!(extension instanceof NExtendedKeyUsage) || CertUtils.checkExtendedKeyUsageExtension((NExtendedKeyUsage)(extendedKeyUsageExtension = (NExtendedKeyUsage)extension), (KeyPurposeId[])requiredKeyPurposeIds)) continue;
                LOG.info("The supplied certificate does not have all required key purpose ids " + Arrays.toString(requiredKeyPurposeIds) + ". The ExtendedKeyUsage extension will be replaced.");
            }
            if (extendedKeyUsageExtension == null) {
                LOG.info("The supplied certificate is missing the ExtendedKeyUsage extension. This extension will be added during signing.");
            }
        }
        catch (Exception e) {
            LOG.warning("Could not parse extensions for the supplied certificate.");
        }
    }

    public static void checkBasicConstraintsExtension(NPKCS10CertificationRequest csr) {
        try {
            IX509Extension[] extensions = csr.getExtensions();
            NBasicConstraints basicConstraintsExtension = null;
            for (IX509Extension extension : extensions) {
                if (!(extension instanceof NBasicConstraints) || CertUtils.checkBasicConstraintsExtension((NBasicConstraints)(basicConstraintsExtension = (NBasicConstraints)extension))) continue;
                LOG.info("The supplied certificate's basic constraint has an incorrect value for isCA. The extension will be replaced.");
            }
            if (basicConstraintsExtension == null) {
                LOG.info("The supplied certificate is missing the BasicConstraints extension. This extension will be added during signing.");
            }
        }
        catch (Exception e) {
            LOG.warning("Could not parse extensions for the supplied certificate.");
        }
    }

    public static <T> Optional<T> getValidationParameter(BCertificateParameter[] csrParameters, CertificateParameterType parameterType) {
        return Arrays.stream(csrParameters).filter(parameter -> parameter.getParameterType().equals(parameterType.name()) && !parameter.isResolvable()).findFirst().map(parameter -> parameter.getValue());
    }

    public static List<BCertificateDnFieldParameter> getDnFieldValidationParameters(BCertificateParameter[] csrParameters) {
        return Arrays.stream(csrParameters).filter(parameter -> parameter.getParameterType().equals(CertificateParameterType.DN_FIELD.name()) && !parameter.isResolvable()).map(parameter -> (BCertificateDnFieldParameter)parameter).collect(Collectors.toList());
    }

    public static String makeExpiringCertSummary(String recSummaryLexKey, int num, BCertificateSigningRecord signingRecord) {
        String subjectDn;
        BX509Certificate certificate = signingRecord.getCertificate();
        if (certificate == null) {
            return null;
        }
        try {
            subjectDn = BX509Certificate.getSubjectDn((String)certificate.encodeToString(), null);
        }
        catch (Exception e) {
            subjectDn = UNKNOWN;
        }
        String userComment = SigningServiceUtils.readUserCommentFromMetadataString(signingRecord.getMetadata());
        if (!userComment.isEmpty()) {
            userComment = ' ' + LEX.getText("signing.store.optionalComment", new Object[]{userComment});
        }
        String stationName = SigningServiceUtils.readStationNameFromMetadataString(signingRecord.getMetadata());
        return LEX.getText(recSummaryLexKey, new Object[]{Integer.toString(num), subjectDn, userComment, signingRecord.getCertificateValidityRange().getEndTime().toString(), signingRecord.getAutoRemovalTime().toString(), signingRecord.getRequesterId(), stationName});
    }
}

