/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.signing.BSigningService;
import java.security.AccessController;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Worker;

public final class SigningRequestWorker {
    private final CoalesceQueue queue = new CoalesceQueue(500);
    private int queuedCount;
    private Worker worker = new Worker((Worker.ITodo)this.queue);

    synchronized void start() {
        if (this.worker == null) {
            this.worker = new Worker((Worker.ITodo)this.queue);
        }
        if (!this.worker.isRunning()) {
            this.worker.start("SigningRequestWorker");
        }
    }

    synchronized void stop() throws Exception {
        if (this.worker != null && this.worker.isRunning()) {
            this.worker.stop();
            this.worker = null;
        }
        this.queue.clear();
    }

    synchronized void enqueue(SigningRequest request) {
        this.queue.enqueue((Object)request);
        ++this.queuedCount;
    }

    public int size() {
        return this.queue.size();
    }

    public int maxSize() {
        return this.queue.maxSize();
    }

    public int queuedCount() {
        return this.queuedCount;
    }

    static class SigningRequest
    implements ICoalesceable,
    Runnable {
        private final BSigningService service;
        private final String requesterId;
        private final String csrPem;
        private final String profileId;

        SigningRequest(BSigningService service, String csrPem, String profileId, String requesterId) {
            this.service = service;
            this.requesterId = requesterId;
            this.csrPem = csrPem;
            this.profileId = profileId;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(() -> {
                this.service.processDequeuedCsr(this.csrPem, this.profileId, this.requesterId);
                return null;
            });
        }

        public Object getCoalesceKey() {
            return this.requesterId;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }
    }
}

