/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.SigningRequestWorker;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BAbstractSigningProfile;
import com.tridium.signing.profile.BProfilesFolder;
import com.tridium.signing.transport.BISigningTransport;
import com.tridium.signing.transport.BSigningTransportFolder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="profiles", type="BProfilesFolder", defaultValue="new BProfilesFolder()"), @NiagaraProperty(name="transports", type="BSigningTransportFolder", defaultValue="new BSigningTransportFolder()")})
public final class BSigningService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property profiles = BSigningService.newProperty((int)0, (BValue)new BProfilesFolder(), null);
    @Generated
    public static final Property transports = BSigningService.newProperty((int)0, (BValue)new BSigningTransportFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSigningService.class);
    private SigningRequestWorker reqWorker = new SigningRequestWorker();
    private final Map<String, String> profileMap = new ConcurrentHashMap<String, String>();
    private final AtomicInteger processedCount = new AtomicInteger();
    private final AtomicInteger rejectedCount = new AtomicInteger();
    private final AtomicInteger failedBeforeRegistrationCount = new AtomicInteger();
    private static final BIcon ICON = BIcon.std((String)"keys.png");

    @Generated
    public BProfilesFolder getProfiles() {
        return (BProfilesFolder)this.get(profiles);
    }

    @Generated
    public void setProfiles(BProfilesFolder v) {
        this.set(profiles, (BValue)v, null);
    }

    @Generated
    public BSigningTransportFolder getTransports() {
        return (BSigningTransportFolder)this.get(transports);
    }

    @Generated
    public void setTransports(BSigningTransportFolder v) {
        this.set(transports, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "certSigningService");
    }

    public void started() throws Exception {
        this.startWorkerInstance();
        if (Sys.isStation() && this.isOperational()) {
            this.buildProfileIndex();
        }
    }

    public void stopped() throws Exception {
        if (Sys.isStation() && this.reqWorker != null) {
            this.reqWorker.stop();
            this.reqWorker = null;
        }
    }

    public void enabled() {
        this.startWorkerInstance();
        if (Sys.isStation()) {
            this.buildProfileIndex();
        }
    }

    protected void disabled() {
        this.profileMap.clear();
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps("Signing Service Metrics");
        out.prop((Object)"Queued count", this.reqWorker.queuedCount());
        out.prop((Object)"Current queue size", this.reqWorker.size());
        out.prop((Object)"Max queue size", this.reqWorker.maxSize());
        out.prop((Object)"Processed CSR count", this.processedCount.get());
        out.prop((Object)"Rejected CSR count", this.rejectedCount.get());
        out.prop((Object)"Failed before registration CSR count", this.failedBeforeRegistrationCount.get());
        out.prop((Object)"Profile map size", this.profileMap.size());
        out.endProps();
    }

    public void registerRequester(String profileId, String requesterId, String metadata, boolean renewal) throws SigningServiceException {
        try {
            SigningServiceUtils.checkRequestPermitted();
            SigningServiceUtils.checkRequesterId(requesterId);
            BAbstractSigningProfile profile = this.findProfile(profileId);
            this.profileMap.put(requesterId, profileId);
            profile.registerRequester(requesterId, metadata, renewal);
        }
        catch (SigningServiceException e) {
            this.failedBeforeRegistrationCount.incrementAndGet();
            throw e;
        }
    }

    public void processCsr(String csrPem, String profileId, String requesterId, String metadata, boolean renewal) throws SigningServiceException {
        this.registerRequester(profileId, requesterId, metadata, renewal);
        try {
            this.reqWorker.enqueue(new SigningRequestWorker.SigningRequest(this, csrPem, profileId, requesterId));
        }
        catch (Exception e) {
            BAbstractSigningProfile profile = this.findProfile(profileId);
            this.rejectRecord(requesterId, profile, "signing.service.enqueue.failed", e);
        }
    }

    void processDequeuedCsr(String csrPem, String profileId, String requesterId) {
        BAbstractSigningProfile profile = null;
        try {
            profile = this.findProfile(profileId);
            profile.getRecord(requesterId).orElseThrow(() -> new SigningServiceException("signingService", "signing.service.retrieve.failed", requesterId));
            if (this.isOperational()) {
                NPKCS10CertificationRequest csr = SigningServiceUtils.decodeCsr(csrPem);
                profile.validateCsr(csr);
                profile.signCertificate(csr, requesterId);
                for (BISigningTransport transport : (BISigningTransport[])this.getTransports().getChildren(BISigningTransport.class)) {
                    try {
                        transport.certificateSignedForRequester(requesterId, profileId);
                    }
                    catch (Throwable t) {
                        SigningServiceUtils.LOG.log(Level.WARNING, "Unexpected error notifying transport of signed cert: " + transport, SigningServiceUtils.LOG.isLoggable(Level.FINE) ? t : null);
                    }
                }
                this.processedCount.incrementAndGet();
            } else {
                this.rejectRecord(requesterId, profile, "signing.service.inoperational", null);
            }
        }
        catch (Exception e) {
            try {
                this.rejectRecord(requesterId, profile, "signing.service.csr.failed", e);
            }
            catch (SigningServiceException ex) {
                SigningServiceUtils.LOG.log(Level.SEVERE, "Failed to reject record for requester: " + requesterId, e);
            }
        }
    }

    public Optional<BCertificateSigningRecord> getRecord(String requesterId) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        SigningServiceUtils.checkRequesterId(requesterId);
        String profileId = this.findProfileId(requesterId).orElseThrow(() -> new SigningServiceException("signingService", "signing.service.requester.notFound", requesterId));
        BAbstractSigningProfile profile = this.findProfile(profileId);
        return profile.getRecord(requesterId);
    }

    public Map<String, BValue> getCsrParameters(String profileId, Context cx) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        BAbstractSigningProfile profile = this.findProfile(profileId);
        return profile.getCsrParameters(cx);
    }

    public Optional<String> findProfileId(String requesterId) {
        return Optional.ofNullable(this.profileMap.get(requesterId));
    }

    public String findProfileIdByName(String profileName) throws SigningServiceException {
        BAbstractSigningProfile[] profiles = (BAbstractSigningProfile[])this.getProfiles().getChildren(BAbstractSigningProfile.class);
        return Arrays.stream(profiles).filter(profile -> profile.getName().equals(profileName)).map(profile -> profile.getProfileId()).findFirst().orElseThrow(() -> new SigningServiceException("signingService", "signing.service.profile.notFound", profileName));
    }

    public BAbstractSigningProfile findProfile(String profileId) throws SigningServiceException {
        BAbstractSigningProfile[] profiles = (BAbstractSigningProfile[])this.getProfiles().getChildren(BAbstractSigningProfile.class);
        return Arrays.stream(profiles).filter(profile -> profile.getProfileId().equals(profileId)).findFirst().orElseThrow(() -> new SigningServiceException("signingService", "signing.service.profile.notFound", profileId));
    }

    private void buildProfileIndex() {
        BAbstractSigningProfile[] profiles = (BAbstractSigningProfile[])this.getProfiles().getChildren(BAbstractSigningProfile.class);
        Arrays.stream(profiles).forEach(profile -> {
            try {
                this.buildProfileIndex((BAbstractSigningProfile)((Object)profile));
            }
            catch (Exception e) {
                SigningServiceUtils.LOG.log(Level.WARNING, "Failed to index profile: " + profile.getProfileId(), e);
            }
        });
    }

    private void buildProfileIndex(BAbstractSigningProfile profile) throws SigningServiceException, PrivilegedActionException {
        Iterator records = AccessController.doPrivileged(() -> profile.getAllRecords());
        while (records.hasNext()) {
            BCertificateSigningRecord record = (BCertificateSigningRecord)((Object)records.next());
            this.profileMap.put(record.getRequesterId(), profile.getProfileId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rejectRecord(String requesterId, BAbstractSigningProfile profile, String reasonLexicon, Exception e) throws SigningServiceException {
        String message = e != null ? SigningServiceUtils.LEX.getText(reasonLexicon, new Object[]{e.getMessage()}) : SigningServiceUtils.LEX.getText(reasonLexicon);
        SigningServiceUtils.LOG.log(Level.WARNING, message, e);
        if (profile != null) {
            try {
                profile.rejectRequester(requesterId, message);
            }
            finally {
                this.rejectedCount.incrementAndGet();
            }
        }
    }

    private void startWorkerInstance() {
        if (Sys.isStation() && this.reqWorker == null) {
            this.reqWorker = new SigningRequestWorker();
        }
        if (this.reqWorker != null && this.isOperational()) {
            this.reqWorker.start();
        }
    }

    public BIcon getIcon() {
        return ICON;
    }
}

