/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.wizard;

import javax.baja.gx.Size;
import javax.baja.ui.BWidget;
import javax.baja.ui.wizard.BWizard;

public abstract class WizardModel {
    public static final int CAN_BACK = 1;
    public static final int CAN_NEXT = 2;
    public static final int CAN_FINISH = 4;
    private BWizard wizard;

    public final BWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(BWizard value) {
        this.wizard = value;
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(300.0, 200.0);
    }

    public abstract String getTitle();

    public abstract void init();

    public abstract void back();

    public abstract void next();

    public boolean finish() {
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public void update(BWidget step, int mode) {
        this.wizard.setCurrentStep(step);
        this.update(mode);
        this.wizard.setDefaultButton(null);
        if ((mode & 4) != 0) {
            this.wizard.setFinishAsDefault();
        } else if ((mode & 2) != 0) {
            this.wizard.setNextAsDefault();
        }
    }

    public void update(int mode) {
        this.wizard.setBackEnabled((mode & 1) != 0);
        this.wizard.setNextEnabled((mode & 2) != 0);
        this.wizard.setFinishEnabled((mode & 4) != 0);
    }
}

