/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import java.util.ArrayList;
import java.util.List;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;

public class TreeSelection
extends BTree.TreeSupport {
    private boolean supressUpdate = false;
    private boolean updatePending = false;
    private List<TreeNode> nodes = new ArrayList<TreeNode>();

    public void select(TreeNode node) {
        this.add(node);
        this.updateTree();
    }

    public void deselectAll() {
        this.clear();
        this.updateTree();
    }

    public void deselect(TreeNode node) {
        this.remove(node);
        this.updateTree();
    }

    public TreeNode getNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.get(0);
    }

    public TreeNode[] getNodes() {
        return this.nodes.toArray(new TreeNode[0]);
    }

    public final TreeSubject getSubject() {
        return this.getSubject(null);
    }

    public TreeSubject getSubject(TreeNode activeNode) {
        return new TreeSubject(this.getTree(), this.getNodes(), activeNode);
    }

    public void updateTree() {
        if (this.supressUpdate) {
            this.updatePending = true;
        } else {
            BTree tree = this.getTree();
            if (tree != null) {
                tree.repaint();
                this.getTree().fireSelectionModified(new BWidgetEvent(1, this.getTree()));
            }
        }
    }

    void supressUpdates(boolean value) {
        if (value) {
            this.supressUpdate = true;
            this.updatePending = false;
        } else {
            this.supressUpdate = false;
            if (this.updatePending) {
                this.updateTree();
            }
            this.updatePending = false;
        }
    }

    public void expanded(TreeNode node) {
    }

    public void collapsed(TreeNode node) {
        int n = 0;
        boolean changed = false;
        while (n < this.nodes.size()) {
            TreeNode selNode = this.nodes.get(n);
            if (selNode.isDescendantOf(node)) {
                this.remove(selNode);
                changed = true;
                continue;
            }
            ++n;
        }
        if (changed) {
            this.updateTree();
        }
    }

    private void add(TreeNode node) {
        if (!this.getTree().getMultipleSelection()) {
            this.clear();
        }
        node.setSelected(true);
        this.nodes.add(node);
    }

    private void clear() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get(i).setSelected(false);
        }
        this.nodes.clear();
    }

    private void remove(TreeNode node) {
        node.setSelected(false);
        this.nodes.remove(node);
    }
}

