/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.transfer;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.ui.transfer.DragRenderer;

public class SimpleDragRenderer
implements DragRenderer {
    public double xCursorOffset = 0.0;
    public double yCursorOffset = 0.0;
    public BImage[] icons;
    public String[] text;
    public BFont font = Theme.widget().getTextFont();
    private RectGeom rect;

    public SimpleDragRenderer(BComponent value) {
        this(new BComponent[]{value});
    }

    public SimpleDragRenderer(BComponent[] values) {
        BImage[] icons = new BImage[values.length];
        String[] text = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            icons[i] = BImage.make((BIcon)values[i].getIcon());
            text[i] = values[i].getDisplayName(null);
        }
        this.init(icons, text);
    }

    public SimpleDragRenderer(BImage[] icons, String[] text) {
        this.init(icons, text);
    }

    public SimpleDragRenderer(String[] text) {
        this.init(null, text);
    }

    public SimpleDragRenderer(BImage icon, String text) {
        this.init(new BImage[]{icon}, new String[]{text});
    }

    public SimpleDragRenderer(String text) {
        this.init(null, new String[]{text});
    }

    public SimpleDragRenderer(Mark mark) {
        String[] text = mark.getNames();
        BObject[] values = mark.getValues();
        BImage[] icons = new BImage[values.length];
        for (int i = 0; i < values.length; ++i) {
            icons[i] = BImage.make((BIcon)values[i].getIcon());
        }
        this.init(icons, text);
    }

    private void init(BImage[] icons, String[] text) {
        this.icons = icons;
        this.text = text;
    }

    @Override
    public RectGeom getDragEffectRectGeom() {
        if (this.rect == null) {
            double h = 16 * this.text.length;
            double w = 0.0;
            for (int i = 0; i < this.text.length; ++i) {
                double linew = 0.0;
                if (this.icons != null) {
                    linew = 20.0;
                }
                w = Math.max(w, linew += this.font.width(this.text[i]));
            }
            this.rect = new RectGeom(this.xCursorOffset, this.yCursorOffset, w, h);
        }
        return new RectGeom((IRectGeom)this.rect);
    }

    @Override
    public void paintDragEffect(Graphics g) {
        g.translate(this.xCursorOffset, this.yCursorOffset);
        g.setFont(this.font);
        g.setBrush(BColor.make((int)100, (int)100, (int)100));
        double fh = this.font.getHeight();
        double y = 0.0;
        for (int i = 0; i < this.text.length; ++i) {
            double tx = 0.0;
            BImage icon = null;
            if (this.icons != null) {
                icon = this.icons[i];
            }
            if (icon != null && !icon.isNull()) {
                g.drawImage(icon.getDisabledImage(), 0.0, y);
                tx = 20.0;
            }
            String text = this.text[i];
            g.drawString(text, tx, y + fh - 2.0);
            y += 16.0;
        }
        g.translate(-this.xCursorOffset, -this.yCursorOffset);
    }
}

