/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.parsers;

import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class JavaScriptParser
extends TextParser {
    @Override
    protected Segment nextSegment() {
        Segment whitespace = this.parseWhitespace();
        if (whitespace != null) {
            return whitespace;
        }
        int c = this.current;
        if (c == 123 || c == 125 || c == 40 || c == 41 || c == 91 || c == 93) {
            this.advance();
            return this.newSegment(8);
        }
        if (Character.isJavaIdentifierStart((char)c)) {
            Segment id = this.parseIdentifier();
            if (this.isKeyword(id)) {
                return new Segment(6, 8, id.offset, id.length);
            }
            return id;
        }
        if (c == 47 && this.next == 47) {
            this.advance();
            this.advance();
            return this.newSegment(10);
        }
        if (c == 47 && this.next == 42) {
            this.advance();
            this.advance();
            int mods = 16;
            if (this.current == 42) {
                this.advance();
                mods = 0;
            }
            return this.newSegment(11, mods);
        }
        if (c == 42 && this.next == 47) {
            this.advance();
            this.advance();
            return this.newSegment(12);
        }
        if (!(c != 34 && c != 39 || this.last == 92 && this.lastLast != 92)) {
            this.advance();
            return this.newSegment(9);
        }
        if (48 <= c && c <= 57 || c == 45 && 48 <= this.next && this.next <= 57) {
            return this.parseNumberLiteral();
        }
        this.advance();
        while (this.isSymbol(this.current) && this.advance()) {
        }
        return this.newSegment(0);
    }

    private Segment parseIdentifier() {
        while (Character.isJavaIdentifierPart((char)this.current)) {
            this.advance();
        }
        return this.newSegment(5, 8);
    }

    private boolean isKeyword(Segment seg) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                return this.isKeyword(seg, "abstract");
            }
            case 'b': {
                if (this.isKeyword(seg, "boolean")) {
                    return true;
                }
                if (this.isKeyword(seg, "break")) {
                    return true;
                }
                return this.isKeyword(seg, "byte");
            }
            case 'c': {
                if (this.isKeyword(seg, "case")) {
                    return true;
                }
                if (this.isKeyword(seg, "catch")) {
                    return true;
                }
                if (this.isKeyword(seg, "char")) {
                    return true;
                }
                if (this.isKeyword(seg, "class")) {
                    return true;
                }
                if (this.isKeyword(seg, "continue")) {
                    return true;
                }
                return this.isKeyword(seg, "const");
            }
            case 'd': {
                if (this.isKeyword(seg, "debugger")) {
                    return true;
                }
                if (this.isKeyword(seg, "default")) {
                    return true;
                }
                if (this.isKeyword(seg, "delete")) {
                    return true;
                }
                if (this.isKeyword(seg, "do")) {
                    return true;
                }
                return this.isKeyword(seg, "double");
            }
            case 'e': {
                if (this.isKeyword(seg, "enum")) {
                    return true;
                }
                if (this.isKeyword(seg, "else")) {
                    return true;
                }
                return this.isKeyword(seg, "extends");
            }
            case 'f': {
                if (this.isKeyword(seg, "false")) {
                    return true;
                }
                if (this.isKeyword(seg, "final")) {
                    return true;
                }
                if (this.isKeyword(seg, "finally")) {
                    return true;
                }
                if (this.isKeyword(seg, "float")) {
                    return true;
                }
                if (this.isKeyword(seg, "for")) {
                    return true;
                }
                return this.isKeyword(seg, "function");
            }
            case 'g': {
                return this.isKeyword(seg, "goto");
            }
            case 'i': {
                if (this.isKeyword(seg, "if")) {
                    return true;
                }
                if (this.isKeyword(seg, "in")) {
                    return true;
                }
                if (this.isKeyword(seg, "implements")) {
                    return true;
                }
                if (this.isKeyword(seg, "import")) {
                    return true;
                }
                if (this.isKeyword(seg, "instanceof")) {
                    return true;
                }
                if (this.isKeyword(seg, "int")) {
                    return true;
                }
                return this.isKeyword(seg, "interface");
            }
            case 'l': {
                return this.isKeyword(seg, "long");
            }
            case 'n': {
                if (this.isKeyword(seg, "native")) {
                    return true;
                }
                if (this.isKeyword(seg, "new")) {
                    return true;
                }
                return this.isKeyword(seg, "null");
            }
            case 'p': {
                if (this.isKeyword(seg, "package")) {
                    return true;
                }
                if (this.isKeyword(seg, "private")) {
                    return true;
                }
                if (this.isKeyword(seg, "protected")) {
                    return true;
                }
                return this.isKeyword(seg, "public");
            }
            case 'r': {
                return this.isKeyword(seg, "return");
            }
            case 's': {
                if (this.isKeyword(seg, "short")) {
                    return true;
                }
                if (this.isKeyword(seg, "static")) {
                    return true;
                }
                if (this.isKeyword(seg, "super")) {
                    return true;
                }
                if (this.isKeyword(seg, "switch")) {
                    return true;
                }
                return this.isKeyword(seg, "synchronized");
            }
            case 't': {
                if (this.isKeyword(seg, "this")) {
                    return true;
                }
                if (this.isKeyword(seg, "throw")) {
                    return true;
                }
                if (this.isKeyword(seg, "throws")) {
                    return true;
                }
                if (this.isKeyword(seg, "transient")) {
                    return true;
                }
                if (this.isKeyword(seg, "true")) {
                    return true;
                }
                if (this.isKeyword(seg, "try")) {
                    return true;
                }
                return this.isKeyword(seg, "typeof");
            }
            case 'v': {
                if (this.isKeyword(seg, "var")) {
                    return true;
                }
                if (this.isKeyword(seg, "void")) {
                    return true;
                }
                return this.isKeyword(seg, "volatile");
            }
            case 'w': {
                if (this.isKeyword(seg, "while")) {
                    return true;
                }
                return this.isKeyword(seg, "with");
            }
        }
        return false;
    }

    private boolean isKeyword(Segment seg, String s) {
        int len = seg.length;
        if (len != s.length()) {
            return false;
        }
        char[] buf = this.buffer;
        int start = this.segmentStart;
        for (int i = 1; i < len; ++i) {
            if (s.charAt(i) == buf[start + i]) continue;
            return false;
        }
        return true;
    }

    private Segment parseNumberLiteral() {
        int c;
        this.advance();
        if (this.last == 48 && (this.current == 120 || this.current == 88)) {
            this.advance();
        }
        while (48 <= (c = this.current) && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70 || c == 108 || c == 76 || c == 46 || c == 45 && this.last == 101) {
            this.advance();
        }
        return this.newSegment(4, 8);
    }

    private boolean isSymbol(int c) {
        switch (c) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }
}

