/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.MoveCommand;

public class PageUp
extends MoveCommand {
    public PageUp(BTextEditor editor) {
        super(editor, BKeyBindings.pageUp);
    }

    @Override
    public CommandArtifact doInvoke() throws Exception {
        Line targetLine;
        Position cur = this.editor.getCaretPosition();
        int visible = this.editor.getVisibleLineCount();
        int targetLineNumber = Math.max(cur.line - visible - 1, 0);
        Line curLine = this.editor.getModel().getLine(cur.line);
        if (curLine == (targetLine = this.editor.getModel().getLine(targetLineNumber))) {
            return null;
        }
        double caretX = this.editor.getRenderer().getLineWidth(curLine, 0, cur.column);
        int targetColumn = this.editor.getRenderer().xToColumn(targetLine, caretX + 1.0);
        Position to = new Position(targetLineNumber, targetColumn);
        return this.move(cur, to);
    }
}

