/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table.binding;

import com.tridium.sys.Nre;
import java.util.HashMap;
import java.util.Map;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.ui.BBinding;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.binding.BTableBinding;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

public class BoundTableModel
extends TableModel {
    private Row[] rows;
    private Map<Integer, ColumnInfo> cols;
    private Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.rows == null) {
                return 0;
            }
            return this.rows.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.cols == null) {
                return 0;
            }
            return this.cols.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int col) {
        Object object = this.monitor;
        synchronized (object) {
            ColumnInfo colInfo = this.cols.get(col);
            return colInfo.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int col) {
        Object object = this.monitor;
        synchronized (object) {
            return this.rows[row].get(row, col);
        }
    }

    @Override
    public boolean isColumnSortable(int col) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sortByColumn(int col, boolean ascending) {
        Object object = this.monitor;
        synchronized (object) {
            Object[] keys = new Object[this.rows.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.rows[i].get(i, col);
            }
            SortUtil.sort((Object[])keys, (Object[])this.rows, (boolean)ascending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebind() {
        BBinding[] bindings = this.getTable().getBindings();
        BasicContext cx = null;
        int n = 0;
        RowSet[] sets = new RowSet[bindings.length];
        for (int i = 0; i < bindings.length; ++i) {
            BTableBinding binding;
            if (!(bindings[i] instanceof BTableBinding) || !(binding = (BTableBinding)bindings[i]).isBound()) continue;
            BITable t = (BITable)binding.get();
            if (cx == null) {
                cx = new BasicContext(binding.getTarget().getUser(), binding.getTarget().getLanguage());
            }
            sets[n++] = new RowSet((BIRandomAccessTable<BIObject>)Tables.slurp((BITable)t));
        }
        int rowCount = 0;
        for (int i = 0; i < n; ++i) {
            RowSet set = sets[i];
            set.offset = rowCount;
            set.size = set.table.size();
            rowCount += set.size;
        }
        Row[] rows = new Row[rowCount];
        for (int i = 0; i < n; ++i) {
            RowSet set = sets[i];
            for (int j = 0; j < set.size; ++j) {
                rows[set.offset + j] = new Row(set, j);
            }
        }
        HashMap<String, ColumnInfo> colsByName = new HashMap<String, ColumnInfo>();
        HashMap<Integer, ColumnInfo> colsByIndex = new HashMap<Integer, ColumnInfo>();
        for (int i = 0; i < n; ++i) {
            ColumnList colList = sets[i].table.getColumns();
            for (int j = 0; j < colList.size(); ++j) {
                Column col = colList.get(j);
                String name = col.getName();
                if (colsByName.get(name) != null) continue;
                ColumnInfo colInfo = new ColumnInfo(col, colsByName.size(), (Context)cx);
                colsByName.put(name, colInfo);
                colsByIndex.put(colInfo.index, colInfo);
            }
        }
        int colCount = colsByName.size();
        for (int i = 0; i < n; ++i) {
            RowSet set = sets[i];
            set.colMap = new ColumnInfo[colCount];
            ColumnList colList = sets[i].table.getColumns();
            for (int j = 0; j < colList.size(); ++j) {
                ColumnInfo colInfo;
                Column column = colList.get(j);
                String name = column.getName();
                set.colMap[((ColumnInfo)colInfo).index] = colInfo = (ColumnInfo)colsByName.get(name);
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            this.rows = rows;
            this.cols = colsByIndex;
        }
        this.updateTable();
    }

    private static class Row {
        RowSet set;
        int rowIndex;

        Row(RowSet set, int rowIndex) {
            this.set = set;
            this.rowIndex = rowIndex;
        }

        public final Object get(int modelRow, int modelCol) {
            ColumnInfo tableColInfo = this.set.colMap[modelCol];
            if (tableColInfo == null) {
                return "";
            }
            BIObject obj = this.set.table.get(this.rowIndex).cell(tableColInfo.col);
            if (obj != null) {
                return obj.toString(tableColInfo.cx);
            }
            return obj;
        }
    }

    private static class RowSet {
        BIRandomAccessTable<BIObject> table;
        int size;
        int offset;
        ColumnInfo[] colMap;

        RowSet(BIRandomAccessTable<BIObject> table) {
            this.table = table;
        }
    }

    private static final class ColumnInfo {
        private int index;
        private Column col;
        private Context cx;

        ColumnInfo(Column col, int index, Context cx) {
            this.col = col;
            this.index = index;
            this.cx = new BasicContext(cx, col.getFacets());
        }

        String getDisplayName() {
            BUnit unit;
            String displayName = this.col.getDisplayName(this.cx);
            BFacets facets = this.col.getFacets();
            if (facets != null && !facets.isNull() && (unit = (BUnit)facets.get("units")) != null && !unit.isNull()) {
                int convert = Nre.unitConversion;
                if ((convert = facets.geti("unitConversion", convert)) != 0) {
                    unit = BUnitConversion.make((int)convert).getDesiredUnit(unit);
                }
                displayName = displayName + " (" + unit.getSymbol() + ")";
            }
            return displayName;
        }
    }
}

