/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.px;

import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;

public class PxProperty {
    private String name;
    private BTypeSpec type;
    private BValue value;
    private SlotPath[] targets;
    private OrdTarget[] resolved;

    public PxProperty(String name, BTypeSpec type, BValue value, SlotPath[] targets) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.targets = targets;
    }

    public void apply(BComponent base) {
        this.apply(base, null);
    }

    public void apply(BComponent base, BValue override) {
        int i;
        if (this.resolved == null) {
            this.resolved = new OrdTarget[this.targets.length];
            for (i = 0; i < this.resolved.length; ++i) {
                this.resolved[i] = BOrd.make((OrdQuery)this.targets[i]).resolve((BObject)base);
            }
        }
        for (i = 0; i < this.resolved.length; ++i) {
            BValue v = override != null ? override : this.value;
            BComponent comp = this.resolved[i].getComponent();
            Property prop = (Property)this.resolved[i].getSlotInComponent();
            comp.set(prop, v);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BTypeSpec getTypeSpec() {
        return this.type;
    }

    public BValue getValue() {
        return this.value;
    }

    public void setValue(BValue value) {
        this.value = value;
    }

    public SlotPath[] getTargets() {
        return this.targets;
    }

    public void setTargets(SlotPath[] targets) {
        this.targets = targets;
        this.resolved = null;
    }

    public String toString() {
        return "PxProperty[name:" + this.name + ",type:" + this.type + ",value:" + this.value + ",targets:" + new Array((Object[])this.targets) + "]";
    }
}

