/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.options;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.list.BList;
import javax.baja.ui.options.BMruOptions;

@NiagaraType
public class BMruTextDropDown
extends BTextDropDown {
    @Generated
    public static final Type TYPE = Sys.loadType(BMruTextDropDown.class);
    private String mruName;
    private IFilter filter = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMruTextDropDown(String mruName) {
        this.mruName = mruName;
        this.setTextFromMruOptions();
    }

    public BMruTextDropDown(String mruName, int visibleColumns) {
        this.getEditor().setVisibleColumns(visibleColumns);
        this.mruName = mruName;
        this.setTextFromMruOptions();
    }

    public BMruTextDropDown(String mruName, String text, int visibleColumns, boolean editable) {
        super(text, visibleColumns, editable);
        this.mruName = mruName;
    }

    public BMruTextDropDown() {
        this(null);
    }

    public String getMruOptionsName() {
        return this.mruName;
    }

    public void setMruOptionsName(String mruName) {
        this.mruName = mruName;
    }

    public BMruOptions getMruOptions() {
        return BMruOptions.make(this.getMruOptionsName());
    }

    public String getTextAndSave() {
        String text = this.getText();
        if (text.length() > 0) {
            this.getMruOptions().save(text);
        }
        return text;
    }

    public void setTextFromMruOptions() {
        if (this.mruName == null) {
            return;
        }
        String[] history = this.getMruOptions().getHistory(this.filter);
        if (history.length == 0) {
            this.setText("");
        } else {
            this.setText(history[0]);
        }
    }

    public void setListFromMruOptions() {
        BList list = this.getList();
        list.removeAllItems();
        String[] mru = this.getMruOptions().getHistory(this.filter);
        for (int i = 0; i < mru.length; ++i) {
            list.addItem(mru[i]);
        }
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    @Override
    public void doOpenDropDown() {
        this.setListFromMruOptions();
        super.doOpenDropDown();
    }
}

