/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.options;

import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.options.BIMruWidget;
import javax.baja.ui.options.BMruOptions;

@NiagaraType
public class BMruButton
extends BButton
implements BIMruWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BMruButton.class);
    private static BImage icon = BImage.make((String)"module://icons/x16/recent.png");
    private MruController controller;
    private String mruName;
    private IFilter filter = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMruButton(String mruName) {
        this(mruName, (IFilter)null);
    }

    public BMruButton(String mruName, IFilter filter) {
        super(icon);
        this.mruName = mruName;
        this.setFilter(filter);
        this.setMruController(new MruController());
        this.setMenuController(new MenuController());
    }

    public BMruButton() {
        this((String)null);
    }

    public MruController getMruController() {
        return this.controller;
    }

    public void setMruController(MruController c) {
        this.controller = c;
    }

    @Override
    public String getMruOptionsName() {
        return this.mruName;
    }

    @Override
    public void setMruOptionsName(String mruName) {
        this.mruName = mruName;
    }

    @Override
    public BMruOptions getMruOptions() {
        return BMruOptions.make(this.getMruOptionsName());
    }

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    private class Entry
    extends Command {
        private String value;

        public Entry(BWidget owner, String value) {
            super(owner, BMruButton.this.controller.toDisplayString(value));
            this.value = value;
        }

        @Override
        public CommandArtifact doInvoke() {
            BMruButton.this.controller.select(this.value);
            return null;
        }
    }

    private class MenuController
    implements BAbstractButton.MenuController {
        private MenuController() {
        }

        @Override
        public boolean isMenuDistinct() {
            return false;
        }

        @Override
        public BMenu getMenu(BAbstractButton b) {
            BMenu menu = new BMenu();
            String[] v = BMruButton.this.getMruOptions().getHistory(BMruButton.this.filter);
            for (int i = 0; i < v.length; ++i) {
                menu.add(null, new Entry(BMruButton.this, v[i]));
            }
            return menu;
        }
    }

    public static class MruController {
        public String toDisplayString(String value) {
            return value;
        }

        public void select(String value) {
        }
    }
}

