/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.event;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BInputEvent;

@NiagaraType
public class BMouseEvent
extends BInputEvent {
    @Generated
    public static final Type TYPE = Sys.loadType(BMouseEvent.class);
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public static final int MOUSE_PULSED = 510;
    public static final int MOUSE_DRAG_STARTED = 511;
    public static final int MOUSE_HOVER = 512;
    private double x;
    private double y;
    private int clickCount;
    private boolean isPopupTrigger;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMouseEvent(int id, BWidget source, int modifiers, double x, double y, int clickCount, boolean isPopupTrigger) {
        super(id, source, modifiers);
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.isPopupTrigger = isPopupTrigger;
    }

    public BMouseEvent(int id, BWidget source, long when, int modifiers, double x, double y, int clickCount, boolean isPopupTrigger) {
        super(id, source, when, modifiers);
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.isPopupTrigger = isPopupTrigger;
    }

    public BMouseEvent() {
    }

    @Override
    protected void setNewModifiers() {
        super.setNewModifiers();
        if ((this.modifiers & 8) != 0) {
            this.modifiers |= 0x800;
        }
        if ((this.modifiers & 4) != 0) {
            this.modifiers |= 0x1000;
        }
    }

    @Override
    protected void setOldModifiers() {
        super.setOldModifiers();
        if ((this.modifiers & 0x800) != 0) {
            this.modifiers |= 8;
        }
        if ((this.modifiers & 0x1000) != 0) {
            this.modifiers |= 4;
        }
    }

    public boolean isButton1Down() {
        return (this.getModifiersEx() & 0x400) != 0;
    }

    public boolean isButton2Down() {
        return (this.getModifiersEx() & 0x800) != 0;
    }

    public boolean isButton3Down() {
        return (this.getModifiersEx() & 0x1000) != 0;
    }

    public boolean isButton4Down() {
        return (this.getModifiersEx() & 0x4000) != 0;
    }

    public boolean isButton5Down() {
        return (this.getModifiersEx() & 0x8000) != 0;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public boolean isPopupTrigger() {
        return this.isPopupTrigger;
    }

    public String toString(Context cx) {
        if (this.getWidget() == null) {
            return "null";
        }
        String id = "?";
        switch (this.getId()) {
            case 501: {
                id = "MousePressed";
                break;
            }
            case 502: {
                id = "MouseReleased";
                break;
            }
            case 503: {
                id = "MouseMoved";
                break;
            }
            case 504: {
                id = "MouseEntered";
                break;
            }
            case 505: {
                id = "MouseExited";
                break;
            }
            case 506: {
                id = "MouseDragged";
                break;
            }
            case 507: {
                id = "MouseWheel";
                break;
            }
            case 510: {
                id = "MousePulsed";
                break;
            }
            case 511: {
                id = "MouseDragStarted";
                break;
            }
            case 512: {
                id = "MouseHover";
            }
        }
        return id + " src=" + this.getWidget().getType() + " pt=" + BDouble.toString((double)this.x, null) + "," + BDouble.toString((double)this.y, null) + " mods=" + this.modifiersToString();
    }

    @Override
    public String modifiersToString() {
        StringBuilder sb = new StringBuilder(super.modifiersToString());
        if (this.isButton1Down()) {
            sb.append(" 1");
        }
        if (this.isButton2Down()) {
            sb.append(" 2");
        }
        if (this.isButton3Down()) {
            sb.append(" 3");
        }
        if (this.isButton4Down()) {
            sb.append(" 4");
        }
        if (this.isButton5Down()) {
            sb.append(" 5");
        }
        return sb.toString().trim();
    }
}

