/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step.util;

import com.tridium.ui.wizard.step.IWidgetWizardView;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WizardStep;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.Context;
import javax.baja.ui.BBorder;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.wizard.BWizardHeader;

public final class WizardHeaderUiHandler
implements WizardStep.IUiHandler {
    private BImage image;
    private String title;
    private String description;
    private WizardStep.IUiHandler handler;
    public static final BImage defaultImg = BImage.make((String)"module://icons/x32/wizard.png");

    public WizardHeaderUiHandler(BImage image, String title, WizardStep.IUiHandler handler) {
        this(image, title, "", handler);
    }

    public WizardHeaderUiHandler(BImage image, String title, String description, WizardStep.IUiHandler handler) {
        this.image = image;
        this.title = title;
        this.description = description;
        this.handler = handler;
    }

    @Override
    public StepArtifact create(WizardStep step, StepModel model, IWizardView view, Context cx) {
        this.addWizardHeader(view);
        return this.handler.create(step, model, view, cx);
    }

    @Override
    public void detach(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        this.removeWizardHeader(view);
        this.handler.detach(artifact, model, view, cx);
    }

    @Override
    public StepArtifact updateStepArtifact(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        return this.handler.updateStepArtifact(artifact, model, view, cx);
    }

    @Override
    public boolean restoreFromNext(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        this.addWizardHeader(view);
        return this.handler.restoreFromNext(artifact, model, view, cx);
    }

    @Override
    public boolean restoreFromBack(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        this.addWizardHeader(view);
        return this.handler.restoreFromBack(artifact, model, view, cx);
    }

    private void addWizardHeader(IWizardView view) {
        BWizardHeader header = new BWizardHeader(this.image, this.title, this.description);
        ((IWidgetWizardView)view).setWizardHeader(new BBorderPane((BWidget)header, BBorder.inset, BInsets.DEFAULT));
    }

    private void removeWizardHeader(IWizardView view) {
        ((IWidgetWizardView)view).setWizardHeader(new BNullWidget());
    }

    public BImage getImage() {
        return this.image;
    }

    public void setImage(BImage image) {
        this.image = image;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WizardStep.IUiHandler getUiHandler() {
        return this.handler;
    }

    public void setUiHandler(WizardStep.IUiHandler handler) {
        this.handler = handler;
    }
}

