/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import com.tridium.file.util.PxFileUtil;
import com.tridium.ui.util.ValidationUtil;
import java.io.OutputStream;
import java.util.Map;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.util.BTypeSpec;

public final class MediaUtil {
    private MediaUtil() {
    }

    public static BTypeSpec getMedia(OrdTarget target, Context cx) throws Exception {
        BObject o = target.get();
        if (o instanceof BPxFile) {
            return BTypeSpec.make((String)PxFileUtil.getMedia((BPxFile)((BPxFile)o)));
        }
        BAbstractPxView pxView = MediaUtil.getAbstractPxView(target, cx);
        if (pxView != null) {
            return pxView.getMedia();
        }
        return BTypeSpec.make((String)"workbench:WbPxMedia");
    }

    public static void setMedia(OrdTarget target, String mediaType, boolean preserveIdentities, Context cx) throws Exception {
        BObject o = target.get();
        BAbstractPxView pxView = MediaUtil.getAbstractPxView(target, cx);
        Type type = BTypeSpec.make((String)mediaType).getResolvedType();
        if (!type.is(BPxMedia.TYPE)) {
            throw new LocalizableException("bajaui", "media.unknownMedia");
        }
        if (pxView != null) {
            if (Flags.isReadonly((BComplex)pxView, (Slot)pxView.getProperty(BAbstractPxView.media.getName()))) {
                throw new LocalizableException("bajaui", "media.readonly");
            }
            pxView.set(BPxView.media, (BValue)BTypeSpec.make((String)mediaType), cx);
        } else if (pxView == null && o instanceof BPxFile) {
            if (o.toString().contains("^nstations/")) {
                throw new LocalizableException("bajaui", "media.readonly");
            }
            MediaUtil.setMediaInPxFile((BPxFile)o, BTypeSpec.make((String)mediaType), preserveIdentities, cx);
        } else {
            throw new LocalizableException("bajaui", "media.unknownMedia");
        }
    }

    public static String getValidationWarnings(BTypeSpec mediaType, OrdTarget target, Context cx) throws Exception {
        StringBuilder b = new StringBuilder();
        BPxMedia media = (BPxMedia)mediaType.getResolvedType().getInstance();
        Map<String, String> warnings = ValidationUtil.getValidationWarnings(media, target, MediaUtil.getAbstractPxView(target, cx), cx);
        warnings.forEach((ord, message) -> {
            b.append((String)message);
            b.append("\n");
        });
        return b.toString();
    }

    public static BAbstractPxView getAbstractPxView(OrdTarget target, Context cx) throws Exception {
        BObject object = target.get();
        BAbstractPxView pxView = null;
        if (object instanceof BComponent) {
            AgentInfo info = null;
            ViewQuery viewQuery = target.getViewQuery();
            AgentList list = object.getAgents(cx);
            if (viewQuery != null && viewQuery.getViewId() != null && !viewQuery.getViewId().isEmpty()) {
                info = list.get(viewQuery.getViewId());
            } else if ((list = list.filter(AgentFilter.is((Type)BAbstractPxView.TYPE))).size() > 0) {
                info = list.filter(AgentFilter.is((Type)BAbstractPxView.TYPE)).getDefault();
            }
            if (info instanceof BAbstractPxView) {
                pxView = (BAbstractPxView)info;
            }
        }
        return pxView;
    }

    public static void setMediaInPxFile(BPxFile pxFile, BTypeSpec media, boolean preserveIdentities, Context cx) throws Exception {
        BFileSystem.INSTANCE.checkWritePermission(pxFile.getFilePath(), cx);
        PxDecoder decoder = new PxDecoder((BIFile)pxFile, cx);
        BWidget widget = decoder.decodeDocument(true);
        try (OutputStream out = pxFile.getOutputStream();){
            new PxEncoder(out).setPreserveIdentities(preserveIdentities).encodeDocumentWithMedia(widget, decoder.getPxProperties(), decoder.getPxLayers(), media);
        }
    }
}

