/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.WidgetTheme;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.enums.BOrientation;

public class PalladiumThemeUtils {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;

    public static void paintThumb(WidgetTheme theme, Graphics g, BOrientation orientation, RectGeom r) {
        block13: {
            double sz;
            double ib;
            double numi;
            double is;
            double ih;
            double iw;
            double iy;
            double ix;
            double h;
            double w;
            double y;
            double x;
            block12: {
                if (orientation == BOrientation.vertical) {
                    x = r.x + 1.0;
                    y = r.y;
                    w = r.width - 3.0;
                    h = r.height - 1.0;
                } else {
                    x = r.x;
                    y = r.y + 1.0;
                    w = r.width - 1.0;
                    h = r.height - 3.0;
                }
                if (w <= 0.0 || h <= 0.0) {
                    return;
                }
                g.setBrush(theme.getControlForeground());
                if (orientation == BOrientation.vertical) {
                    g.strokeRect(r.x, r.y - 1.0, r.width - 1.0, r.height + 1.0);
                } else {
                    g.strokeRect(r.x - 1.0, r.y, r.width + 1.0, r.height - 1.0);
                }
                g.setBrush(theme.getControlBackground());
                g.fillRect(x + 1.0, y + 1.0, w - 1.0, h - 1.0);
                g.setBrush(theme.getControlHighlight());
                g.strokeLine(x, y, x + w, y);
                g.strokeLine(x, y, x, y + h);
                g.setBrush(theme.getControlShadow());
                g.strokeLine(x + w, y, x + w, y + h);
                g.strokeLine(x, y + h, x + w, y + h);
                ix = 0.0;
                iy = 0.0;
                iw = 0.0;
                ih = 0.0;
                is = 2.0;
                numi = 3.0;
                ib = 3.0;
                sz = 0.0;
                if (orientation != BOrientation.vertical) break block12;
                iw = (int)(w * 0.625);
                ih = 2.0;
                sz = ih * numi + is * (numi - 1.0) + ib + ib;
                while (sz > h && numi != 0.0) {
                    if ((numi -= 1.0) == 1.0) {
                        sz = ih * numi + ib + ib;
                        continue;
                    }
                    sz = ih * numi + is * (numi - 1.0) + ib + ib;
                }
                if (!(numi > 0.0)) break block13;
                ix = x + (w - iw) / 2.0;
                iy = y + ib + (h - sz) / 2.0 + 1.0;
                int j = 0;
                while ((double)j < numi) {
                    g.setBrush(theme.getControlShadow());
                    g.strokeLine(ix, iy, ix + iw - 2.0, iy);
                    g.strokeLine(ix, iy, ix, iy + ih - 1.0);
                    g.setBrush(theme.getControlHighlight());
                    g.strokeLine(ix + iw - 1.0, iy, ix + iw - 1.0, iy + ih - 1.0);
                    g.strokeLine(ix + iw - 1.0, iy + ih - 1.0, ix + 1.0, iy + ih - 1.0);
                    iy += ih + is;
                    ++j;
                }
                break block13;
            }
            iw = 2.0;
            ih = h * 0.625;
            sz = iw * numi + is * (numi - 1.0) + ib + ib;
            while (sz > w && numi != 0.0) {
                if ((numi -= 1.0) == 1.0) {
                    sz = iw * numi + ib + ib;
                    continue;
                }
                sz = iw * numi + is * (numi - 1.0) + ib + ib;
            }
            if (numi > 0.0) {
                ix = x + ib + (w - sz) / 2.0 + 1.0;
                iy = y + (h - ih) / 2.0 + 1.0;
                int j = 0;
                while ((double)j < numi) {
                    g.setBrush(theme.getControlShadow());
                    g.strokeLine(ix, iy, ix + iw - 1.0, iy);
                    g.strokeLine(ix, iy, ix, iy + ih - 1.0);
                    g.setBrush(theme.getControlHighlight());
                    g.strokeLine(ix + iw - 1.0, iy + 1.0, ix + iw - 1.0, iy + ih - 1.0);
                    g.strokeLine(ix + iw - 1.0, iy + ih - 1.0, ix, iy + ih - 1.0);
                    ix += iw + is;
                    ++j;
                }
            }
        }
    }

    public static void paintArrow(Graphics g, int dir, RectGeom r) {
        PalladiumThemeUtils.paintArrow(g, dir, (int)r.x, (int)r.y, (int)r.width, (int)r.height);
    }

    public static void paintArrow(Graphics g, int dir, double x, double y, double w, double h) {
        double aw = 7.0;
        double ah = 4.0;
        switch (dir) {
            case 0: {
                x += (double)Math.round((w - aw) / 2.0);
                y += (double)Math.round((h - ah) / 2.0) + ah / 2.0;
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x + (double)i, y - (double)i, x + aw - (double)i - 1.0, y - (double)i);
                    ++i;
                }
                break;
            }
            case 1: {
                x += (double)Math.round((w - aw) / 2.0);
                y += (double)Math.round((h - ah) / 2.0);
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x + (double)i, y + (double)i, x + aw - (double)i - 1.0, y + (double)i);
                    ++i;
                }
                break;
            }
            case 2: {
                x += (double)Math.round((w - ah) / 2.0) + ah / 2.0;
                y += (double)Math.round((h - aw) / 2.0);
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x - (double)i, y + (double)i, x - (double)i, y + aw - (double)i - 1.0);
                    ++i;
                }
                break;
            }
            case 3: {
                x += (double)Math.round((w - ah) / 2.0);
                y += (double)Math.round((h - aw) / 2.0);
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x + (double)i, y + (double)i, x + (double)i, y + aw - (double)i - 1.0);
                    ++i;
                }
                break;
            }
        }
    }
}

