/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.TableTheme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.util.UiLexicon;

public class PalladiumTableTheme
extends PalladiumWidgetTheme
implements TableTheme {
    static BBrush gridBrush = BColor.make((int)0xCCCCCC).toBrush();
    static BBrush bandBrush = BColor.make((int)220, (int)220, (int)220).toBrush();
    static BBrush categoryBrowserBandBrush = BColor.make((int)255, (int)255, (int)187).toBrush();
    static BBrush cellTableSelectionBackground = BColor.make((int)192, (int)192, (int)255).toBrush();
    static double cellHeight;
    private static final String CATEGORY_BROWSER_CLASS = "category-browser";
    private static final String CELL_TABLE_CLASS = "cell-table";

    @Override
    public BFont getHeaderFont() {
        return boldText;
    }

    @Override
    public BBrush getHeaderTextBrush() {
        return controlForeground;
    }

    @Override
    public double getCellHeight() {
        return cellHeight;
    }

    @Override
    public BFont getCellFont() {
        return plainText;
    }

    @Override
    public BFont getCellFont(IStylable widget) {
        return this.getCellFont();
    }

    @Override
    public BBrush getCellTextBrush() {
        return this.getTextBrush();
    }

    @Override
    public void paintBackground(Graphics g, BWidget w) {
        g.setBrush(this.getWindowBackground());
        g.fillRect(0.0, 0.0, w.getWidth(), w.getHeight());
    }

    @Override
    public void paintHeaderBackground(Graphics g, TableHeaderRenderer.Header header, BBrush bg) {
        double x = 0.0;
        double y = 0.0;
        double w = header.width;
        double h = header.height;
        if (bg != null) {
            g.setBrush(bg);
        } else {
            g.setBrush(this.getControlBackground());
        }
        g.fillRect(x, y, w, h);
        g.setBrush(this.getControlHighlight());
        g.strokeLine(x + 1.0, y + 1.0, x + w - 2.0, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - 2.0);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - 2.0, x + w - 1.0, y + h - 2.0);
        g.setBrush(this.getControlForeground());
        g.strokeRect(x, y, w, h - 1.0);
    }

    @Override
    public double getSortIconWidth() {
        return 8.0;
    }

    @Override
    public void paintSortIcon(Graphics g, TableHeaderRenderer.Header header, boolean ascending) {
        int c = 3;
        double mid = header.width - 8.0;
        double tip = (header.height - (double)c) / 2.0;
        g.setBrush(this.getControlShadow());
        for (int i = 0; i <= c; ++i) {
            if (ascending) {
                g.strokeLine(mid - (double)i, tip + (double)i, mid + (double)i, tip + (double)i);
                continue;
            }
            g.strokeLine(mid - (double)i, tip + (double)c - (double)i, mid + (double)i, tip + (double)c - (double)i);
        }
    }

    @Override
    public BBrush getGridBrush() {
        return gridBrush;
    }

    @Override
    public BBrush getGridBrush(IStylable widget) {
        return gridBrush;
    }

    @Override
    public BBrush getBandBrush() {
        return bandBrush;
    }

    @Override
    public BBrush getBandBrush(IStylable widget) {
        if (StyleUtils.hasStyle(widget, CATEGORY_BROWSER_CLASS)) {
            return categoryBrowserBandBrush;
        }
        return bandBrush;
    }

    @Override
    public BBrush getSelectionForeground(IStylable widget) {
        if (StyleUtils.hasStyle(widget, CELL_TABLE_CLASS)) {
            return this.getTextBrush();
        }
        return super.getSelectionForeground(widget);
    }

    @Override
    public BBrush getSelectionBackground(IStylable widget) {
        if (StyleUtils.hasStyle(widget, CELL_TABLE_CLASS)) {
            return cellTableSelectionBackground;
        }
        return super.getSelectionBackground(widget);
    }

    static {
        UiLexicon lex = UiLexicon.bajaui();
        cellHeight = lex.get("palladium.table.cellheight") != null ? Double.parseDouble(lex.get("palladium.table.cellheight")) : plainText.getHeight() + 3.0;
    }
}

